/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transform Matrix</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Refer to https://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace for the meaning of each matrix member
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getA <em>A</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getB <em>B</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getC <em>C</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getD <em>D</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getE <em>E</em>}</li>
 *   <li>{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getF <em>F</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix()
 * @model
 * @generated
 */
public interface TransformMatrix extends EObject {
	/**
	 * Returns the value of the '<em><b>A</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>A</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>A</em>' attribute.
	 * @see #setA(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_A()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getA();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getA <em>A</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>A</em>' attribute.
	 * @see #getA()
	 * @generated
	 */
	void setA(Double value);

	/**
	 * Returns the value of the '<em><b>B</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>B</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>B</em>' attribute.
	 * @see #setB(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_B()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getB();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getB <em>B</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>B</em>' attribute.
	 * @see #getB()
	 * @generated
	 */
	void setB(Double value);

	/**
	 * Returns the value of the '<em><b>C</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>C</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>C</em>' attribute.
	 * @see #setC(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_C()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getC();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getC <em>C</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>C</em>' attribute.
	 * @see #getC()
	 * @generated
	 */
	void setC(Double value);

	/**
	 * Returns the value of the '<em><b>D</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>D</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>D</em>' attribute.
	 * @see #setD(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_D()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getD();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getD <em>D</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>D</em>' attribute.
	 * @see #getD()
	 * @generated
	 */
	void setD(Double value);

	/**
	 * Returns the value of the '<em><b>E</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>E</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>E</em>' attribute.
	 * @see #setE(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_E()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getE();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getE <em>E</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>E</em>' attribute.
	 * @see #getE()
	 * @generated
	 */
	void setE(Double value);

	/**
	 * Returns the value of the '<em><b>F</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>F</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>F</em>' attribute.
	 * @see #setF(Double)
	 * @see org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.RpyGeometryPackage#getTransformMatrix_F()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Double getF();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.interoperability.rpy.geometry.rpygeometry.TransformMatrix#getF <em>F</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>F</em>' attribute.
	 * @see #getF()
	 * @generated
	 */
	void setF(Double value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" matrixRequired="true" matrixOrdered="false"
	 * @generated
	 */
	TransformMatrix add(TransformMatrix matrix);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false"
	 * @generated
	 */
	TransformMatrix minus();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" matrixRequired="true" matrixOrdered="false"
	 * @generated
	 */
	TransformMatrix minus(TransformMatrix matrix);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" pointRequired="true" pointOrdered="false"
	 * @generated
	 */
	Point multiply(Point point);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model required="true" ordered="false" matrixRequired="true" matrixOrdered="false"
	 * @generated
	 */
	TransformMatrix multiply(TransformMatrix matrix);

} // TransformMatrix
