/**
 *   Copyright (c) 2016 CEA LIST and others.
 *   
 *   All rights reserved. This program and the accompanying materials
 *   are made available under the terms of the Eclipse Public License v1.0
 *   which accompanies this distribution, and is available at
 *   http://www.eclipse.org/legal/epl-v10.html
 *  
 *   Contributors:
 *     CEA LIST - Initial API and implementation
 * 
 */
package org.eclipse.papyrus.interoperability.rpy.rpymetamodel.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.papyrus.interoperability.rpy.rpymetamodel.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class UMLRpyFactoryImpl extends EFactoryImpl implements UMLRpyFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static UMLRpyFactory init() {
		try {
			UMLRpyFactory theUMLRpyFactory = (UMLRpyFactory)EPackage.Registry.INSTANCE.getEFactory(UMLRpyPackage.eNS_URI);
			if (theUMLRpyFactory != null) {
				return theUMLRpyFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new UMLRpyFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UMLRpyFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case UMLRpyPackage.CCOLLABORATION_CHART: return createCCollaborationChart();
			case UMLRpyPackage.CGI_ACTION_STATE: return createCGIActionState();
			case UMLRpyPackage.CGI_ACTIVE_X: return createCGIActiveX();
			case UMLRpyPackage.CGI_ANCHOR: return createCGIAnchor();
			case UMLRpyPackage.CGI_ANNOTATION: return createCGIAnnotation();
			case UMLRpyPackage.CGI_ARROW: return createCGIArrow();
			case UMLRpyPackage.CGI_ASSOCIATION_END: return createCGIAssociationEnd();
			case UMLRpyPackage.CGI_ASSOCIATION_ROLE: return createCGIAssociationRole();
			case UMLRpyPackage.CGI_BASIC_CLASS: return createCGIBasicClass();
			case UMLRpyPackage.CGI_BLOCK_STATE: return createCGIBlockState();
			case UMLRpyPackage.CGI_BOX: return createCGIBox();
			case UMLRpyPackage.CGI_BUTTON_ARRAY: return createCGIButtonArray();
			case UMLRpyPackage.CGI_CLASS: return createCGIClass();
			case UMLRpyPackage.CGI_CLASS_CHART: return createCGIClassChart();
			case UMLRpyPackage.CGI_CLASSIFIER_ROLE: return createCGIClassifierRole();
			case UMLRpyPackage.CGI_COMPARTMENT: return createCGICompartment();
			case UMLRpyPackage.CGI_COMPONENT: return createCGIComponent();
			case UMLRpyPackage.CGI_COMPOSITE_CLASS: return createCGICompositeClass();
			case UMLRpyPackage.CGI_CONNECTOR: return createCGIConnector();
			case UMLRpyPackage.CGI_CONTAIN_ARROW: return createCGIContainArrow();
			case UMLRpyPackage.CGI_DIAGRAM_FRAME: return createCGIDiagramFrame();
			case UMLRpyPackage.CGI_FREE_SHAPE: return createCGIFreeShape();
			case UMLRpyPackage.CGI_FREE_TEXT: return createCGIFreeText();
			case UMLRpyPackage.CGI_GENERIC_ELEMENT: return createCGIGenericElement();
			case UMLRpyPackage.CGI_IMAGE: return createCGIImage();
			case UMLRpyPackage.CGI_IMAGE_DATA: return createCGIImageData();
			case UMLRpyPackage.CGI_INFORMATION_FLOW: return createCGIInformationFlow();
			case UMLRpyPackage.CGI_INHERITANCE: return createCGIInheritance();
			case UMLRpyPackage.CGIMFC_CTRL: return createCGIMFCCtrl();
			case UMLRpyPackage.CGI_MESSAGE_LABEL: return createCGIMessageLabel();
			case UMLRpyPackage.CGI_MSC_CHART: return createCGIMscChart();
			case UMLRpyPackage.CGI_MSC_COLUMN_CR: return createCGIMscColumnCR();
			case UMLRpyPackage.CGI_MSC_CONDITION_MARK: return createCGIMscConditionMark();
			case UMLRpyPackage.CGI_MSC_EXECUTION_OCCURRENCE: return createCGIMscExecutionOccurrence();
			case UMLRpyPackage.CGI_MSC_INTERACTION_OCCURRENCE: return createCGIMscInteractionOccurrence();
			case UMLRpyPackage.CGI_MSC_INTERACTION_OPERAND: return createCGIMscInteractionOperand();
			case UMLRpyPackage.CGI_MSC_INTERACTION_OPERATOR: return createCGIMscInteractionOperator();
			case UMLRpyPackage.CGI_MSC_MESSAGE: return createCGIMscMessage();
			case UMLRpyPackage.CGI_OBJECT_INSTANCE: return createCGIObjectInstance();
			case UMLRpyPackage.CGI_OBJECT_LINK: return createCGIObjectLink();
			case UMLRpyPackage.CGI_PACKAGE: return createCGIPackage();
			case UMLRpyPackage.CGI_PARTITION: return createCGIPartition();
			case UMLRpyPackage.CGI_PORT_CONNECTOR: return createCGIPortConnector();
			case UMLRpyPackage.CGI_STATE: return createCGIState();
			case UMLRpyPackage.CGI_STATE_CHART: return createCGIStateChart();
			case UMLRpyPackage.CGI_SWIMLANE_FRAME: return createCGISwimlaneFrame();
			case UMLRpyPackage.CGI_TEXT: return createCGIText();
			case UMLRpyPackage.CGI_TEXT_BOX: return createCGITextBox();
			case UMLRpyPackage.CGI_TRANS: return createCGITrans();
			case UMLRpyPackage.COLL_EVENT: return createCollEvent();
			case UMLRpyPackage.IACCEPT_EVENT_ACTION: return createIAcceptEventAction();
			case UMLRpyPackage.IACCEPT_TIME_EVENT: return createIAcceptTimeEvent();
			case UMLRpyPackage.IACTION: return createIAction();
			case UMLRpyPackage.IACTIVITY_DIAGRAM: return createIActivityDiagram();
			case UMLRpyPackage.IACTIVITY_GRAPH: return createIActivityGraph();
			case UMLRpyPackage.IACTOR: return createIActor();
			case UMLRpyPackage.IANCHOR: return createIAnchor();
			case UMLRpyPackage.IANNOTATION: return createIAnnotation();
			case UMLRpyPackage.IARGUMENT: return createIArgument();
			case UMLRpyPackage.IASSOCIATION_CLASS: return createIAssociationClass();
			case UMLRpyPackage.IASSOCIATION_END: return createIAssociationEnd();
			case UMLRpyPackage.IASSOCIATION_END_HANDLE: return createIAssociationEndHandle();
			case UMLRpyPackage.IASSOCIATION_ROLE: return createIAssociationRole();
			case UMLRpyPackage.IATTRIBUTE: return createIAttribute();
			case UMLRpyPackage.IBLOCK: return createIBlock();
			case UMLRpyPackage.IBODY: return createIBody();
			case UMLRpyPackage.IBRANCH: return createIBranch();
			case UMLRpyPackage.ICALL_ACTION: return createICallAction();
			case UMLRpyPackage.ICALL_OPERATION: return createICallOperation();
			case UMLRpyPackage.ICLASS: return createIClass();
			case UMLRpyPackage.ICLASS_HANDLE: return createIClassHandle();
			case UMLRpyPackage.ICLASS_INSTANCE: return createIClassInstance();
			case UMLRpyPackage.ICLASSIFIER: return createIClassifier();
			case UMLRpyPackage.ICLASSIFIER_ROLE: return createIClassifierRole();
			case UMLRpyPackage.ICODE_GEN_CONFIG_INFO: return createICodeGenConfigInfo();
			case UMLRpyPackage.ICODE_GEN_CONFIG_INFO_HANDLE: return createICodeGenConfigInfoHandle();
			case UMLRpyPackage.ICOLLABORATION: return createICollaboration();
			case UMLRpyPackage.ICOLLABORATION_DIAGRAM: return createICollaborationDiagram();
			case UMLRpyPackage.ICOLOR: return createIColor();
			case UMLRpyPackage.ICOMBINED_FRAGMENT: return createICombinedFragment();
			case UMLRpyPackage.ICOMMENT: return createIComment();
			case UMLRpyPackage.ICOMPONENT: return createIComponent();
			case UMLRpyPackage.ICOMPONENT_DIAGRAM: return createIComponentDiagram();
			case UMLRpyPackage.ICOMPONENT_INSTANCE: return createIComponentInstance();
			case UMLRpyPackage.ICONFIGURATION: return createIConfiguration();
			case UMLRpyPackage.ICONNECTOR: return createIConnector();
			case UMLRpyPackage.ICONSTRAINT: return createIConstraint();
			case UMLRpyPackage.ICONSTRUCTOR: return createIConstructor();
			case UMLRpyPackage.ICONTEXT_SPECIFICATION: return createIContextSpecification();
			case UMLRpyPackage.ICONTROLLED_FILE: return createIControlledFile();
			case UMLRpyPackage.IDEFAULT_DRVD_TRANS: return createIDefaultDrvdTrans();
			case UMLRpyPackage.IDEPENDENCY: return createIDependency();
			case UMLRpyPackage.IDEPLOYMENT_DIAGRAM: return createIDeploymentDiagram();
			case UMLRpyPackage.IDESCRIPTION: return createIDescription();
			case UMLRpyPackage.IDESTRUCTOR: return createIDestructor();
			case UMLRpyPackage.IDIAGRAM: return createIDiagram();
			case UMLRpyPackage.IEMBEDED_FILE: return createIEmbededFile();
			case UMLRpyPackage.IENUMERATION_LITERAL: return createIEnumerationLiteral();
			case UMLRpyPackage.IEVENT: return createIEvent();
			case UMLRpyPackage.IEVENT_HANDLE: return createIEventHandle();
			case UMLRpyPackage.IEVENT_RECEPTION: return createIEventReception();
			case UMLRpyPackage.IEXECUTION_OCCURRENCE: return createIExecutionOccurrence();
			case UMLRpyPackage.IEXTERNAL_HYPERLINK: return createIExternalHyperlink();
			case UMLRpyPackage.IFILE: return createIFile();
			case UMLRpyPackage.IFILE_FRAGMENT: return createIFileFragment();
			case UMLRpyPackage.IFLOW: return createIFlow();
			case UMLRpyPackage.IFLOW_ITEM: return createIFlowItem();
			case UMLRpyPackage.IFLOWCHART: return createIFlowchart();
			case UMLRpyPackage.IFOLDER: return createIFolder();
			case UMLRpyPackage.IFORK: return createIFork();
			case UMLRpyPackage.IGENERALIZATION: return createIGeneralization();
			case UMLRpyPackage.IGUARD: return createIGuard();
			case UMLRpyPackage.IHANDLE_WITH_DATA: return createIHandleWithData();
			case UMLRpyPackage.IHISTORY_CONNECTOR: return createIHistoryConnector();
			case UMLRpyPackage.IHYPER_LINK: return createIHyperLink();
			case UMLRpyPackage.IINFORMATION_FLOW: return createIInformationFlow();
			case UMLRpyPackage.IINFORMATION_ITEM: return createIInformationItem();
			case UMLRpyPackage.IINSTANCE: return createIInstance();
			case UMLRpyPackage.IINSTANCE_SLOT: return createIInstanceSlot();
			case UMLRpyPackage.IINSTANCE_SPECIFICATION: return createIInstanceSpecification();
			case UMLRpyPackage.IINSTANCE_VALUE: return createIInstanceValue();
			case UMLRpyPackage.IINTERACTION_OCCURRENCE: return createIInteractionOccurrence();
			case UMLRpyPackage.IINTERACTION_OPERAND: return createIInteractionOperand();
			case UMLRpyPackage.IINTERACTION_OPERATOR: return createIInteractionOperator();
			case UMLRpyPackage.IINTERFACE_ITEM: return createIInterfaceItem();
			case UMLRpyPackage.IINTERFACE_ITEM_TRIGGER: return createIInterfaceItemTrigger();
			case UMLRpyPackage.IINTERNAL_HYPERLINK: return createIInternalHyperlink();
			case UMLRpyPackage.ILABEL: return createILabel();
			case UMLRpyPackage.ILINK: return createILink();
			case UMLRpyPackage.ILINK_INSTANCE: return createILinkInstance();
			case UMLRpyPackage.ILITERAL_SPECIFICATION: return createILiteralSpecification();
			case UMLRpyPackage.IM_HYPER_LINK: return createIMHyperLink();
			case UMLRpyPackage.IMSC: return createIMSC();
			case UMLRpyPackage.IMATRIX_INSTANCE: return createIMatrixInstance();
			case UMLRpyPackage.IMATRIX_LAYOUT: return createIMatrixLayout();
			case UMLRpyPackage.IMATRIX_VIEW: return createIMatrixView();
			case UMLRpyPackage.IMESSAGE: return createIMessage();
			case UMLRpyPackage.IMESSAGE_POINT: return createIMessagePoint();
			case UMLRpyPackage.IMETA_LINK_HANDLE: return createIMetaLinkHandle();
			case UMLRpyPackage.IMODEL_ELEMENT: return createIModelElement();
			case UMLRpyPackage.IMODULE: return createIModule();
			case UMLRpyPackage.IMULTIPLICITY_ITEM: return createIMultiplicityItem();
			case UMLRpyPackage.INODE: return createINode();
			case UMLRpyPackage.IOBJECT_LINK: return createIObjectLink();
			case UMLRpyPackage.IOBJECT_LINK_HANDLE: return createIObjectLinkHandle();
			case UMLRpyPackage.IOBJECT_MODEL_DIAGRAM: return createIObjectModelDiagram();
			case UMLRpyPackage.IOBJECT_NODE: return createIObjectNode();
			case UMLRpyPackage.IOPERATION: return createIOperation();
			case UMLRpyPackage.IPACKAGE: return createIPackage();
			case UMLRpyPackage.IPANEL_DIAGRAM: return createIPanelDiagram();
			case UMLRpyPackage.IPART: return createIPart();
			case UMLRpyPackage.IPIN: return createIPin();
			case UMLRpyPackage.IPORT: return createIPort();
			case UMLRpyPackage.IPRIMITIVE_OPERATION: return createIPrimitiveOperation();
			case UMLRpyPackage.IPROFILE: return createIProfile();
			case UMLRpyPackage.IPROJECT: return createIProject();
			case UMLRpyPackage.IPROPERTY: return createIProperty();
			case UMLRpyPackage.IPROPERTY_CONTAINER: return createIPropertyContainer();
			case UMLRpyPackage.IPROPERTY_METACLASS: return createIPropertyMetaclass();
			case UMLRpyPackage.IPROPERTY_SUBJECT: return createIPropertySubject();
			case UMLRpyPackage.IRECEPTION: return createIReception();
			case UMLRpyPackage.IREFERENCE_ACTIVITY: return createIReferenceActivity();
			case UMLRpyPackage.IRELATION: return createIRelation();
			case UMLRpyPackage.IREQUIREMENT: return createIRequirement();
			case UMLRpyPackage.ISEND_ACTION: return createISendAction();
			case UMLRpyPackage.ISEQUENCE_DIAGRAM: return createISequenceDiagram();
			case UMLRpyPackage.ISLOT: return createISlot();
			case UMLRpyPackage.ISTATE: return createIState();
			case UMLRpyPackage.ISTATE_CHART: return createIStateChart();
			case UMLRpyPackage.ISTATE_CHART_DIAGRAM: return createIStateChartDiagram();
			case UMLRpyPackage.ISTATE_VERTEX: return createIStateVertex();
			case UMLRpyPackage.ISTEREOTYPE: return createIStereotype();
			case UMLRpyPackage.ISTRUCTURE_DIAGRAM: return createIStructureDiagram();
			case UMLRpyPackage.ISUBSYSTEM: return createISubsystem();
			case UMLRpyPackage.ISWIMLANE: return createISwimlane();
			case UMLRpyPackage.ISYS_ML_PORT: return createISysMLPort();
			case UMLRpyPackage.ITABLE_INSTANCE: return createITableInstance();
			case UMLRpyPackage.ITABLE_LAYOUT: return createITableLayout();
			case UMLRpyPackage.ITABLE_VIEW: return createITableView();
			case UMLRpyPackage.ITAG: return createITag();
			case UMLRpyPackage.ITEMPLATE_INST: return createITemplateInst();
			case UMLRpyPackage.ITEMPLATE_INST_PARAM: return createITemplateInstParam();
			case UMLRpyPackage.ITEMPLATE_INSTANTIATION: return createITemplateInstantiation();
			case UMLRpyPackage.ITEMPLATE_INSTANTIATION_PARAMETER: return createITemplateInstantiationParameter();
			case UMLRpyPackage.ITEMPLATE_PARAMETER: return createITemplateParameter();
			case UMLRpyPackage.ITIME_EVENT: return createITimeEvent();
			case UMLRpyPackage.ITIMEOUT: return createITimeout();
			case UMLRpyPackage.ITRANSITION: return createITransition();
			case UMLRpyPackage.ITRIGGER: return createITrigger();
			case UMLRpyPackage.ITRIGGERED: return createITriggered();
			case UMLRpyPackage.ITYPE: return createIType();
			case UMLRpyPackage.IUC_DIAGRAM: return createIUCDiagram();
			case UMLRpyPackage.IUNIT: return createIUnit();
			case UMLRpyPackage.IUSE_CASE: return createIUseCase();
			case UMLRpyPackage.IUSE_CASE_DIAGRAM: return createIUseCaseDiagram();
			case UMLRpyPackage.IUSE_CASE_STEREO_TYPE: return createIUseCaseStereoType();
			case UMLRpyPackage.IVALUE_SPECIFICATION: return createIValueSpecification();
			case UMLRpyPackage.IVARIABLE: return createIVariable();
			case UMLRpyPackage.TABLE_DATA_DEFINITION: return createTableDataDefinition();
			case UMLRpyPackage.UNKNOWN_TYPE: return createUnknownType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CCollaborationChart createCCollaborationChart() {
		CCollaborationChartImpl cCollaborationChart = new CCollaborationChartImpl();
		return cCollaborationChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIActionState createCGIActionState() {
		CGIActionStateImpl cgiActionState = new CGIActionStateImpl();
		return cgiActionState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIActiveX createCGIActiveX() {
		CGIActiveXImpl cgiActiveX = new CGIActiveXImpl();
		return cgiActiveX;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIAnchor createCGIAnchor() {
		CGIAnchorImpl cgiAnchor = new CGIAnchorImpl();
		return cgiAnchor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIAnnotation createCGIAnnotation() {
		CGIAnnotationImpl cgiAnnotation = new CGIAnnotationImpl();
		return cgiAnnotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIArrow createCGIArrow() {
		CGIArrowImpl cgiArrow = new CGIArrowImpl();
		return cgiArrow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIAssociationEnd createCGIAssociationEnd() {
		CGIAssociationEndImpl cgiAssociationEnd = new CGIAssociationEndImpl();
		return cgiAssociationEnd;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIAssociationRole createCGIAssociationRole() {
		CGIAssociationRoleImpl cgiAssociationRole = new CGIAssociationRoleImpl();
		return cgiAssociationRole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIBasicClass createCGIBasicClass() {
		CGIBasicClassImpl cgiBasicClass = new CGIBasicClassImpl();
		return cgiBasicClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIBlockState createCGIBlockState() {
		CGIBlockStateImpl cgiBlockState = new CGIBlockStateImpl();
		return cgiBlockState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIBox createCGIBox() {
		CGIBoxImpl cgiBox = new CGIBoxImpl();
		return cgiBox;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIButtonArray createCGIButtonArray() {
		CGIButtonArrayImpl cgiButtonArray = new CGIButtonArrayImpl();
		return cgiButtonArray;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIClass createCGIClass() {
		CGIClassImpl cgiClass = new CGIClassImpl();
		return cgiClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIClassChart createCGIClassChart() {
		CGIClassChartImpl cgiClassChart = new CGIClassChartImpl();
		return cgiClassChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIClassifierRole createCGIClassifierRole() {
		CGIClassifierRoleImpl cgiClassifierRole = new CGIClassifierRoleImpl();
		return cgiClassifierRole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGICompartment createCGICompartment() {
		CGICompartmentImpl cgiCompartment = new CGICompartmentImpl();
		return cgiCompartment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIComponent createCGIComponent() {
		CGIComponentImpl cgiComponent = new CGIComponentImpl();
		return cgiComponent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGICompositeClass createCGICompositeClass() {
		CGICompositeClassImpl cgiCompositeClass = new CGICompositeClassImpl();
		return cgiCompositeClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIConnector createCGIConnector() {
		CGIConnectorImpl cgiConnector = new CGIConnectorImpl();
		return cgiConnector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIContainArrow createCGIContainArrow() {
		CGIContainArrowImpl cgiContainArrow = new CGIContainArrowImpl();
		return cgiContainArrow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIDiagramFrame createCGIDiagramFrame() {
		CGIDiagramFrameImpl cgiDiagramFrame = new CGIDiagramFrameImpl();
		return cgiDiagramFrame;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIFreeShape createCGIFreeShape() {
		CGIFreeShapeImpl cgiFreeShape = new CGIFreeShapeImpl();
		return cgiFreeShape;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIFreeText createCGIFreeText() {
		CGIFreeTextImpl cgiFreeText = new CGIFreeTextImpl();
		return cgiFreeText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIGenericElement createCGIGenericElement() {
		CGIGenericElementImpl cgiGenericElement = new CGIGenericElementImpl();
		return cgiGenericElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIImage createCGIImage() {
		CGIImageImpl cgiImage = new CGIImageImpl();
		return cgiImage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIImageData createCGIImageData() {
		CGIImageDataImpl cgiImageData = new CGIImageDataImpl();
		return cgiImageData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIInformationFlow createCGIInformationFlow() {
		CGIInformationFlowImpl cgiInformationFlow = new CGIInformationFlowImpl();
		return cgiInformationFlow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIInheritance createCGIInheritance() {
		CGIInheritanceImpl cgiInheritance = new CGIInheritanceImpl();
		return cgiInheritance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMFCCtrl createCGIMFCCtrl() {
		CGIMFCCtrlImpl cgimfcCtrl = new CGIMFCCtrlImpl();
		return cgimfcCtrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMessageLabel createCGIMessageLabel() {
		CGIMessageLabelImpl cgiMessageLabel = new CGIMessageLabelImpl();
		return cgiMessageLabel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscChart createCGIMscChart() {
		CGIMscChartImpl cgiMscChart = new CGIMscChartImpl();
		return cgiMscChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscColumnCR createCGIMscColumnCR() {
		CGIMscColumnCRImpl cgiMscColumnCR = new CGIMscColumnCRImpl();
		return cgiMscColumnCR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscConditionMark createCGIMscConditionMark() {
		CGIMscConditionMarkImpl cgiMscConditionMark = new CGIMscConditionMarkImpl();
		return cgiMscConditionMark;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscExecutionOccurrence createCGIMscExecutionOccurrence() {
		CGIMscExecutionOccurrenceImpl cgiMscExecutionOccurrence = new CGIMscExecutionOccurrenceImpl();
		return cgiMscExecutionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscInteractionOccurrence createCGIMscInteractionOccurrence() {
		CGIMscInteractionOccurrenceImpl cgiMscInteractionOccurrence = new CGIMscInteractionOccurrenceImpl();
		return cgiMscInteractionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscInteractionOperand createCGIMscInteractionOperand() {
		CGIMscInteractionOperandImpl cgiMscInteractionOperand = new CGIMscInteractionOperandImpl();
		return cgiMscInteractionOperand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscInteractionOperator createCGIMscInteractionOperator() {
		CGIMscInteractionOperatorImpl cgiMscInteractionOperator = new CGIMscInteractionOperatorImpl();
		return cgiMscInteractionOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIMscMessage createCGIMscMessage() {
		CGIMscMessageImpl cgiMscMessage = new CGIMscMessageImpl();
		return cgiMscMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIObjectInstance createCGIObjectInstance() {
		CGIObjectInstanceImpl cgiObjectInstance = new CGIObjectInstanceImpl();
		return cgiObjectInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIObjectLink createCGIObjectLink() {
		CGIObjectLinkImpl cgiObjectLink = new CGIObjectLinkImpl();
		return cgiObjectLink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIPackage createCGIPackage() {
		CGIPackageImpl cgiPackage = new CGIPackageImpl();
		return cgiPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIPartition createCGIPartition() {
		CGIPartitionImpl cgiPartition = new CGIPartitionImpl();
		return cgiPartition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIPortConnector createCGIPortConnector() {
		CGIPortConnectorImpl cgiPortConnector = new CGIPortConnectorImpl();
		return cgiPortConnector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIState createCGIState() {
		CGIStateImpl cgiState = new CGIStateImpl();
		return cgiState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIStateChart createCGIStateChart() {
		CGIStateChartImpl cgiStateChart = new CGIStateChartImpl();
		return cgiStateChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGISwimlaneFrame createCGISwimlaneFrame() {
		CGISwimlaneFrameImpl cgiSwimlaneFrame = new CGISwimlaneFrameImpl();
		return cgiSwimlaneFrame;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGIText createCGIText() {
		CGITextImpl cgiText = new CGITextImpl();
		return cgiText;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGITextBox createCGITextBox() {
		CGITextBoxImpl cgiTextBox = new CGITextBoxImpl();
		return cgiTextBox;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CGITrans createCGITrans() {
		CGITransImpl cgiTrans = new CGITransImpl();
		return cgiTrans;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CollEvent createCollEvent() {
		CollEventImpl collEvent = new CollEventImpl();
		return collEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAcceptEventAction createIAcceptEventAction() {
		IAcceptEventActionImpl iAcceptEventAction = new IAcceptEventActionImpl();
		return iAcceptEventAction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAcceptTimeEvent createIAcceptTimeEvent() {
		IAcceptTimeEventImpl iAcceptTimeEvent = new IAcceptTimeEventImpl();
		return iAcceptTimeEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAction createIAction() {
		IActionImpl iAction = new IActionImpl();
		return iAction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IActivityDiagram createIActivityDiagram() {
		IActivityDiagramImpl iActivityDiagram = new IActivityDiagramImpl();
		return iActivityDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IActivityGraph createIActivityGraph() {
		IActivityGraphImpl iActivityGraph = new IActivityGraphImpl();
		return iActivityGraph;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IActor createIActor() {
		IActorImpl iActor = new IActorImpl();
		return iActor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAnchor createIAnchor() {
		IAnchorImpl iAnchor = new IAnchorImpl();
		return iAnchor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAnnotation createIAnnotation() {
		IAnnotationImpl iAnnotation = new IAnnotationImpl();
		return iAnnotation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IArgument createIArgument() {
		IArgumentImpl iArgument = new IArgumentImpl();
		return iArgument;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAssociationClass createIAssociationClass() {
		IAssociationClassImpl iAssociationClass = new IAssociationClassImpl();
		return iAssociationClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAssociationEnd createIAssociationEnd() {
		IAssociationEndImpl iAssociationEnd = new IAssociationEndImpl();
		return iAssociationEnd;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAssociationEndHandle createIAssociationEndHandle() {
		IAssociationEndHandleImpl iAssociationEndHandle = new IAssociationEndHandleImpl();
		return iAssociationEndHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAssociationRole createIAssociationRole() {
		IAssociationRoleImpl iAssociationRole = new IAssociationRoleImpl();
		return iAssociationRole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IAttribute createIAttribute() {
		IAttributeImpl iAttribute = new IAttributeImpl();
		return iAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IBlock createIBlock() {
		IBlockImpl iBlock = new IBlockImpl();
		return iBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IBody createIBody() {
		IBodyImpl iBody = new IBodyImpl();
		return iBody;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IBranch createIBranch() {
		IBranchImpl iBranch = new IBranchImpl();
		return iBranch;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICallAction createICallAction() {
		ICallActionImpl iCallAction = new ICallActionImpl();
		return iCallAction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICallOperation createICallOperation() {
		ICallOperationImpl iCallOperation = new ICallOperationImpl();
		return iCallOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClass createIClass() {
		IClassImpl iClass = new IClassImpl();
		return iClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClassHandle createIClassHandle() {
		IClassHandleImpl iClassHandle = new IClassHandleImpl();
		return iClassHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClassInstance createIClassInstance() {
		IClassInstanceImpl iClassInstance = new IClassInstanceImpl();
		return iClassInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClassifier createIClassifier() {
		IClassifierImpl iClassifier = new IClassifierImpl();
		return iClassifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IClassifierRole createIClassifierRole() {
		IClassifierRoleImpl iClassifierRole = new IClassifierRoleImpl();
		return iClassifierRole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICodeGenConfigInfo createICodeGenConfigInfo() {
		ICodeGenConfigInfoImpl iCodeGenConfigInfo = new ICodeGenConfigInfoImpl();
		return iCodeGenConfigInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICodeGenConfigInfoHandle createICodeGenConfigInfoHandle() {
		ICodeGenConfigInfoHandleImpl iCodeGenConfigInfoHandle = new ICodeGenConfigInfoHandleImpl();
		return iCodeGenConfigInfoHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICollaboration createICollaboration() {
		ICollaborationImpl iCollaboration = new ICollaborationImpl();
		return iCollaboration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICollaborationDiagram createICollaborationDiagram() {
		ICollaborationDiagramImpl iCollaborationDiagram = new ICollaborationDiagramImpl();
		return iCollaborationDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IColor createIColor() {
		IColorImpl iColor = new IColorImpl();
		return iColor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ICombinedFragment createICombinedFragment() {
		ICombinedFragmentImpl iCombinedFragment = new ICombinedFragmentImpl();
		return iCombinedFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IComment createIComment() {
		ICommentImpl iComment = new ICommentImpl();
		return iComment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IComponent createIComponent() {
		IComponentImpl iComponent = new IComponentImpl();
		return iComponent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IComponentDiagram createIComponentDiagram() {
		IComponentDiagramImpl iComponentDiagram = new IComponentDiagramImpl();
		return iComponentDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IComponentInstance createIComponentInstance() {
		IComponentInstanceImpl iComponentInstance = new IComponentInstanceImpl();
		return iComponentInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConfiguration createIConfiguration() {
		IConfigurationImpl iConfiguration = new IConfigurationImpl();
		return iConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConnector createIConnector() {
		IConnectorImpl iConnector = new IConnectorImpl();
		return iConnector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConstraint createIConstraint() {
		IConstraintImpl iConstraint = new IConstraintImpl();
		return iConstraint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IConstructor createIConstructor() {
		IConstructorImpl iConstructor = new IConstructorImpl();
		return iConstructor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IContextSpecification createIContextSpecification() {
		IContextSpecificationImpl iContextSpecification = new IContextSpecificationImpl();
		return iContextSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IControlledFile createIControlledFile() {
		IControlledFileImpl iControlledFile = new IControlledFileImpl();
		return iControlledFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDefaultDrvdTrans createIDefaultDrvdTrans() {
		IDefaultDrvdTransImpl iDefaultDrvdTrans = new IDefaultDrvdTransImpl();
		return iDefaultDrvdTrans;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDependency createIDependency() {
		IDependencyImpl iDependency = new IDependencyImpl();
		return iDependency;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDeploymentDiagram createIDeploymentDiagram() {
		IDeploymentDiagramImpl iDeploymentDiagram = new IDeploymentDiagramImpl();
		return iDeploymentDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDescription createIDescription() {
		IDescriptionImpl iDescription = new IDescriptionImpl();
		return iDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDestructor createIDestructor() {
		IDestructorImpl iDestructor = new IDestructorImpl();
		return iDestructor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IDiagram createIDiagram() {
		IDiagramImpl iDiagram = new IDiagramImpl();
		return iDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEmbededFile createIEmbededFile() {
		IEmbededFileImpl iEmbededFile = new IEmbededFileImpl();
		return iEmbededFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEnumerationLiteral createIEnumerationLiteral() {
		IEnumerationLiteralImpl iEnumerationLiteral = new IEnumerationLiteralImpl();
		return iEnumerationLiteral;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEvent createIEvent() {
		IEventImpl iEvent = new IEventImpl();
		return iEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEventHandle createIEventHandle() {
		IEventHandleImpl iEventHandle = new IEventHandleImpl();
		return iEventHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IEventReception createIEventReception() {
		IEventReceptionImpl iEventReception = new IEventReceptionImpl();
		return iEventReception;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IExecutionOccurrence createIExecutionOccurrence() {
		IExecutionOccurrenceImpl iExecutionOccurrence = new IExecutionOccurrenceImpl();
		return iExecutionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IExternalHyperlink createIExternalHyperlink() {
		IExternalHyperlinkImpl iExternalHyperlink = new IExternalHyperlinkImpl();
		return iExternalHyperlink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFile createIFile() {
		IFileImpl iFile = new IFileImpl();
		return iFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFileFragment createIFileFragment() {
		IFileFragmentImpl iFileFragment = new IFileFragmentImpl();
		return iFileFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFlow createIFlow() {
		IFlowImpl iFlow = new IFlowImpl();
		return iFlow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFlowItem createIFlowItem() {
		IFlowItemImpl iFlowItem = new IFlowItemImpl();
		return iFlowItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFlowchart createIFlowchart() {
		IFlowchartImpl iFlowchart = new IFlowchartImpl();
		return iFlowchart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFolder createIFolder() {
		IFolderImpl iFolder = new IFolderImpl();
		return iFolder;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IFork createIFork() {
		IForkImpl iFork = new IForkImpl();
		return iFork;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IGeneralization createIGeneralization() {
		IGeneralizationImpl iGeneralization = new IGeneralizationImpl();
		return iGeneralization;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IGuard createIGuard() {
		IGuardImpl iGuard = new IGuardImpl();
		return iGuard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IHandleWithData createIHandleWithData() {
		IHandleWithDataImpl iHandleWithData = new IHandleWithDataImpl();
		return iHandleWithData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IHistoryConnector createIHistoryConnector() {
		IHistoryConnectorImpl iHistoryConnector = new IHistoryConnectorImpl();
		return iHistoryConnector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IHyperLink createIHyperLink() {
		IHyperLinkImpl iHyperLink = new IHyperLinkImpl();
		return iHyperLink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInformationFlow createIInformationFlow() {
		IInformationFlowImpl iInformationFlow = new IInformationFlowImpl();
		return iInformationFlow;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInformationItem createIInformationItem() {
		IInformationItemImpl iInformationItem = new IInformationItemImpl();
		return iInformationItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInstance createIInstance() {
		IInstanceImpl iInstance = new IInstanceImpl();
		return iInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInstanceSlot createIInstanceSlot() {
		IInstanceSlotImpl iInstanceSlot = new IInstanceSlotImpl();
		return iInstanceSlot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInstanceSpecification createIInstanceSpecification() {
		IInstanceSpecificationImpl iInstanceSpecification = new IInstanceSpecificationImpl();
		return iInstanceSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInstanceValue createIInstanceValue() {
		IInstanceValueImpl iInstanceValue = new IInstanceValueImpl();
		return iInstanceValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInteractionOccurrence createIInteractionOccurrence() {
		IInteractionOccurrenceImpl iInteractionOccurrence = new IInteractionOccurrenceImpl();
		return iInteractionOccurrence;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInteractionOperand createIInteractionOperand() {
		IInteractionOperandImpl iInteractionOperand = new IInteractionOperandImpl();
		return iInteractionOperand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInteractionOperator createIInteractionOperator() {
		IInteractionOperatorImpl iInteractionOperator = new IInteractionOperatorImpl();
		return iInteractionOperator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInterfaceItem createIInterfaceItem() {
		IInterfaceItemImpl iInterfaceItem = new IInterfaceItemImpl();
		return iInterfaceItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInterfaceItemTrigger createIInterfaceItemTrigger() {
		IInterfaceItemTriggerImpl iInterfaceItemTrigger = new IInterfaceItemTriggerImpl();
		return iInterfaceItemTrigger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IInternalHyperlink createIInternalHyperlink() {
		IInternalHyperlinkImpl iInternalHyperlink = new IInternalHyperlinkImpl();
		return iInternalHyperlink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILabel createILabel() {
		ILabelImpl iLabel = new ILabelImpl();
		return iLabel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILink createILink() {
		ILinkImpl iLink = new ILinkImpl();
		return iLink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILinkInstance createILinkInstance() {
		ILinkInstanceImpl iLinkInstance = new ILinkInstanceImpl();
		return iLinkInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ILiteralSpecification createILiteralSpecification() {
		ILiteralSpecificationImpl iLiteralSpecification = new ILiteralSpecificationImpl();
		return iLiteralSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMHyperLink createIMHyperLink() {
		IMHyperLinkImpl imHyperLink = new IMHyperLinkImpl();
		return imHyperLink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMSC createIMSC() {
		IMSCImpl imsc = new IMSCImpl();
		return imsc;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMatrixInstance createIMatrixInstance() {
		IMatrixInstanceImpl iMatrixInstance = new IMatrixInstanceImpl();
		return iMatrixInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMatrixLayout createIMatrixLayout() {
		IMatrixLayoutImpl iMatrixLayout = new IMatrixLayoutImpl();
		return iMatrixLayout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMatrixView createIMatrixView() {
		IMatrixViewImpl iMatrixView = new IMatrixViewImpl();
		return iMatrixView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMessage createIMessage() {
		IMessageImpl iMessage = new IMessageImpl();
		return iMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMessagePoint createIMessagePoint() {
		IMessagePointImpl iMessagePoint = new IMessagePointImpl();
		return iMessagePoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMetaLinkHandle createIMetaLinkHandle() {
		IMetaLinkHandleImpl iMetaLinkHandle = new IMetaLinkHandleImpl();
		return iMetaLinkHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IModelElement createIModelElement() {
		IModelElementImpl iModelElement = new IModelElementImpl();
		return iModelElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IModule createIModule() {
		IModuleImpl iModule = new IModuleImpl();
		return iModule;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IMultiplicityItem createIMultiplicityItem() {
		IMultiplicityItemImpl iMultiplicityItem = new IMultiplicityItemImpl();
		return iMultiplicityItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public INode createINode() {
		INodeImpl iNode = new INodeImpl();
		return iNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IObjectLink createIObjectLink() {
		IObjectLinkImpl iObjectLink = new IObjectLinkImpl();
		return iObjectLink;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IObjectLinkHandle createIObjectLinkHandle() {
		IObjectLinkHandleImpl iObjectLinkHandle = new IObjectLinkHandleImpl();
		return iObjectLinkHandle;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IObjectModelDiagram createIObjectModelDiagram() {
		IObjectModelDiagramImpl iObjectModelDiagram = new IObjectModelDiagramImpl();
		return iObjectModelDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IObjectNode createIObjectNode() {
		IObjectNodeImpl iObjectNode = new IObjectNodeImpl();
		return iObjectNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IOperation createIOperation() {
		IOperationImpl iOperation = new IOperationImpl();
		return iOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPackage createIPackage() {
		IPackageImpl iPackage = new IPackageImpl();
		return iPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPanelDiagram createIPanelDiagram() {
		IPanelDiagramImpl iPanelDiagram = new IPanelDiagramImpl();
		return iPanelDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPart createIPart() {
		IPartImpl iPart = new IPartImpl();
		return iPart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPin createIPin() {
		IPinImpl iPin = new IPinImpl();
		return iPin;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPort createIPort() {
		IPortImpl iPort = new IPortImpl();
		return iPort;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPrimitiveOperation createIPrimitiveOperation() {
		IPrimitiveOperationImpl iPrimitiveOperation = new IPrimitiveOperationImpl();
		return iPrimitiveOperation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProfile createIProfile() {
		IProfileImpl iProfile = new IProfileImpl();
		return iProfile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProject createIProject() {
		IProjectImpl iProject = new IProjectImpl();
		return iProject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IProperty createIProperty() {
		IPropertyImpl iProperty = new IPropertyImpl();
		return iProperty;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPropertyContainer createIPropertyContainer() {
		IPropertyContainerImpl iPropertyContainer = new IPropertyContainerImpl();
		return iPropertyContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPropertyMetaclass createIPropertyMetaclass() {
		IPropertyMetaclassImpl iPropertyMetaclass = new IPropertyMetaclassImpl();
		return iPropertyMetaclass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IPropertySubject createIPropertySubject() {
		IPropertySubjectImpl iPropertySubject = new IPropertySubjectImpl();
		return iPropertySubject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IReception createIReception() {
		IReceptionImpl iReception = new IReceptionImpl();
		return iReception;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IReferenceActivity createIReferenceActivity() {
		IReferenceActivityImpl iReferenceActivity = new IReferenceActivityImpl();
		return iReferenceActivity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IRelation createIRelation() {
		IRelationImpl iRelation = new IRelationImpl();
		return iRelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IRequirement createIRequirement() {
		IRequirementImpl iRequirement = new IRequirementImpl();
		return iRequirement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISendAction createISendAction() {
		ISendActionImpl iSendAction = new ISendActionImpl();
		return iSendAction;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISequenceDiagram createISequenceDiagram() {
		ISequenceDiagramImpl iSequenceDiagram = new ISequenceDiagramImpl();
		return iSequenceDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISlot createISlot() {
		ISlotImpl iSlot = new ISlotImpl();
		return iSlot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IState createIState() {
		IStateImpl iState = new IStateImpl();
		return iState;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStateChart createIStateChart() {
		IStateChartImpl iStateChart = new IStateChartImpl();
		return iStateChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStateChartDiagram createIStateChartDiagram() {
		IStateChartDiagramImpl iStateChartDiagram = new IStateChartDiagramImpl();
		return iStateChartDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStateVertex createIStateVertex() {
		IStateVertexImpl iStateVertex = new IStateVertexImpl();
		return iStateVertex;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStereotype createIStereotype() {
		IStereotypeImpl iStereotype = new IStereotypeImpl();
		return iStereotype;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IStructureDiagram createIStructureDiagram() {
		IStructureDiagramImpl iStructureDiagram = new IStructureDiagramImpl();
		return iStructureDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISubsystem createISubsystem() {
		ISubsystemImpl iSubsystem = new ISubsystemImpl();
		return iSubsystem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISwimlane createISwimlane() {
		ISwimlaneImpl iSwimlane = new ISwimlaneImpl();
		return iSwimlane;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ISysMLPort createISysMLPort() {
		ISysMLPortImpl iSysMLPort = new ISysMLPortImpl();
		return iSysMLPort;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITableInstance createITableInstance() {
		ITableInstanceImpl iTableInstance = new ITableInstanceImpl();
		return iTableInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITableLayout createITableLayout() {
		ITableLayoutImpl iTableLayout = new ITableLayoutImpl();
		return iTableLayout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITableView createITableView() {
		ITableViewImpl iTableView = new ITableViewImpl();
		return iTableView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITag createITag() {
		ITagImpl iTag = new ITagImpl();
		return iTag;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITemplateInst createITemplateInst() {
		ITemplateInstImpl iTemplateInst = new ITemplateInstImpl();
		return iTemplateInst;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITemplateInstParam createITemplateInstParam() {
		ITemplateInstParamImpl iTemplateInstParam = new ITemplateInstParamImpl();
		return iTemplateInstParam;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITemplateInstantiation createITemplateInstantiation() {
		ITemplateInstantiationImpl iTemplateInstantiation = new ITemplateInstantiationImpl();
		return iTemplateInstantiation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITemplateInstantiationParameter createITemplateInstantiationParameter() {
		ITemplateInstantiationParameterImpl iTemplateInstantiationParameter = new ITemplateInstantiationParameterImpl();
		return iTemplateInstantiationParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITemplateParameter createITemplateParameter() {
		ITemplateParameterImpl iTemplateParameter = new ITemplateParameterImpl();
		return iTemplateParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITimeEvent createITimeEvent() {
		ITimeEventImpl iTimeEvent = new ITimeEventImpl();
		return iTimeEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITimeout createITimeout() {
		ITimeoutImpl iTimeout = new ITimeoutImpl();
		return iTimeout;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITransition createITransition() {
		ITransitionImpl iTransition = new ITransitionImpl();
		return iTransition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITrigger createITrigger() {
		ITriggerImpl iTrigger = new ITriggerImpl();
		return iTrigger;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ITriggered createITriggered() {
		ITriggeredImpl iTriggered = new ITriggeredImpl();
		return iTriggered;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IType createIType() {
		ITypeImpl iType = new ITypeImpl();
		return iType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IUCDiagram createIUCDiagram() {
		IUCDiagramImpl iucDiagram = new IUCDiagramImpl();
		return iucDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IUnit createIUnit() {
		IUnitImpl iUnit = new IUnitImpl();
		return iUnit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IUseCase createIUseCase() {
		IUseCaseImpl iUseCase = new IUseCaseImpl();
		return iUseCase;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IUseCaseDiagram createIUseCaseDiagram() {
		IUseCaseDiagramImpl iUseCaseDiagram = new IUseCaseDiagramImpl();
		return iUseCaseDiagram;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IUseCaseStereoType createIUseCaseStereoType() {
		IUseCaseStereoTypeImpl iUseCaseStereoType = new IUseCaseStereoTypeImpl();
		return iUseCaseStereoType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IValueSpecification createIValueSpecification() {
		IValueSpecificationImpl iValueSpecification = new IValueSpecificationImpl();
		return iValueSpecification;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public IVariable createIVariable() {
		IVariableImpl iVariable = new IVariableImpl();
		return iVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableDataDefinition createTableDataDefinition() {
		TableDataDefinitionImpl tableDataDefinition = new TableDataDefinitionImpl();
		return tableDataDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnknownType createUnknownType() {
		UnknownTypeImpl unknownType = new UnknownTypeImpl();
		return unknownType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UMLRpyPackage getUMLRpyPackage() {
		return (UMLRpyPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static UMLRpyPackage getPackage() {
		return UMLRpyPackage.eINSTANCE;
	}

} //UMLRpyFactoryImpl
