/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.PortDropHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.TypeDropHelper;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Port;

public class CustomBlockPropertyCompositeDropEditPolicy
extends CustomDragDropEditPolicy {
    @Override
    protected Set<String> getSpecificDropBehaviorTypes() {
        Set<String> specificDropBehaviorTypes = super.getSpecificDropBehaviorTypes();
        specificDropBehaviorTypes.add("shape_uml_port_as_affixed");
        specificDropBehaviorTypes.add("shape_sysml_flowport_as_affixed");
        return specificDropBehaviorTypes;
    }

    @Override
    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if ("shape_uml_port_as_affixed".equals(nodeType) || "shape_sysml_flowport_as_affixed".equals(nodeType)) {
            PortDropHelper portDropHelper = new PortDropHelper(this.getEditingDomain());
            return portDropHelper.getDropPortOnPart((Port)droppedEObject, dropRequest.getLocation().getCopy(), (GraphicalEditPart)this.getHost());
        }
        return super.getSpecificDropCommand(dropRequest, droppedEObject, nodeType, edgeType);
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        TypeDropHelper helper = new TypeDropHelper(this.getEditingDomain());
        if (dropRequest.getObjects().size() == 1) {
            Command defaultDropCommand;
            Command dropAsTypedFlowPort_InOut;
            Command dropAsTypedFlowPort_Out;
            Command dropAsTypedFlowPort_In;
            Command dropAsTypedPort;
            final ArrayList<Command> commandChoice = new ArrayList<Command>();
            Command dropAsSetType = helper.getDropAsTypedElementType(dropRequest, (GraphicalEditPart)this.getHost());
            if (dropAsSetType != null && dropAsSetType.canExecute()) {
                commandChoice.add(dropAsSetType);
            }
            if ((dropAsTypedPort = helper.getDropAsTypedPortOnPart(dropRequest, (GraphicalEditPart)this.getHost())) != null && dropAsTypedPort.canExecute()) {
                commandChoice.add(dropAsTypedPort);
            }
            if ((dropAsTypedFlowPort_In = helper.getDropAsTypedFlowPortOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.FLOW_PORT)) != null && dropAsTypedFlowPort_In.canExecute()) {
                commandChoice.add(dropAsTypedFlowPort_In);
            }
            if ((dropAsTypedFlowPort_Out = helper.getDropAsTypedFlowPortOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.FLOW_PORT_IN)) != null && dropAsTypedFlowPort_Out.canExecute()) {
                commandChoice.add(dropAsTypedFlowPort_Out);
            }
            if ((dropAsTypedFlowPort_InOut = helper.getDropAsTypedFlowPortOnPart(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.FLOW_PORT_OUT)) != null && dropAsTypedFlowPort_InOut.canExecute()) {
                commandChoice.add(dropAsTypedFlowPort_InOut);
            }
            if ((defaultDropCommand = super.getDropObjectsCommand(dropRequest)) != null && defaultDropCommand.canExecute()) {
                defaultDropCommand.setLabel("Default drop (Show dropped object in diagram)");
                commandChoice.add(defaultDropCommand);
            }
            if (commandChoice.size() > 1) {
                RunnableWithResult.Impl<ICommand> runnable = new RunnableWithResult.Impl<ICommand>(){

                    public void run() {
                        this.setResult(new SelectAndExecuteCommand("Select drop action for ", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), commandChoice));
                    }
                };
                Display.getDefault().syncExec((Runnable)runnable);
                ICommand selectCommand = (ICommand)runnable.getResult();
                return new ICommandProxy(selectCommand);
            }
            if (commandChoice.size() == 1) {
                return (Command)commandChoice.get(0);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDropObjectsCommand(dropRequest);
    }
}

