/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.service.types.matcher.BlockMatcher;

public class CustomDiagramDropEditPolicy
extends CustomDragDropEditPolicy {
    @Override
    protected Set<String> getSpecificDropBehaviorTypes() {
        Set<String> specificDropBehaviorTypes = super.getSpecificDropBehaviorTypes();
        specificDropBehaviorTypes.add("shape_sysml_block_as_composite");
        return specificDropBehaviorTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if (!"shape_sysml_block_as_composite".equals(nodeType)) return super.getSpecificDropCommand(dropRequest, droppedEObject, nodeType, edgeType);
        BlockMatcher matcher = new BlockMatcher();
        if (!matcher.matches(droppedEObject)) {
            return UnexecutableCommand.INSTANCE;
        }
        Object model = this.getHost().getModel();
        if (!(model instanceof Diagram)) return UnexecutableCommand.INSTANCE;
        EObject element = ((Diagram)model).getElement();
        if (!droppedEObject.equals(element)) return UnexecutableCommand.INSTANCE;
        for (View view : ((Diagram)model).getChildren()) {
            if (!"shape_sysml_block_as_composite".equals(view.getType())) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return this.getDefaultDropNodeCommand(nodeType, dropRequest.getLocation(), droppedEObject);
    }
}

