/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.structure.DiagramStructure;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.DiagramUpdater;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.UpdaterLinkDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.Domain2Notation;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.internalblock.part.SysMLDiagramUpdater;
import org.eclipse.papyrus.sysml.diagram.internalblock.part.SysMLVisualIDRegistry;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractUMLShowHideRelatedLinkEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ShowHideRelatedLinkEditPolicy
extends AbstractUMLShowHideRelatedLinkEditPolicy {
    public ShowHideRelatedLinkEditPolicy(DiagramEditPart host) {
        super(host);
    }

    public DiagramUpdater getDiagramUpdater() {
        return SysMLDiagramUpdater.TYPED_INSTANCE;
    }

    public DiagramStructure getDiagramStructure() {
        return SysMLVisualIDRegistry.TYPED_INSTANCE;
    }

    protected String getSemanticHint(EObject eobject) {
        return SysMLVisualIDRegistry.getLinkWithClassVisualID(eobject);
    }

    protected void cleanAdd(Collection<UpdaterLinkDescriptor> result, View view, List<? extends UpdaterLinkDescriptor> descriptors, Domain2Notation domain2NotationMap) {
        this.cleanAddForConnector(result, view, descriptors, domain2NotationMap);
        super.cleanAdd(result, view, descriptors, domain2NotationMap);
    }

    protected void cleanAddForConnector(Collection<UpdaterLinkDescriptor> result, View view, List<?> descriptors, Domain2Notation domain2NotationMap) {
        ArrayList<UpdaterLinkDescriptor> toRemove = new ArrayList<UpdaterLinkDescriptor>();
        for (Object current : descriptors) {
            UpdaterLinkDescriptor descriptor;
            EObject element;
            if (!(current instanceof UpdaterLinkDescriptor) || !((element = (descriptor = (UpdaterLinkDescriptor)current).getModelElement()) instanceof org.eclipse.uml2.uml.Connector)) continue;
            if (this.canBeDisplayed((org.eclipse.uml2.uml.Connector)element, view, domain2NotationMap)) {
                result.add((UpdaterLinkDescriptor)current);
            }
            toRemove.add((UpdaterLinkDescriptor)current);
        }
        descriptors.removeAll(toRemove);
    }

    protected boolean isCorrectGraphicalView(ConnectorEnd connectorEnd, View view) {
        View parent;
        NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)connectorEnd, NestedConnectorEnd.class);
        Property partWithPort = connectorEnd.getPartWithPort();
        View localView = this.getTopViewWithSameSemanticElement(view);
        if (partWithPort != null && (parent = this.getTopViewWithSameSemanticElement(ViewUtil.getViewContainer((EObject)localView))).getElement() != partWithPort) {
            return false;
        }
        if (nestedConnectorEnd != null && nestedConnectorEnd.getPropertyPath().size() > 0) {
            parent = view;
            EList paths = nestedConnectorEnd.getPropertyPath();
            int i = paths.size() - 1;
            while (i >= 0) {
                Property currentProperty = (Property)paths.get(i);
                if ((parent = this.getTopViewWithSameSemanticElement(ViewUtil.getViewContainer((EObject)parent))).getElement() != currentProperty) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    protected boolean canBeDisplayed(org.eclipse.uml2.uml.Connector connector, View selectedView, Domain2Notation domain2NotationMap) {
        EObject semanticElement = selectedView.getElement();
        ConnectorEnd endForView = null;
        for (ConnectorEnd current : connector.getEnds()) {
            if (current.getRole() != semanticElement) continue;
            endForView = current;
            break;
        }
        Assert.isNotNull(endForView);
        if (!this.isCorrectGraphicalView(endForView, selectedView)) {
            return false;
        }
        View secondView = null;
        for (ConnectorEnd end : connector.getEnds()) {
            ConnectableElement role = end.getRole();
            if (role == null) {
                return false;
            }
            if (end == endForView) continue;
            Set views = CrossReferencerUtil.getCrossReferencingViewsInDiagram((EObject)role, (Diagram)this.getCurrentDiagram());
            Iterator iterOnView = views.iterator();
            while (secondView == null && iterOnView.hasNext()) {
                View currentView = (View)iterOnView.next();
                if (!this.isCorrectGraphicalView(end, currentView)) continue;
                domain2NotationMap.putView((EObject)endForView, selectedView);
                domain2NotationMap.putView((EObject)end, currentView);
                secondView = currentView;
            }
        }
        return secondView != null;
    }

    protected ICommand getShowLinkCommand(TransactionalEditingDomain domain, EObject linkToShow, Domain2Notation domain2NotationMap, Collection<? extends UpdaterLinkDescriptor> linkDescriptors) {
        if (!(linkToShow instanceof org.eclipse.uml2.uml.Connector)) {
            return super.getShowLinkCommand(domain, linkToShow, domain2NotationMap, linkDescriptors);
        }
        domain2NotationMap.mapModel((View)this.getHost().getAdapter(View.class));
        UpdaterLinkDescriptor updaterLinkDescriptor = this.getLinkDescriptor(linkToShow, linkDescriptors);
        ICommand showLinkCommandFromUpdaterLinkDescriptor = this.getShowLinkCommandFromUpdaterLinkDescriptor(linkToShow, domain2NotationMap, updaterLinkDescriptor);
        return showLinkCommandFromUpdaterLinkDescriptor;
    }

    private ICommand getShowLinkCommandFromUpdaterLinkDescriptor(EObject linkToShow, Domain2Notation domain2NotationMap, UpdaterLinkDescriptor descriptor) {
        new ConnectorUtils();
        if (descriptor != null) {
            Set sourceViewList = (Set)domain2NotationMap.get((Object)descriptor.getSource());
            Set targetViewList = (Set)domain2NotationMap.get((Object)descriptor.getDestination());
            Set linkSet = (Set)domain2NotationMap.get((Object)linkToShow);
            CompositeCommand compositeCommand = new CompositeCommand("Restore All Related Links");
            for (View sourceView : sourceViewList) {
                for (View targetView : targetViewList) {
                    if (!this.canDisplayExistingLinkBetweenViews(linkToShow, sourceView, targetView) || !ConnectorUtils.canDisplayExistingConnectorBetweenViewsAccordingToNestedPaths((org.eclipse.uml2.uml.Connector)((org.eclipse.uml2.uml.Connector)linkToShow), (View)sourceView, (View)targetView)) continue;
                    boolean alreadyDisplayed = false;
                    if (linkSet != null) {
                        for (View viewLink : linkSet) {
                            boolean linkForViews = this.isLinkForViews((Connector)viewLink, sourceView, targetView);
                            boolean bl = alreadyDisplayed = alreadyDisplayed || linkForViews;
                        }
                    }
                    if (alreadyDisplayed) continue;
                    EditPart sourceEditPart = this.getEditPartFromView(sourceView);
                    EditPart targetEditPart = this.getEditPartFromView(targetView);
                    if (sourceEditPart == null || targetEditPart == null) {
                        return null;
                    }
                    String semanticHint = this.getSemanticHint(linkToShow);
                    CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(descriptor.getSemanticAdapter(), semanticHint, -1, false, ((GraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
                    CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(viewDescriptor);
                    ccr.setType((Object)"connection start");
                    ccr.setSourceEditPart(sourceEditPart);
                    sourceEditPart.getCommand((Request)ccr);
                    ccr.setTargetEditPart(targetEditPart);
                    ccr.setType((Object)"connection end");
                    CommandProxy commandProxy = new CommandProxy(targetEditPart.getCommand((Request)ccr));
                    compositeCommand.add((IUndoableOperation)commandProxy);
                }
            }
            return compositeCommand;
        }
        return null;
    }

    public boolean canDisplayExistingLinkBetweenViews(EObject element, View sourceView, View targetView) {
        return element instanceof org.eclipse.uml2.uml.Connector && ConnectorUtils.canDisplayExistingConnectorBetweenViewsAccordingToNestedPaths((org.eclipse.uml2.uml.Connector)((org.eclipse.uml2.uml.Connector)element), (View)sourceView, (View)targetView);
    }

    public final boolean isLinkForViews(Connector link, View sourceView, View targetView) {
        boolean isReverseDrawingAllowed;
        View source = link.getSource();
        View target = link.getTarget();
        boolean isDrawingAllowed = source.equals(sourceView) && target.equals(targetView);
        boolean bl = isReverseDrawingAllowed = source.equals(targetView) && target.equals(sourceView);
        return isDrawingAllowed || isReverseDrawingAllowed;
    }

    protected View getTopViewWithSameSemanticElement(View view) {
        EObject semanticElement = view.getElement();
        View parent = view;
        View lastParent = view;
        while (parent.getElement() == semanticElement) {
            lastParent = parent;
            parent = (View)parent.eContainer();
        }
        return lastParent;
    }
}

