/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.interoperability.rsa.transformation;

import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.Trace;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.dsml.validation.PapyrusDSMLValidationRule.PapyrusDSMLValidationRulePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.interoperability.rsa.Activator;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.Config;
import org.eclipse.papyrus.interoperability.rsa.RSAToPapyrusParameters.RSAToPapyrusParametersFactory;
import org.eclipse.papyrus.interoperability.rsa.concurrent.ExecutorsPool;
import org.eclipse.papyrus.interoperability.rsa.concurrent.ResourceAccessHelper;
import org.eclipse.papyrus.interoperability.rsa.default_.DefaultPackage;
import org.eclipse.papyrus.interoperability.rsa.internal.extension.PostProcessExtension;
import org.eclipse.papyrus.interoperability.rsa.internal.extension.TransformationExtension;
import org.eclipse.papyrus.interoperability.rsa.profilebase.ProfileBasePackage;
import org.eclipse.papyrus.interoperability.rsa.transformation.DependencyAnalysisHelper;
import org.eclipse.papyrus.interoperability.rsa.transformation.MigrationResourceSet;
import org.eclipse.papyrus.interoperability.rsa.transformation.MigrationResourceSetImpl;
import org.eclipse.papyrus.uml.documentation.Documentation.DocumentationPackage;
import org.eclipse.papyrus.uml.m2m.qvto.common.utils.TraceHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ImportTransformation {
    private static final boolean DEBUG = false;
    protected URI sourceURI;
    protected URI targetURI;
    protected ModelExtent outUML;
    protected ModelExtent outNotation;
    protected ModelExtent outSashModel;
    protected ModelExtent inParameters;
    protected ModelExtent inPapyrusProfiles;
    protected MigrationResourceSet resourceSet;
    protected Job job;
    protected Resource umlResource;
    protected Config parameters;
    protected boolean complete = false;
    protected long executionTime = 0L;
    protected long loadingTime = 0L;
    protected long danglingRefTime = 0L;
    protected long importExtensionsTime = 0L;
    protected final Map<URI, URI> uriMappings = new HashMap<URI, URI>();
    protected final Map<URI, URI> profileURIMappings = new HashMap<URI, URI>();
    protected List<Diagram> diagramsToDelete = new LinkedList<Diagram>();
    protected static final ExecutorsPool executorsPool = new ExecutorsPool(2);
    protected static final Set<EPackage> sourceEPackages = new HashSet<EPackage>();
    protected final DependencyAnalysisHelper analysisHelper;
    protected static final List<Class<? extends TransformationExtension>> extensionClasses = ImmutableList.copyOf(ImportTransformation.loadExtensionClasses());
    protected final List<TransformationExtension> extensions;
    public static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.interoperability.rsa.extensions";
    private Trace trace = Trace.createEmptyTrace();
    private ExecutionContext context;
    protected static final Set<String> supportedDiagramIds;

    static {
        sourceEPackages.add(DefaultPackage.eINSTANCE);
        sourceEPackages.add(ProfileBasePackage.eINSTANCE);
        for (TransformationExtension extension : ImportTransformation.getAllExtensions()) {
            sourceEPackages.addAll(extension.getAdditionalSourceEPackages());
        }
        supportedDiagramIds = new HashSet<String>();
        supportedDiagramIds.addAll(Arrays.asList("Class", "Object", "Activity", "Statechart", "Structure"));
    }

    public ImportTransformation(URI sourceURI) {
        this(sourceURI, RSAToPapyrusParametersFactory.eINSTANCE.createConfig(), null);
    }

    public ImportTransformation(URI sourceURI, Config config, DependencyAnalysisHelper analysisHelper) {
        Assert.isNotNull((Object)sourceURI);
        this.sourceURI = sourceURI;
        this.parameters = config;
        this.analysisHelper = analysisHelper;
        this.extensions = ImportTransformation.getAllExtensions();
    }

    protected static List<Class<? extends TransformationExtension>> loadExtensionClasses() {
        IConfigurationElement[] config;
        LinkedList<Class<? extends TransformationExtension>> result = new LinkedList<Class<? extends TransformationExtension>>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String className = e.getAttribute("className");
                Class extensionClass = ClassLoaderHelper.loadClass((String)className, TransformationExtension.class);
                if (result != null) {
                    if (extensionClass.getConstructor(new Class[0]) == null) {
                        Activator.log.error((Throwable)new IllegalArgumentException(String.format("The class %s contributed by %s should have a default constructor", extensionClass.getName(), e.getContributor())));
                    }
                    result.add(extensionClass);
                }
            }
            catch (Throwable t) {
                Activator.log.error(String.format("The plug-in %s contributed an invalid class", e.getContributor()), t);
            }
            ++n2;
        }
        return result;
    }

    protected static List<TransformationExtension> getAllExtensions() {
        ArrayList<TransformationExtension> extensions = new ArrayList<TransformationExtension>(extensionClasses.size());
        for (Class<? extends TransformationExtension> extension : extensionClasses) {
            try {
                extensions.add(extension.newInstance());
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return extensions;
    }

    public void run() {
        this.run(true);
    }

    public void run(final boolean isUserJob) {
        this.job = new Job("Import " + this.getModelName()){

            protected IStatus run(IProgressMonitor monitor) {
                long begin = System.nanoTime();
                IStatus result = ImportTransformation.this.run(monitor);
                long end = System.nanoTime();
                ImportTransformation.this.executionTime = end - begin;
                return result;
            }
        };
        this.job.setUser(isUserJob);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ImportTransformation.this.complete = true;
                if (isUserJob) {
                    if (event.getResult().getSeverity() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).ImportTransformation.this.job.getName(), (String)String.format("Model %s has been successfully imported", ImportTransformation.this.getModelName()));
                            }
                        });
                    } else if (event.getResult().getSeverity() == 8) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(this).ImportTransformation.this.job.getName(), (String)String.format("Operation canceled: %s", ImportTransformation.this.getModelName()));
                            }
                        });
                    } else {
                        StatusManager.getManager().handle(event.getResult(), 4);
                    }
                }
            }
        });
        this.job.schedule();
    }

    public void waitForCompletion() {
        try {
            this.job.join();
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public IStatus getStatus() {
        if (this.job == null) {
            return new Status(8, "org.eclipse.papyrus.interoperability.rsa", "Operation canceled");
        }
        return this.job.getResult();
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public long getLoadingTime() {
        return this.loadingTime;
    }

    public long getHandleDanglingRefTime() {
        return this.danglingRefTime;
    }

    public long getImportExtensionsTime() {
        return this.importExtensionsTime;
    }

    public Map<URI, URI> getURIMappings() {
        return this.uriMappings;
    }

    public Map<URI, URI> getProfileURIMappings() {
        return this.profileURIMappings;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initResourceSet(IProgressMonitor monitor) {
        this.resourceSet = new MigrationResourceSetImpl(this.analysisHelper);
        Class<UMLUtil> clazz = UMLUtil.class;
        synchronized (UMLUtil.class) {
            UMLUtil.init((ResourceSet)this.resourceSet);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.resourceSet.getLoadOptions().put("DEFER_ATTACHMENT", true);
            this.resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
            this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            this.resourceSet.getLoadOptions().put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
            monitor.subTask("Loading source model " + this.getModelName());
            try {
                this.resourceSet.getResource(this.sourceURI, true);
                this.loadInPapyrusProfiles();
            }
            catch (Exception ex) {
                Activator.log.error("An error occurred while loading " + this.getModelName(), (Throwable)ex);
            }
            return;
        }
    }

    protected void initResourceSet(URI sourceURI, MigrationResourceSet resourceSet) {
        this.sourceURI = sourceURI;
        this.resourceSet = resourceSet;
        this.umlResource = resourceSet.getResource(sourceURI, false);
        this.outUML = null;
        this.outNotation = null;
        this.outSashModel = null;
        this.inPapyrusProfiles = null;
    }

    protected int countSupportedElements() {
        int i = 0;
        ModelExtent extent = this.getInOutUMLModel();
        for (EObject eObject : extent.getContents()) {
            TreeIterator modelIterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
            while (modelIterator.hasNext()) {
                OpaqueExpression exp;
                EObject next = (EObject)modelIterator.next();
                if (next instanceof Diagram) {
                    Diagram diagram = (Diagram)next;
                    if (ImportTransformation.isSupported(diagram)) {
                        ++i;
                        this.diagramsToDelete.add(diagram);
                    }
                    modelIterator.prune();
                    continue;
                }
                if (!(next instanceof OpaqueExpression) || !this.parameters.isConvertOpaqueExpressionToLiteralString() || !ImportTransformation.needsConversion(exp = (OpaqueExpression)next)) continue;
                ++i;
            }
        }
        i += this.getAllTransformationURIs().size();
        for (TransformationExtension extension : this.getExtensions()) {
            int extraSteps = extension.getNumberOfSteps();
            if (extraSteps <= 0) continue;
            i += extraSteps;
        }
        return i;
    }

    protected static boolean needsConversion(OpaqueExpression exp) {
        EList languages = exp.getLanguages();
        EList bodies = exp.getBodies();
        if (bodies.size() > 1) {
            return false;
        }
        return languages.isEmpty() || languages.size() == 1 && ((String)exp.getLanguages().get(0)).isEmpty();
    }

    protected static boolean isSupported(Diagram diagram) {
        return supportedDiagramIds.contains(diagram.getType());
    }

    protected IStatus loadTransformations(IProgressMonitor monitor) {
        for (URI transformationURI : this.getAllTransformationURIs()) {
            executorsPool.preLoad(transformationURI);
            monitor.worked(1);
        }
        return Status.OK_STATUS;
    }

    protected static IStatus createStatusFromDiagnostic(Diagnostic diagnostic) {
        return new Status(diagnostic.getSeverity(), diagnostic.getSource(), diagnostic.getMessage(), diagnostic.getException());
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.subTask("Loading source model " + this.getModelName());
        long startLoad = System.nanoTime();
        this.initResourceSet(monitor);
        int numberOfElements = this.countSupportedElements();
        monitor.beginTask("Importing " + this.getModelName(), numberOfElements);
        monitor.subTask("Loading transformations (This may take a few seconds for the first import)...");
        this.loadTransformations(monitor);
        List<ModelExtent> extents = this.getModelExtents();
        String statusMessage = String.format("Import %s", this.getModelName());
        MultiStatus generationStatus = new MultiStatus("org.eclipse.papyrus.interoperability.rsa", 0, statusMessage, null);
        this.context = this.createExecutionContext(monitor, generationStatus);
        try {
            Collection<URI> additional;
            this.getInPapyrusProfiles();
            long endLoad = System.nanoTime();
            this.loadingTime = endLoad - startLoad;
            this.prepareExtensions();
            long startExtensions = System.nanoTime();
            IStatus result = this.importExtensions(this.context, monitor, ExtensionFunction::executeBefore);
            long endExtensions = System.nanoTime();
            this.importExtensionsTime = endExtensions - startExtensions;
            generationStatus.add(result);
            Collection<URI> transformations = this.getDiagramTransformationURIs();
            monitor.subTask("Importing diagrams...");
            Iterator<URI> iterator = transformations.iterator();
            while (iterator.hasNext()) {
                URI transformationURI = iterator.next();
                result = this.runTransformation(transformationURI, extents, monitor);
                generationStatus.add(result);
            }
            monitor.subTask("Importing semantic model...");
            result = this.runTransformation(this.getSemanticTransformationURI(), extents, monitor);
            generationStatus.add(result);
            if (!monitor.isCanceled()) {
                monitor.subTask("Handle additional profiles...");
                result = this.importRSAProfiles(this.context, monitor);
                generationStatus.add(result);
            }
            if (!(additional = this.getAdditionalTransformationURIs()).isEmpty()) {
                monitor.subTask("Additional transformations...");
                for (URI transformationURI : additional) {
                    result = this.runTransformation(transformationURI, extents, monitor);
                    generationStatus.add(result);
                }
            }
            long startExtensionsAfter = System.nanoTime();
            result = this.importExtensions(this.context, monitor, ExtensionFunction::executeAfter);
            long endExtensionsAfter = System.nanoTime();
            this.importExtensionsTime += endExtensionsAfter - startExtensionsAfter;
        }
        finally {
            this.context = null;
        }
        if (generationStatus.getSeverity() <= 2) {
            monitor.subTask("Cleaning-up target model...");
            URI notationModelURI = null;
            URI sashModelURI = null;
            this.targetURI = this.convertToPapyrus(this.sourceURI, "uml");
            notationModelURI = this.convertToPapyrus(this.sourceURI, "notation");
            sashModelURI = this.convertToPapyrus(this.sourceURI, "di");
            if ("epx".equals(this.sourceURI.fileExtension())) {
                this.profileURIMappings.put(this.sourceURI, this.targetURI);
            }
            this.uriMappings.put(this.sourceURI, this.targetURI);
            this.umlResource = this.createUMLResource(this.resourceSet, this.sourceURI, this.targetURI);
            List outUMLObjects = this.getInOutUMLModel().getContents();
            this.umlResource.getContents().addAll((Collection)outUMLObjects);
            GMFResource notationResource = new GMFResource(notationModelURI);
            this.resourceSet.getResources().add((Object)notationResource);
            List outNotationObjects = this.getInoutNotationModel().getContents();
            notationResource.getContents().addAll((Collection)outNotationObjects);
            LinkedList contentsCopy = new LinkedList(notationResource.getContents());
            for (EObject next : contentsCopy) {
                Diagram diagram;
                if (!(next instanceof Diagram) || (diagram = (Diagram)next).getType() != null && !"".equals(diagram.getType())) continue;
                this.delete((EObject)diagram);
            }
            XMIResourceImpl sashResource = new XMIResourceImpl(sashModelURI);
            this.resourceSet.getResources().add((Object)sashResource);
            List sashModelObjects = this.getOutSashModel().getContents();
            sashResource.getContents().addAll((Collection)sashModelObjects);
            this.configureResource((XMIResource)sashResource);
            this.configureResource((XMIResource)notationResource);
            this.configureResource((XMIResource)this.umlResource);
            LinkedList notationRootElements = new LinkedList(notationResource.getContents());
            for (EObject rootElement : notationRootElements) {
                if (rootElement instanceof View) {
                    View rootView = (View)rootElement;
                    if (rootView instanceof Diagram) continue;
                    this.delete(rootElement);
                    continue;
                }
                if (!(rootElement instanceof Style)) continue;
                this.delete(rootElement);
            }
            monitor.subTask("Handling fragments...");
            Collection<Resource> resourcesToSave = this.handleFragments(this.umlResource, (Resource)notationResource, (Resource)sashResource);
            for (Resource resource : resourcesToSave) {
                LinkedList rootElements = new LinkedList(resource.getContents());
                for (EObject rootElement : rootElements) {
                    EPackage ePackage = rootElement.eClass().getEPackage();
                    if (ePackage != ProfileBasePackage.eINSTANCE && ePackage != DefaultPackage.eINSTANCE) continue;
                    this.delete(rootElement);
                }
            }
            monitor.subTask("Deleting source diagrams...");
            for (Diagram diagram : this.diagramsToDelete) {
                EAnnotation annotation;
                EObject container = diagram.eContainer();
                this.delete((EObject)diagram);
                if (!(container instanceof EAnnotation) || !(annotation = (EAnnotation)container).getContents().isEmpty()) continue;
                this.delete((EObject)annotation);
            }
            this.diagramsToDelete.clear();
            monitor.subTask("Analyzing dangling references...");
            long startDangling = System.nanoTime();
            this.handleDanglingURIs(resourcesToSave);
            long endDangling = System.nanoTime();
            this.danglingRefTime = endDangling - startDangling;
            monitor.subTask("Saving models...");
            for (Resource resource : resourcesToSave) {
                try {
                    this.cleanMetadataAnnotations(resource);
                    ResourceAccessHelper.INSTANCE.saveResource(resource, null);
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                    generationStatus.add((IStatus)new Status(4, "org.eclipse.papyrus.interoperability.rsa", "An exception occurred during save", (Throwable)ex));
                }
            }
        }
        monitor.subTask("Releasing memory...");
        this.unloadResourceSet(this.resourceSet);
        this.resourceSet = null;
        this.umlResource = null;
        this.outUML = null;
        this.outSashModel = null;
        this.inParameters = null;
        this.outNotation = null;
        monitor.done();
        return generationStatus;
    }

    protected void prepareExtensions() {
        for (TransformationExtension extension : this.getExtensions()) {
            extension.setResourceSet(this.resourceSet);
            extension.setExecutorsPool(executorsPool);
            extension.setTransformation(this);
        }
    }

    protected List<TransformationExtension> getExtensions() {
        return this.extensions;
    }

    protected IStatus importExtensions(ExecutionContext context, IProgressMonitor monitor, ExtensionFunction function) {
        ArrayList<IStatus> allResults = new ArrayList<IStatus>(this.getExtensions().size());
        for (TransformationExtension extension : this.getExtensions()) {
            IStatus result = function.apply(extension, context, monitor);
            allResults.add(result);
        }
        if (allResults.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (allResults.size() == 1) {
            return (IStatus)allResults.get(0);
        }
        return ImportTransformation.aggregateStatus(allResults);
    }

    public static MultiStatus aggregateStatus(List<IStatus> statuses) {
        return new MultiStatus("org.eclipse.papyrus.interoperability.rsa", 0, statuses.toArray(new IStatus[statuses.size()]), "", null);
    }

    private void cleanMetadataAnnotations(Resource resource) {
        Iterator rootElementsIterator = resource.getContents().iterator();
        while (rootElementsIterator.hasNext()) {
            EAnnotation annotation;
            EObject root = (EObject)rootElementsIterator.next();
            if (!(root instanceof EAnnotation) || !"http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals((annotation = (EAnnotation)root).getSource())) continue;
            rootElementsIterator.remove();
        }
    }

    protected void handleDanglingURIs(Collection<Resource> resourcesToSave) {
        if (this.analysisHelper != null) {
            this.resourceSet.freeze();
            try {
                this.analysisHelper.computeURIMappings(resourcesToSave);
            }
            finally {
                this.resourceSet.unfreeze();
            }
        }
    }

    protected void unloadResourceSet(ResourceSet resourceSet) {
        EMFHelper.unload((ResourceSet)resourceSet);
    }

    protected IStatus importRSAProfiles(ExecutionContext context, IProgressMonitor monitor) {
        URI transformationURI = this.getProfilesTransformationURI();
        LinkedList<ModelExtent> extents = new LinkedList<ModelExtent>();
        extents.add(this.getInOutUMLModel());
        extents.add(this.getInoutNotationModel());
        Diagnostic loadedProfiles = this.loadInPapyrusProfiles();
        extents.add(this.getInPapyrusProfiles());
        extents.add(this.getInProfileDefinitions());
        extents.add(this.getInConfig());
        IStatus transformationStatus = this.runTransformation(transformationURI, extents, monitor);
        IStatus loadedProfilesStatus = ImportTransformation.createStatusFromDiagnostic(loadedProfiles);
        int severity = Math.max(loadedProfiles.getSeverity(), transformationStatus.getSeverity());
        String message = severity > 0 ? "The following errors occurred:" : "OK";
        MultiStatus completeResult = new MultiStatus("org.eclipse.papyrus.interoperability.rsa", severity, new IStatus[]{loadedProfilesStatus, transformationStatus}, message, null);
        return completeResult;
    }

    protected TransformationExecutor getTransformation(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        return executorsPool.getExecutor(transformationURI);
    }

    protected static synchronized TransformationExecutor loadTransformationExecutor(URI transformationURI, IProgressMonitor monitor) throws DiagnosticException {
        TransformationExecutor executor = new TransformationExecutor(transformationURI);
        Diagnostic diagnostic = executor.loadTransformation(monitor);
        if (diagnostic.getSeverity() != 0) {
            throw new DiagnosticException(diagnostic);
        }
        return executor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties readProfileBaseProperties() {
        URI propertiesURI = this.sourceURI.trimFileExtension().appendFileExtension("properties");
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            try {
                URL url = new URL(propertiesURI.toString());
                inputStream = url.openStream();
                properties.load(inputStream);
                return properties;
            }
            catch (FileNotFoundException url) {
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
                return properties;
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
                if (inputStream == null) return properties;
                try {
                    inputStream.close();
                    return properties;
                }
                catch (IOException ex2) {
                    Activator.log.error((Throwable)ex2);
                }
                return properties;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
    }

    protected ModelExtent getInProfileDefinitions() {
        return new BasicModelExtent(Arrays.asList(PapyrusDSMLValidationRulePackage.eINSTANCE, DocumentationPackage.eINSTANCE));
    }

    protected ModelExtent getInPapyrusProfiles() {
        if (this.inPapyrusProfiles == null) {
            this.loadInPapyrusProfiles();
        }
        return this.inPapyrusProfiles;
    }

    protected Diagnostic loadInPapyrusProfiles() {
        int code;
        String message;
        if (this.inPapyrusProfiles != null) {
            return Diagnostic.OK_INSTANCE;
        }
        LinkedList<String> missingProfiles = new LinkedList<String>();
        LinkedList allContents = new LinkedList();
        try {
            URI validationProfileURI = URI.createURI((String)"pathmap://DSMLValidation_PROFILES/PapyrusValidationRuleDSML.uml");
            Resource validationProfile = this.resourceSet.getResource(validationProfileURI, true);
            this.checkResource(validationProfile);
            allContents.addAll(validationProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("Validation Rules Profile");
        }
        try {
            URI documentationProfileURI = URI.createURI((String)"pathmap://PAPYRUS_DOCUMENTATION/Papyrus.profile.uml");
            Resource documentationProfile = this.resourceSet.getResource(documentationProfileURI, true);
            this.checkResource(documentationProfile);
            allContents.addAll(documentationProfile.getContents());
        }
        catch (WrappedException ex) {
            missingProfiles.add("Documentation Profile");
        }
        this.inPapyrusProfiles = new BasicModelExtent(allContents);
        if (missingProfiles.isEmpty()) {
            message = "OK";
            code = 0;
        } else {
            message = "The following Papyrus profiles cannot be found: " + ListHelper.deepToString(missingProfiles, (String)", ");
            code = 4;
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(code, "org.eclipse.papyrus.interoperability.rsa", code, message, null);
        return diagnostic;
    }

    protected void checkResource(Resource resource) {
        Assert.isNotNull((Object)resource);
        Assert.isTrue((!resource.getContents().isEmpty() ? 1 : 0) != 0, (String)("The resource " + resource.getURI() + " is empty"));
        for (EObject rootElement : resource.getContents()) {
            Assert.isTrue((!rootElement.eIsProxy() ? 1 : 0) != 0);
        }
    }

    protected Resource createUMLResource(ResourceSet resourceSet, URI sourceResourceURI, URI targetResourceURI) {
        Resource resource = resourceSet.getResource(sourceResourceURI, false);
        resource.setURI(targetResourceURI);
        return resource;
    }

    protected ModelExtent getInConfig() {
        if (this.inParameters == null) {
            this.inParameters = new BasicModelExtent(Collections.singletonList(this.parameters));
        }
        return this.inParameters;
    }

    protected Collection<Resource> handleFragments(Resource umlResource, Resource notationResource, Resource sashResource) {
        HashSet<Resource> result = new HashSet<Resource>();
        result.add(umlResource);
        result.add(notationResource);
        result.add(sashResource);
        ResourceSet resourceSet = umlResource.getResourceSet();
        TreeIterator elementIterator = umlResource.getAllContents();
        HashSet<Resource> fragmentResources = new HashSet<Resource>();
        ArrayList rsaAnnotations = new ArrayList();
        while (elementIterator.hasNext()) {
            EObject element = (EObject)elementIterator.next();
            Resource possibleFragment = element.eResource();
            if (possibleFragment != umlResource && possibleFragment.getContents().contains((Object)element)) {
                fragmentResources.add(possibleFragment);
            }
            this.collectRSAAnnotations(element, rsaAnnotations);
        }
        rsaAnnotations.forEach(EcoreUtil::remove);
        LinkedList<Resource> fragmentUMLResources = new LinkedList<Resource>();
        for (Resource fragmentResource : fragmentResources) {
            XMIResourceImpl fragmentDiResource22;
            Throwable fragmentNotationResource;
            URI papyrusFragmentURI = this.convertToPapyrus(fragmentResource.getURI(), "uml");
            this.uriMappings.put(fragmentResource.getURI(), papyrusFragmentURI);
            Resource newResource = resourceSet.getResource(papyrusFragmentURI, false);
            if (newResource == null) {
                newResource = this.createUMLResource(resourceSet, fragmentResource.getURI(), papyrusFragmentURI);
                fragmentUMLResources.add(newResource);
                fragmentNotationResource = new GMFResource(this.convertToPapyrus(papyrusFragmentURI, "notation"));
                fragmentDiResource22 = new XMIResourceImpl(this.convertToPapyrus(papyrusFragmentURI, "di"));
                result.add((Resource)fragmentNotationResource);
                result.add((Resource)fragmentDiResource22);
                resourceSet.getResources().add((Object)fragmentNotationResource);
                resourceSet.getResources().add((Object)fragmentDiResource22);
            }
            newResource.getContents().addAll((Collection)fragmentResource.getContents());
            fragmentNotationResource = null;
            fragmentDiResource22 = null;
            try (ShardResourceHelper shard = new ShardResourceHelper(newResource);){
                shard.setShard(true);
            }
            catch (Throwable fragmentDiResource22) {
                if (fragmentNotationResource == null) {
                    fragmentNotationResource = fragmentDiResource22;
                } else if (fragmentNotationResource != fragmentDiResource22) {
                    fragmentNotationResource.addSuppressed(fragmentDiResource22);
                }
                throw fragmentNotationResource;
            }
            result.add(newResource);
        }
        this.deleteSourceStereotypes(fragmentResources);
        LinkedList importedElements = new LinkedList(notationResource.getContents());
        for (EObject notationElement : importedElements) {
            EObject semanticElement;
            if (!(notationElement instanceof Diagram) || (semanticElement = ((Diagram)notationElement).getElement()).eResource() == umlResource || semanticElement.eResource() == null) continue;
            URI notationFragmentURI = this.convertToPapyrus(semanticElement.eResource().getURI(), "notation");
            Resource newNotationResource = resourceSet.getResource(notationFragmentURI, false);
            if (newNotationResource == null) {
                newNotationResource = new GMFResource(notationFragmentURI);
                resourceSet.getResources().add((Object)newNotationResource);
            }
            newNotationResource.getContents().add((Object)notationElement);
            result.add(newNotationResource);
        }
        this.handleFragmentStereotypes(umlResource, fragmentUMLResources);
        for (Resource resource : result) {
            if (!(resource instanceof XMIResource)) continue;
            this.configureResource((XMIResource)resource);
        }
        return result;
    }

    protected void handleFragmentStereotypes(Resource mainUMLResource, List<Resource> umlResources) {
        Iterator rootElementIterator = mainUMLResource.getContents().iterator();
        while (rootElementIterator.hasNext()) {
            Resource targetStereotypeResource;
            EObject rootElement = (EObject)rootElementIterator.next();
            if (rootElement instanceof Element || (targetStereotypeResource = this.getTargetStereotypeResource(rootElement, umlResources)) == null || targetStereotypeResource == mainUMLResource) continue;
            rootElementIterator.remove();
            targetStereotypeResource.getContents().add((Object)rootElement);
        }
    }

    protected Resource getTargetStereotypeResource(EObject rootElement, List<Resource> umlResources) {
        for (EReference eReference : rootElement.eClass().getEAllReferences()) {
            Object value;
            if (!eReference.getName().startsWith("base_") || !((value = rootElement.eGet((EStructuralFeature)eReference)) instanceof Element)) continue;
            return ((Element)value).eResource();
        }
        return null;
    }

    protected void deleteSourceStereotypes(Collection<Resource> fragmentResources) {
        HashSet<Resource> allResources = new HashSet<Resource>(fragmentResources);
        allResources.add(this.umlResource);
        for (Resource resource : allResources) {
            LinkedList resourceContents = new LinkedList(resource.getContents());
            for (EObject rootElement : resourceContents) {
                if (!sourceEPackages.contains(rootElement.eClass().getEPackage())) continue;
                this.delete(rootElement);
            }
        }
    }

    protected void collectRSAAnnotations(EObject object, Collection<? super EAnnotation> annotations) {
        if (object instanceof EModelElement) {
            EModelElement modelElement = (EModelElement)object;
            modelElement.getEAnnotations().stream().filter(this::isRSASpecificAnnotation).forEach(annotations::add);
        }
    }

    protected boolean isRSASpecificAnnotation(EAnnotation annotation) {
        boolean result = false;
        String source = annotation.getSource();
        if (source != null) {
            result = source.startsWith("com.ibm.xtools.uml.msl.fragment") || source.equals("uml2.diagrams") || source.startsWith("com.ibm.xtools.common.ui.");
        }
        return result;
    }

    protected URI convertToPapyrus(URI rsaURI, String extension) {
        if ("epx".equals(rsaURI.fileExtension())) {
            return rsaURI.trimFileExtension().appendFileExtension("profile").appendFileExtension(extension);
        }
        return rsaURI.trimFileExtension().appendFileExtension(extension);
    }

    public IStatus runTransformation(URI transformationURI, List<ModelExtent> extents, IProgressMonitor monitor) {
        return this.runTransformation(transformationURI, this.context, monitor, extents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus runTransformation(URI transformationURI, ExecutionContext context, IProgressMonitor monitor, List<ModelExtent> extents) {
        ExecutionDiagnostic result;
        TransformationExecutor executor;
        if (monitor.isCanceled()) {
            return new Status(8, "org.eclipse.papyrus.interoperability.rsa", "Operation canceled");
        }
        try {
            executor = this.getTransformation(transformationURI, monitor);
        }
        catch (DiagnosticException ex) {
            Diagnostic diagnostic = ex.getDiagnostic();
            Activator.log.warn(String.format("Cannot load the transformation : %s. Diagnostic: %s", transformationURI, diagnostic.getMessage()));
            return ImportTransformation.createStatusFromDiagnostic(diagnostic);
        }
        TransformationExecutor transformationExecutor = executor;
        synchronized (transformationExecutor) {
            try {
                Trace newTraces = Trace.createEmptyTrace();
                ISessionData.SimpleEntry traceKey = QVTEvaluationOptions.INCREMENTAL_UPDATE_TRACE;
                context.getSessionData().setValue((ISessionData.Entry)traceKey, (Object)newTraces);
                result = executor.execute(context, extents.toArray(new ModelExtent[0]));
                ArrayList history = new ArrayList(this.trace.getTraceContent());
                history.addAll(newTraces.getTraceContent());
                this.trace.setTraceContent(history);
            }
            finally {
                executor.cleanup();
                executorsPool.releaseExecutor(executor);
            }
        }
        return ImportTransformation.createStatusFromDiagnostic((Diagnostic)result);
    }

    protected ExecutionContext createExecutionContext(IProgressMonitor monitor, final MultiStatus generationStatus) {
        ExecutionContextImpl context = new ExecutionContextImpl();
        context.setConfigProperty("keepModeling", (Object)true);
        context.setConfigProperty("monitor", (Object)monitor);
        context.setLog((Log)new WriterLog(new OutputStreamWriter(System.out)){

            public void log(String message) {
                super.log(message);
            }

            public void log(String message, Object param) {
                super.log(message, param);
            }

            public void log(int level, String message) {
                super.log(level, message);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.interoperability.rsa", message));
                }
            }

            public void log(int level, String message, Object param) {
                super.log(level, message, param);
                if (level >= 1) {
                    generationStatus.merge((IStatus)new Status(level, "org.eclipse.papyrus.interoperability.rsa", String.valueOf(message) + ", data:" + param));
                }
            }
        });
        this.initTransformationProperties(context);
        context.getSessionData().setValue((ISessionData.Entry)TraceHelper.TRACE_HISTORY, (Object)this.trace);
        this.context = context;
        return context;
    }

    protected void initTransformationProperties(ExecutionContextImpl context) {
        context.setConfigProperty("profilebase.properties", (Object)this.readProfileBaseProperties());
        URI innerClassDiagramViewURI = URI.createPlatformPluginURI((String)"org.eclipse.papyrus.uml.architecture/model/uml.architecture", (boolean)false);
        Resource resource = this.resourceSet.getResource(innerClassDiagramViewURI, true);
        ArchitectureDomain domain = (ArchitectureDomain)resource.getContents().get(0);
        EObject eObject = (EObject)domain.getContexts().get(0);
        RepresentationKind innerClassDiagram = null;
        if (eObject instanceof ArchitectureDescriptionLanguage) {
            Iterator representationKinds = ((ArchitectureDescriptionLanguage)eObject).getRepresentationKinds().iterator();
            while (representationKinds.hasNext() && innerClassDiagram == null) {
                RepresentationKind representationKind = (RepresentationKind)representationKinds.next();
                if (!representationKind.getName().equals("Inner Class Diagram")) continue;
                innerClassDiagram = representationKind;
            }
        }
        context.setConfigProperty("InnerClassDiagramView", innerClassDiagram);
    }

    protected void configureResource(XMIResource resource) {
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("DECLARE_XML", Boolean.TRUE);
        saveOptions.put("PROCESS_DANGLING_HREF", "DISCARD");
        saveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        saveOptions.put("USE_XMI_TYPE", Boolean.TRUE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        saveOptions.put("SKIP_ESCAPE_URI", Boolean.FALSE);
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        resource.setEncoding("UTF-8");
        resource.getDefaultSaveOptions().putAll(saveOptions);
    }

    protected List<ModelExtent> getModelExtents() {
        LinkedList<ModelExtent> allExtents = new LinkedList<ModelExtent>();
        allExtents.add(this.getInOutUMLModel());
        allExtents.add(this.getInoutNotationModel());
        allExtents.add(this.getOutSashModel());
        allExtents.add(this.getInConfig());
        return allExtents;
    }

    public ModelExtent getInOutUMLModel() {
        if (this.outUML == null) {
            try {
                Resource resource = this.resourceSet.getResource(this.sourceURI, true);
                LinkedList<EObject> allStereotypeApplications = new LinkedList<EObject>();
                TreeIterator allContents = resource.getAllContents();
                HashSet<Resource> browsedResources = new HashSet<Resource>();
                browsedResources.add(resource);
                while (allContents.hasNext()) {
                    EObject next = (EObject)allContents.next();
                    if (!(next instanceof Element)) {
                        allContents.prune();
                        continue;
                    }
                    Resource nextResource = next.eResource();
                    if (browsedResources.contains(nextResource)) continue;
                    browsedResources.add(nextResource);
                    for (EObject rootElement : nextResource.getContents()) {
                        EPackage rootElementPackage = rootElement.eClass().getEPackage();
                        if (!sourceEPackages.contains(rootElementPackage)) continue;
                        allStereotypeApplications.add(rootElement);
                    }
                }
                LinkedList<EObject> allRootElements = new LinkedList<EObject>((Collection<EObject>)resource.getContents());
                allRootElements.addAll(allStereotypeApplications);
                this.outUML = new BasicModelExtent(allRootElements);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return this.outUML;
    }

    public ModelExtent getInoutNotationModel() {
        if (this.outNotation == null) {
            try {
                NotationModel notation;
                if (this.resourceSet instanceof ModelSet && (notation = (NotationModel)((ModelSet)this.resourceSet).getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel")) != null) {
                    List diagrams = notation.getResources().stream().flatMap(res -> res.getContents().stream()).filter(Diagram.class::isInstance).collect(Collectors.toList());
                    this.outNotation = new BasicModelExtent(diagrams);
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            if (this.outNotation == null) {
                this.outNotation = new BasicModelExtent();
            }
        }
        return this.outNotation;
    }

    protected ModelExtent getOutSashModel() {
        if (this.outSashModel == null) {
            this.outSashModel = new BasicModelExtent();
        }
        return this.outSashModel;
    }

    protected Collection<URI> getDiagramTransformationURIs() {
        return ListHelper.asList((Object[])new URI[]{this.getTransformationURI("RSAClassDiagram"), this.getTransformationURI("RSAStructureDiagram"), this.getTransformationURI("RSAActivityDiagram"), this.getTransformationURI("RSAStateMachineDiagram"), this.getTransformationURI("RSAProfileDiagram"), this.getTransformationURI("RSAUsecaseDiagram")});
    }

    protected URI getSemanticTransformationURI() {
        return this.getTransformationURI("RSAModelToPapyrus");
    }

    protected URI getProfilesTransformationURI() {
        return this.getTransformationURI("RSAProfilesToPapyrus");
    }

    protected Collection<URI> getAdditionalTransformationURIs() {
        return Collections.emptyList();
    }

    protected Collection<URI> getAllTransformationURIs() {
        Collection<URI> allTransformations = this.getDiagramTransformationURIs();
        allTransformations.add(this.getProfilesTransformationURI());
        allTransformations.add(this.getSemanticTransformationURI());
        allTransformations.addAll(this.getAdditionalTransformationURIs());
        return allTransformations;
    }

    protected URI getTransformationURI(String transformationName) {
        return URI.createPlatformPluginURI((String)String.format("%s/transform/%s.qvto", "org.eclipse.papyrus.interoperability.rsa", transformationName), (boolean)true);
    }

    public String getModelName() {
        return URI.decode((String)this.sourceURI.lastSegment());
    }

    public void cancel() {
        this.job.cancel();
    }

    public void delete(EObject elementToDelete) {
        EObject parent;
        CacheAdapter adapter = CacheAdapter.getCacheAdapter((Notifier)elementToDelete);
        if (adapter == null) {
            adapter = CacheAdapter.getInstance();
        }
        adapter.unsetTarget((Notifier)elementToDelete);
        if (elementToDelete.eResource() != null) {
            elementToDelete.eResource().getContents().remove((Object)elementToDelete);
        }
        if ((parent = elementToDelete.eContainer()) == null) {
            return;
        }
        EReference containmentFeature = elementToDelete.eContainmentFeature();
        if (containmentFeature.getUpperBound() == 1) {
            parent.eUnset((EStructuralFeature)containmentFeature);
        } else {
            List values = (List)parent.eGet((EStructuralFeature)containmentFeature);
            values.remove(elementToDelete);
        }
    }

    public URI getSourceURI() {
        return this.sourceURI;
    }

    @FunctionalInterface
    protected static interface ExtensionFunction {
        public IStatus apply(TransformationExtension var1, ExecutionContext var2, IProgressMonitor var3);

        public static IStatus executeBefore(TransformationExtension extension, ExecutionContext context, IProgressMonitor monitor) {
            return extension.executeBefore(context, monitor);
        }

        public static IStatus executeAfter(TransformationExtension extension, ExecutionContext context, IProgressMonitor monitor) {
            return extension.executeAfter(context, monitor);
        }

        public static IStatus postProcess(TransformationExtension extension, ExecutionContext context, IProgressMonitor monitor) {
            return Optional.of(extension).filter(PostProcessExtension.class::isInstance).map(PostProcessExtension.class::cast).map(post -> post.postProcess(context, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1))).orElse(Status.OK_STATUS);
        }
    }
}

