/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.diagram.common.edit.policy;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.XYLayoutWithConstrainedResizedEditPolicy;

public class DefaultXYLayoutEditPolicy
extends XYLayoutWithConstrainedResizedEditPolicy {
    protected Command getCreateCommand(CreateRequest request) {
        boolean couldBeSnaped;
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        boolean bl = couldBeSnaped = request.getLocation().equals((Object)LayoutHelper.UNDEFINED.getLocation()) && req.isSnapToEnabled();
        if (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            if (couldBeSnaped) {
                int add = 0;
                DiagramRootEditPart drep = (DiagramRootEditPart)this.getHost().getRoot();
                double spacing = drep.getGridSpacing();
                double max_value = spacing * 20.0;
                SnapToHelper helper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
                if (helper != null) {
                    LayoutHelper layoutHelper = new LayoutHelper();
                    while ((double)add < max_value) {
                        Rectangle LOCAL_BOUNDS = BOUNDS.getCopy();
                        LOCAL_BOUNDS.translate(add, add);
                        Rectangle tmp_rect = this.getBoundsOffest(req, LOCAL_BOUNDS, viewDescriptor);
                        PrecisionRectangle resultRect = new PrecisionRectangle(tmp_rect);
                        resultRect.setWidth(-1);
                        resultRect.setHeight(-1);
                        PrecisionPoint res1 = new PrecisionPoint(tmp_rect.getLocation());
                        helper.snapPoint((Request)request, 9, res1.getPreciseCopy(), res1);
                        Point pt = layoutHelper.validatePosition(this.getHostFigure(), resultRect.setLocation((Point)res1));
                        if (!couldBeSnaped) continue;
                        if (pt.equals((Object)resultRect.getLocation())) {
                            rect.setLocation(resultRect.getLocation());
                            break;
                        }
                        add = (int)((double)add + spacing);
                    }
                }
            }
            if (rect.getSize().isEmpty()) {
                cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect.getLocation().getCopy()));
            } else {
                cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
            }
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }
}

