/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.sysml.diagram.common.utils.SysMLMultiplicityElementUtil;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyLabelParser
extends NamedElementLabelParser {
    protected static final String VISIBILITY_FORMAT = "%s %s";
    protected static final String DERIVED_FORMAT = "%s/";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String MULTIPLICITY_FORMAT_ALT = "%s [%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Property) {
            String multiplicity;
            Property property = (Property)eObject;
            if (maskValues.contains("visibility")) {
                String visibility;
                switch (property.getVisibility().getValue()) {
                    case 3: {
                        visibility = "~";
                        break;
                    }
                    case 0: {
                        visibility = "+";
                        break;
                    }
                    case 2: {
                        visibility = "#";
                        break;
                    }
                    case 1: {
                        visibility = "-";
                        break;
                    }
                    default: {
                        visibility = "+";
                    }
                }
                result = String.format(VISIBILITY_FORMAT, visibility, result);
            }
            if (maskValues.contains("derived") && property.isDerived()) {
                result = String.format(DERIVED_FORMAT, result);
            }
            if (maskValues.contains("name") && property.isSetName()) {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property);
                result = String.format(NAME_FORMAT, result, name);
            }
            if (maskValues.contains("type")) {
                String type = "<Undefined>";
                if (property.getType() != null) {
                    type = UMLLabelInternationalization.getInstance().getLabel((NamedElement)property.getType());
                }
                if (maskValues.contains("undefinedType") || !"<Undefined>".equals(type)) {
                    result = String.format(TYPE_FORMAT, result, type);
                }
            }
            if (maskValues.contains("multiplicity") && (multiplicity = SysMLMultiplicityElementUtil.formatMultiplicity((MultiplicityElement)property, maskValues)) != null && !multiplicity.isEmpty()) {
                result = String.valueOf(result) + " " + multiplicity;
            }
            if (maskValues.contains("defaultValue") && property.getDefaultValue() != null) {
                ValueSpecification valueSpecification = property.getDefaultValue();
                result = String.format(DEFAULT_VALUE_FORMAT, result, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpecification, (boolean)true));
            }
            if (maskValues.contains("modifiers")) {
                EList redefinedProperties;
                StringBuffer sb = new StringBuffer();
                if (property.isReadOnly()) {
                    sb.append(sb.length() == 0 ? "readOnly" : ", readOnly");
                }
                if (property.isOrdered()) {
                    sb.append(sb.length() == 0 ? "ordered" : ", ordered");
                }
                if (property.isUnique()) {
                    sb.append(sb.length() == 0 ? "unique" : ", unique");
                }
                if (property.isDerivedUnion()) {
                    sb.append(sb.length() == 0 ? "union" : ", union");
                }
                if ((redefinedProperties = property.getRedefinedProperties()) != null && !redefinedProperties.isEmpty()) {
                    for (Property p : redefinedProperties) {
                        sb.append(sb.length() == 0 ? UMLLabelInternationalization.getInstance().getLabel((NamedElement)p) : ", redefines " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)p));
                    }
                }
                if (sb.length() != 0) {
                    result = String.format(MODIFIER_FORMAT, result, sb.toString());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getInstanceValue_Instance().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature) || UMLPackage.eINSTANCE.getStructuralFeature_IsReadOnly().equals(feature) || UMLPackage.eINSTANCE.getFeature_IsStatic().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerived().equals(feature) || UMLPackage.eINSTANCE.getProperty_IsDerivedUnion().equals(feature) || UMLPackage.eINSTANCE.getProperty_RedefinedProperty().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Property) {
            Property semElement = (Property)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
            if (semElement.getDefaultValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getDefaultValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("visibility", "Visibility");
        masks.put("derived", "Is Derived");
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("undefinedType", "Show <Undefined> type");
        masks.put("multiplicity", "Multiplicity");
        masks.put("defaultMultiplicity", "Show default multiplicity");
        masks.put("defaultValue", "Default Value");
        masks.put("modifiers", "Modifiers");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name", "type", "multiplicity", "undefinedType");
    }
}

