/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.edit.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.gmf.diagram.common.edit.policy.ILinkMappingHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.internalblock.dnd.helper.CustomLinkMappingHelper;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.CustomGraphicalTypeRegistry;
import org.eclipse.papyrus.sysml.diagram.internalblock.utils.PortDropHelper;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementNodeLabelEditPart;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CustomDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    private ConnectorUtils utils = new ConnectorUtils();

    public CustomDragDropEditPolicy() {
        super((ILinkMappingHelper)new CustomLinkMappingHelper());
        this.registry = new CustomGraphicalTypeRegistry();
    }

    protected Set<String> getSpecificDropBehaviorTypes() {
        HashSet<String> specificDropBehaviorTypes = new HashSet<String>();
        specificDropBehaviorTypes.add("link_uml_connector");
        return specificDropBehaviorTypes;
    }

    protected ICommand getSpecificDropCommand(DropObjectsRequest dropRequest, EObject droppedEObject, String nodeType, String edgeType) {
        if ("link_uml_connector".equals(edgeType) && droppedEObject instanceof Connector) {
            return this.getConnectorDropCommand(dropRequest, (Connector)droppedEObject, edgeType);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand getConnectorDropCommand(DropObjectsRequest dropRequest, Connector droppedEObject, String edgeType) {
        if (droppedEObject.getEnds().size() != 2) {
            return UnexecutableCommand.INSTANCE;
        }
        ConnectorEnd source = (ConnectorEnd)droppedEObject.getEnds().get(0);
        ConnectorEnd target = (ConnectorEnd)droppedEObject.getEnds().get(1);
        return this.dropBinaryLink(new CompositeCommand("drop Connector"), (Element)source.getRole(), (Element)target.getRole(), edgeType, dropRequest.getLocation(), (Element)droppedEObject);
    }

    protected CompositeCommand dropBinaryLink(CompositeCommand cc, Element source, Element target, String edgeType, Point absoluteLocation, Element semanticLink) {
        IAdaptable sourceViewAdapter = this.findAdapter(cc, source, this.getLinkSourceDropLocation(absoluteLocation, source, target), edgeType);
        IAdaptable targetViewAdapter = this.findAdapter(cc, target, this.getLinkTargetDropLocation(absoluteLocation, source, target), edgeType);
        SemanticAdapter droppedViewAdapter = new SemanticAdapter((EObject)semanticLink, null);
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)droppedViewAdapter, edgeType, this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), edgeType, sourceViewAdapter, targetViewAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        createConnectionViewCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)createConnectionViewCommand);
        return cc;
    }

    protected Point getLinkSourceDropLocation(Point absoluteLocation, Element source, Element target) {
        return absoluteLocation;
    }

    protected Point getLinkTargetDropLocation(Point absoluteLocation, Element source, Element target) {
        if (this.lookForEditPart((EObject)source) == null && this.lookForEditPart((EObject)target) == null) {
            return absoluteLocation.getTranslated(100, 0);
        }
        return absoluteLocation;
    }

    private IAdaptable findAdapter(CompositeCommand cc, Element source, Point dropLocation, String edgeType) {
        IAdaptable result = this.getElement2IAdaptableRegistryHelper().findAdapter(source);
        if (result != null) {
            return result;
        }
        GraphicalEditPart editPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        if (editPart != null) {
            return new SemanticAdapter(null, editPart.getModel());
        }
        if (this.isPortSource(source)) {
            ICommand createPortCommand = this.createPortViewCommand(source, dropLocation);
            cc.add((IUndoableOperation)createPortCommand);
            return (IAdaptable)createPortCommand.getCommandResult().getReturnValue();
        }
        ICommand createCommand = this.getDefaultDropNodeCommand(edgeType, dropLocation, (EObject)source);
        cc.add((IUndoableOperation)createCommand);
        return (IAdaptable)createCommand.getCommandResult().getReturnValue();
    }

    protected boolean isPortSource(Element source) {
        return source instanceof Port;
    }

    private ICommand createPortViewCommand(Element source, Point dropLocation) {
        if (!(source instanceof Port)) {
            return new CommandProxy((Command)org.eclipse.gef.commands.UnexecutableCommand.INSTANCE);
        }
        EditPart portContainer = this.lookForEditPart(source.eContainer(), true);
        if (portContainer == null) {
            return new CommandProxy((Command)org.eclipse.gef.commands.UnexecutableCommand.INSTANCE);
        }
        PortDropHelper portDropHelper = new PortDropHelper(this.getEditingDomain());
        return portDropHelper.getDropPortOnPart((Port)source, dropLocation.getCopy(), (GraphicalEditPart)portContainer);
    }

    protected EditPart lookForEditPart(EObject semantic) {
        return this.lookForEditPart(semantic, false);
    }

    protected EditPart lookForEditPart(EObject semantic, boolean byType) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        for (EditPart nextEditPart : editPartSet) {
            Type nextSemanticType;
            if (!this.isEditPartTypeAdapted(nextEditPart.getClass(), semantic.eClass())) continue;
            EObject nextSemantic = ((GraphicalEditPart)nextEditPart).resolveSemanticElement();
            if (semantic.equals(nextSemantic)) {
                return nextEditPart;
            }
            if (!byType || !(nextSemantic instanceof TypedElement) || ((TypedElement)nextSemantic).getType() == null || !semantic.equals(nextSemanticType = ((TypedElement)nextSemantic).getType())) continue;
            return nextEditPart;
        }
        return null;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (AbstractElementNodeLabelEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }

    private View getFirstValidTargetViewForSource(View sourceView, Collection<View> targetViews, Connector droppedConnector) {
        for (View targetView : targetViews) {
            if (!this.isValidTargetViewForSource(sourceView, targetView, droppedConnector)) continue;
            return targetView;
        }
        return null;
    }

    private boolean isValidTargetViewForSource(View sourceView, View targetView, Connector droppedConnector) {
        if (!this.utils.isCrossingEncapsulation(sourceView, targetView)) {
            EList currentTargetConnectorPropertyPath;
            EList currentSourceConnectorPropertyPath;
            List sourceNestedPaths = this.utils.getNestedPropertyPath(sourceView, targetView);
            List targetNestedPaths = this.utils.getNestedPropertyPath(targetView, sourceView);
            ConnectorEnd sourceConnectorEnd = this.utils.getSourceConnectorEnd(droppedConnector);
            NestedConnectorEnd nestedSourceConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)sourceConnectorEnd, NestedConnectorEnd.class);
            if (nestedSourceConnectorEnd != null ? !sourceNestedPaths.equals(currentSourceConnectorPropertyPath = nestedSourceConnectorEnd.getPropertyPath()) : !sourceNestedPaths.isEmpty()) {
                return false;
            }
            ConnectorEnd targetConnectorEnd = this.utils.getTargetConnectorEnd(droppedConnector);
            NestedConnectorEnd nestedTargetConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)targetConnectorEnd, NestedConnectorEnd.class);
            if (nestedTargetConnectorEnd != null ? !targetNestedPaths.equals(currentTargetConnectorPropertyPath = nestedTargetConnectorEnd.getPropertyPath()) : !targetNestedPaths.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    protected Set<View> getViewsForConnectorEnd(ConnectorEnd end) {
        HashSet<View> views = new HashSet<View>();
        View hostView = ((IGraphicalEditPart)this.getHost()).getNotationView();
        View hostDiagram = hostView instanceof Diagram ? hostView : hostView.getDiagram();
        EReference[] refs = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
        Collection relatedViews = EMFCoreUtil.getReferencers((EObject)end.getRole(), (EReference[])refs);
        for (View currentView : relatedViews) {
            if (currentView.getDiagram() != hostDiagram) continue;
            boolean isInView = false;
            View containerView = currentView;
            while (containerView != null && !(containerView instanceof Diagram)) {
                if (containerView == this.getReferenceViewForConnectorEnd()) {
                    isInView = true;
                }
                containerView = ViewUtil.getContainerView((View)containerView);
            }
            if (!isInView) continue;
            EObject containerElement = ViewUtil.getContainerView((View)currentView).getElement();
            if (end.getPartWithPort() != null) {
                if (containerElement != end.getPartWithPort()) continue;
                views.add(currentView);
                continue;
            }
            if (end.getRole() instanceof Port) {
                Property property;
                if (containerElement instanceof EncapsulatedClassifier) {
                    views.add(currentView);
                    continue;
                }
                if (!(containerElement instanceof Property) || (property = (Property)containerElement).getType() != end.getRole().getOwner()) continue;
                views.add(currentView);
                continue;
            }
            views.add(currentView);
        }
        return views;
    }

    protected View getReferenceViewForConnectorEnd() {
        return ((IGraphicalEditPart)this.getHost()).getNotationView();
    }
}

