/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.diagram.common.utils.ConstraintBlockHelper;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CustomBindingConnectorCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;

    public CustomBindingConnectorCreateCommand(CreateRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = request.getSource();
        this.target = request.getTarget();
    }

    public boolean canExecute() {
        if (this.source == null) {
            return false;
        }
        if (this.target == null) {
            return true;
        }
        if (this.source == this.target) {
            return false;
        }
        if (this.source != null && this.target != null) {
            boolean hasEncapsulationViolation;
            boolean bl = hasEncapsulationViolation = !this.checkEncapsulationCrossing();
            return hasEncapsulationViolation ? false : ConstraintBlockHelper.isConstraintParameter((Element)((Element)this.source), (View)RequestParameterUtils.getSourceView((IEditCommandRequest)this.getRequest())) || ConstraintBlockHelper.isConstraintParameter((Element)((Element)this.target), (View)RequestParameterUtils.getTargetView((IEditCommandRequest)this.getRequest()));
        }
        return false;
    }

    private boolean checkEncapsulationCrossing() {
        Block stereotypeApplication;
        Type type;
        ConnectorUtils util = new ConnectorUtils();
        List nestedPropertyPath = util.getNestedPropertyPath(RequestParameterUtils.getSourceView((IEditCommandRequest)this.getRequest()), RequestParameterUtils.getTargetView((IEditCommandRequest)this.getRequest()));
        for (Property property : nestedPropertyPath) {
            type = property.getType();
            stereotypeApplication = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class);
            if (stereotypeApplication == null || !stereotypeApplication.isEncapsulated()) continue;
            return false;
        }
        nestedPropertyPath = util.getNestedPropertyPath(RequestParameterUtils.getTargetView((IEditCommandRequest)this.getRequest()), RequestParameterUtils.getSourceView((IEditCommandRequest)this.getRequest()));
        for (Property property : nestedPropertyPath) {
            type = property.getType();
            stereotypeApplication = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class);
            if (stereotypeApplication == null || !stereotypeApplication.isEncapsulated()) continue;
            return false;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        StructuredClassifier deducedContainer = new org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils().deduceContainer(RequestParameterUtils.getSourceView((IEditCommandRequest)this.getRequest()), RequestParameterUtils.getTargetView((IEditCommandRequest)this.getRequest()));
        ((CreateRelationshipRequest)this.getRequest()).setContainer((EObject)deducedContainer);
        IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((EObject)deducedContainer);
        ICommand editCommand = commandProvider.getEditCommand(this.getRequest());
        if (editCommand.canExecute()) {
            editCommand.execute(monitor, info);
            Object newObject = editCommand.getCommandResult().getReturnValue();
            if (newObject instanceof Connector) {
                Connector connector = (Connector)newObject;
                UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)connector, BlocksPackage.eINSTANCE.getBindingConnector());
            }
            return CommandResult.newOKCommandResult((Object)newObject);
        }
        return CommandResult.newErrorCommandResult((String)"Invalid arguments in create link command");
    }
}

