/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.architecture.internal.migration;

import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler_1_3_0;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.style.PapyrusViewStyle;

public class SysMLNeonToOxygenDiagramReconciler
extends DiagramReconciler_1_3_0 {
    private static final String BLOCK_DEFINITION_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.blockdefinition/resources/configuration/blockDefinitionDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String INTERNAL_BLOCK_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.internalblock/resources/configuration/internalBlockDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String PARAMETRIC_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.parametric/resources/configuration/parametricDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";
    private static final String REQUIREMENT_DIAGRAM_URI = "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.requirement/resources/configuration/requirementDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA";

    protected PapyrusDiagram getDiagramKind(Diagram diagram, PapyrusViewStyle oldStyle) {
        block16: {
            URI uri;
            PapyrusView configuration;
            if (oldStyle == null || (configuration = oldStyle.getConfiguration()) == null || (uri = EcoreUtil.getURI((EObject)configuration)) == null) break block16;
            switch (uri.toString()) {
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.requirement/resources/configuration/requirementDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.requirement");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.blockdefinition/resources/configuration/blockDefinitionDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.blockdefinition");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.internalblock/resources/configuration/internalBlockDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.internalblock");
                }
                case "platform:/plugin/org.eclipse.papyrus.sysml14.diagram.parametric/resources/configuration/parametricDiagram.configuration#_ZrBf4JaBEeS8eNvSwD0lgA": {
                    return this.getPapyrusDiagramById("org.eclipse.papyrus.sysml14.diagram.parametric");
                }
            }
        }
        return null;
    }

    protected PapyrusDiagram getPapyrusDiagramById(String id) {
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        Collection visibleArchitectureContexts = manager.getVisibleArchitectureContexts();
        for (MergedArchitectureContext mergedArchitectureContext : visibleArchitectureContexts) {
            if (!(mergedArchitectureContext instanceof MergedArchitectureDescriptionLanguage)) continue;
            MergedArchitectureDescriptionLanguage mergedArchitectureDescriptionLanguage = (MergedArchitectureDescriptionLanguage)mergedArchitectureContext;
            for (RepresentationKind representationKind : mergedArchitectureDescriptionLanguage.getRepresentationKinds()) {
                if (!(representationKind instanceof PapyrusDiagram) || !representationKind.getId().equals(id)) continue;
                return (PapyrusDiagram)representationKind;
            }
        }
        return null;
    }
}

