/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.software.artefact.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.papyrus.MARTE.MARTEPackage;

import org.eclipse.papyrus.MARTE_Library.BasicNFP_Types.BasicNFP_TypesPackage;

import org.eclipse.papyrus.MARTE_Library.GRM_BasicTypes.GRM_BasicTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_DataTypes.MARTE_DataTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MARTE_PrimitivesTypes.MARTE_PrimitivesTypesPackage;

import org.eclipse.papyrus.MARTE_Library.MeasurementUnits.MeasurementUnitsPackage;

import org.eclipse.papyrus.MARTE_Library.RS_Library.RS_LibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeLibrary.TimeLibraryPackage;

import org.eclipse.papyrus.MARTE_Library.TimeTypesLibrary.TimeTypesLibraryPackage;

import org.eclipse.papyrus.iotml.IoTMLPackage;

import org.eclipse.papyrus.iotml.animate.AnimatePackage;

import org.eclipse.papyrus.iotml.animate.impl.AnimatePackageImpl;

import org.eclipse.papyrus.iotml.hardware.HardwarePackage;

import org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage;

import org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl;

import org.eclipse.papyrus.iotml.hardware.core.CorePackage;

import org.eclipse.papyrus.iotml.hardware.core.impl.CorePackageImpl;

import org.eclipse.papyrus.iotml.hardware.impl.HardwarePackageImpl;

import org.eclipse.papyrus.iotml.hardware.network.NetworkPackage;

import org.eclipse.papyrus.iotml.hardware.network.impl.NetworkPackageImpl;

import org.eclipse.papyrus.iotml.hardware.sensor.SensorPackage;

import org.eclipse.papyrus.iotml.hardware.sensor.impl.SensorPackageImpl;

import org.eclipse.papyrus.iotml.hybrid.HybridPackage;

import org.eclipse.papyrus.iotml.hybrid.impl.HybridPackageImpl;

import org.eclipse.papyrus.iotml.impl.IoTMLPackageImpl;

import org.eclipse.papyrus.iotml.software.SoftwarePackage;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactFactory;
import org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage;
import org.eclipse.papyrus.iotml.software.artefact.DigitalArtefact;
import org.eclipse.papyrus.iotml.software.artefact.PropertyAccess;
import org.eclipse.papyrus.iotml.software.artefact.ProvideResource;
import org.eclipse.papyrus.iotml.software.artefact.ProvideService;
import org.eclipse.papyrus.iotml.software.artefact.Service;
import org.eclipse.papyrus.iotml.software.artefact.ServiceDescription;
import org.eclipse.papyrus.iotml.software.artefact.VirtualEntity;

import org.eclipse.papyrus.iotml.software.artefact.util.ArtefactValidator;

import org.eclipse.papyrus.iotml.software.core.structure.StructurePackage;

import org.eclipse.papyrus.iotml.software.core.structure.impl.StructurePackageImpl;

import org.eclipse.papyrus.iotml.software.impl.SoftwarePackageImpl;
import org.eclipse.papyrus.iotml.software.resource.ResourcePackage;

import org.eclipse.papyrus.iotml.software.resource.impl.ResourcePackageImpl;

import org.eclipse.papyrus.sysml14.sysmlPackage;

import org.eclipse.uml2.types.TypesPackage;

import org.eclipse.uml2.uml.UMLPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ArtefactPackageImpl extends EPackageImpl implements ArtefactPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass propertyAccessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass digitalArtefactEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass virtualEntityEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass provideServiceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass provideResourceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceDescriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass serviceEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.papyrus.iotml.software.artefact.ArtefactPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ArtefactPackageImpl() {
		super(eNS_URI, ArtefactFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link ArtefactPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ArtefactPackage init() {
		if (isInited) return (ArtefactPackage)EPackage.Registry.INSTANCE.getEPackage(ArtefactPackage.eNS_URI);

		// Obtain or create and register package
		ArtefactPackageImpl theArtefactPackage = (ArtefactPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof ArtefactPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ArtefactPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		MARTEPackage.eINSTANCE.eClass();
		MARTE_PrimitivesTypesPackage.eINSTANCE.eClass();
		MeasurementUnitsPackage.eINSTANCE.eClass();
		GRM_BasicTypesPackage.eINSTANCE.eClass();
		BasicNFP_TypesPackage.eINSTANCE.eClass();
		MARTE_DataTypesPackage.eINSTANCE.eClass();
		TimeTypesLibraryPackage.eINSTANCE.eClass();
		TimeLibraryPackage.eINSTANCE.eClass();
		RS_LibraryPackage.eINSTANCE.eClass();
		sysmlPackage.eINSTANCE.eClass();
		TypesPackage.eINSTANCE.eClass();
		UMLPackage.eINSTANCE.eClass();

		// Obtain or create and register interdependencies
		IoTMLPackageImpl theIoTMLPackage = (IoTMLPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) instanceof IoTMLPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(IoTMLPackage.eNS_URI) : IoTMLPackage.eINSTANCE);
		AnimatePackageImpl theAnimatePackage = (AnimatePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) instanceof AnimatePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AnimatePackage.eNS_URI) : AnimatePackage.eINSTANCE);
		HardwarePackageImpl theHardwarePackage = (HardwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) instanceof HardwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HardwarePackage.eNS_URI) : HardwarePackage.eINSTANCE);
		ActuatorPackageImpl theActuatorPackage = (ActuatorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) instanceof ActuatorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ActuatorPackage.eNS_URI) : ActuatorPackage.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) : SensorPackage.eINSTANCE);
		NetworkPackageImpl theNetworkPackage = (NetworkPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) instanceof NetworkPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(NetworkPackage.eNS_URI) : NetworkPackage.eINSTANCE);
		CorePackageImpl theCorePackage = (CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) instanceof CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(CorePackage.eNS_URI) : CorePackage.eINSTANCE);
		HybridPackageImpl theHybridPackage = (HybridPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) instanceof HybridPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI) : HybridPackage.eINSTANCE);
		SoftwarePackageImpl theSoftwarePackage = (SoftwarePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) instanceof SoftwarePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SoftwarePackage.eNS_URI) : SoftwarePackage.eINSTANCE);
		org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl theCorePackage_1 = (org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) instanceof org.eclipse.papyrus.iotml.software.core.impl.CorePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(org.eclipse.papyrus.iotml.software.core.CorePackage.eNS_URI) : org.eclipse.papyrus.iotml.software.core.CorePackage.eINSTANCE);
		StructurePackageImpl theStructurePackage = (StructurePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) instanceof StructurePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(StructurePackage.eNS_URI) : StructurePackage.eINSTANCE);
		ResourcePackageImpl theResourcePackage = (ResourcePackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) instanceof ResourcePackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ResourcePackage.eNS_URI) : ResourcePackage.eINSTANCE);

		// Create package meta-data objects
		theArtefactPackage.createPackageContents();
		theIoTMLPackage.createPackageContents();
		theAnimatePackage.createPackageContents();
		theHardwarePackage.createPackageContents();
		theActuatorPackage.createPackageContents();
		theSensorPackage.createPackageContents();
		theNetworkPackage.createPackageContents();
		theCorePackage.createPackageContents();
		theHybridPackage.createPackageContents();
		theSoftwarePackage.createPackageContents();
		theCorePackage_1.createPackageContents();
		theStructurePackage.createPackageContents();
		theResourcePackage.createPackageContents();

		// Initialize created meta-data
		theArtefactPackage.initializePackageContents();
		theIoTMLPackage.initializePackageContents();
		theAnimatePackage.initializePackageContents();
		theHardwarePackage.initializePackageContents();
		theActuatorPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();
		theNetworkPackage.initializePackageContents();
		theCorePackage.initializePackageContents();
		theHybridPackage.initializePackageContents();
		theSoftwarePackage.initializePackageContents();
		theCorePackage_1.initializePackageContents();
		theStructurePackage.initializePackageContents();
		theResourcePackage.initializePackageContents();

		// Register package validator
		EValidator.Registry.INSTANCE.put
			(theArtefactPackage, 
			 new EValidator.Descriptor() {
				 public EValidator getEValidator() {
					 return ArtefactValidator.INSTANCE;
				 }
			 });

		// Mark meta-data to indicate it can't be changed
		theArtefactPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ArtefactPackage.eNS_URI, theArtefactPackage);
		return theArtefactPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPropertyAccess() {
		return propertyAccessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPropertyAccess_Base_Association() {
		return (EReference)propertyAccessEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPropertyAccess_AccessedProperty() {
		return (EReference)propertyAccessEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDigitalArtefact() {
		return digitalArtefactEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDigitalArtefact_Base_Class() {
		return (EReference)digitalArtefactEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getVirtualEntity() {
		return virtualEntityEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVirtualEntity_PhisicalEntitySpecification() {
		return (EReference)virtualEntityEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getVirtualEntity_PhysicalEntity() {
		return (EReference)virtualEntityEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProvideService() {
		return provideServiceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProvideService_Base_Association() {
		return (EReference)provideServiceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProvideResource() {
		return provideResourceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProvideResource_Base_Association() {
		return (EReference)provideResourceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getServiceDescription() {
		return serviceDescriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceDescription_Base_Interface() {
		return (EReference)serviceDescriptionEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getServiceDescription_ResourceGetSet() {
		return (EReference)serviceDescriptionEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getService() {
		return serviceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ArtefactFactory getArtefactFactory() {
		return (ArtefactFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		propertyAccessEClass = createEClass(PROPERTY_ACCESS);
		createEReference(propertyAccessEClass, PROPERTY_ACCESS__BASE_ASSOCIATION);
		createEReference(propertyAccessEClass, PROPERTY_ACCESS__ACCESSED_PROPERTY);

		digitalArtefactEClass = createEClass(DIGITAL_ARTEFACT);
		createEReference(digitalArtefactEClass, DIGITAL_ARTEFACT__BASE_CLASS);

		virtualEntityEClass = createEClass(VIRTUAL_ENTITY);
		createEReference(virtualEntityEClass, VIRTUAL_ENTITY__PHISICAL_ENTITY_SPECIFICATION);
		createEReference(virtualEntityEClass, VIRTUAL_ENTITY__PHYSICAL_ENTITY);

		provideServiceEClass = createEClass(PROVIDE_SERVICE);
		createEReference(provideServiceEClass, PROVIDE_SERVICE__BASE_ASSOCIATION);

		provideResourceEClass = createEClass(PROVIDE_RESOURCE);
		createEReference(provideResourceEClass, PROVIDE_RESOURCE__BASE_ASSOCIATION);

		serviceDescriptionEClass = createEClass(SERVICE_DESCRIPTION);
		createEReference(serviceDescriptionEClass, SERVICE_DESCRIPTION__BASE_INTERFACE);
		createEReference(serviceDescriptionEClass, SERVICE_DESCRIPTION__RESOURCE_GET_SET);

		serviceEClass = createEClass(SERVICE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		UMLPackage theUMLPackage = (UMLPackage)EPackage.Registry.INSTANCE.getEPackage(UMLPackage.eNS_URI);
		HybridPackage theHybridPackage = (HybridPackage)EPackage.Registry.INSTANCE.getEPackage(HybridPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		virtualEntityEClass.getESuperTypes().add(this.getDigitalArtefact());
		serviceEClass.getESuperTypes().add(this.getDigitalArtefact());

		// Initialize classes and features; add operations and parameters
		initEClass(propertyAccessEClass, PropertyAccess.class, "PropertyAccess", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getPropertyAccess_Base_Association(), theUMLPackage.getAssociation(), null, "base_Association", null, 1, 1, PropertyAccess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getPropertyAccess_AccessedProperty(), theUMLPackage.getProperty(), null, "accessedProperty", null, 0, 1, PropertyAccess.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		EOperation op = addEOperation(propertyAccessEClass, ecorePackage.getEBoolean(), "PropertyAccess_C1", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		EGenericType g1 = createEGenericType(ecorePackage.getEMap());
		EGenericType g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(propertyAccessEClass, ecorePackage.getEBoolean(), "PropertyAccess_C2", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(propertyAccessEClass, ecorePackage.getEBoolean(), "propertyAccess_C3", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(digitalArtefactEClass, DigitalArtefact.class, "DigitalArtefact", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getDigitalArtefact_Base_Class(), theUMLPackage.getClass_(), null, "base_Class", null, 1, 1, DigitalArtefact.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(virtualEntityEClass, VirtualEntity.class, "VirtualEntity", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getVirtualEntity_PhisicalEntitySpecification(), theUMLPackage.getInstanceSpecification(), null, "phisicalEntitySpecification", null, 0, 1, VirtualEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getVirtualEntity_PhysicalEntity(), theHybridPackage.getPhysicalEntity(), null, "physicalEntity", null, 0, 1, VirtualEntity.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(provideServiceEClass, ProvideService.class, "ProvideService", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProvideService_Base_Association(), theUMLPackage.getAssociation(), null, "base_Association", null, 1, 1, ProvideService.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		op = addEOperation(provideServiceEClass, ecorePackage.getEBoolean(), "ProvideService_C2", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(provideServiceEClass, ecorePackage.getEBoolean(), "ProvideService_C1", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(provideResourceEClass, ProvideResource.class, "ProvideResource", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getProvideResource_Base_Association(), theUMLPackage.getAssociation(), null, "base_Association", null, 1, 1, ProvideResource.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		op = addEOperation(provideResourceEClass, ecorePackage.getEBoolean(), "ProvideResource_C1", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = addEOperation(provideResourceEClass, ecorePackage.getEBoolean(), "ProvideResource_C2", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(serviceDescriptionEClass, ServiceDescription.class, "ServiceDescription", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getServiceDescription_Base_Interface(), theUMLPackage.getInterface(), null, "base_Interface", null, 1, 1, ServiceDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);
		initEReference(getServiceDescription_ResourceGetSet(), theUMLPackage.getOperation(), null, "resourceGetSet", null, 0, -1, ServiceDescription.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, !IS_ORDERED);

		initEClass(serviceEClass, Service.class, "Service", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		op = addEOperation(serviceEClass, ecorePackage.getEBoolean(), "Service_C1", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEDiagnosticChain(), "diagnostics", 0, 1, IS_UNIQUE, IS_ORDERED);
		g1 = createEGenericType(ecorePackage.getEMap());
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		addEParameter(op, g1, "context", 0, 1, IS_UNIQUE, IS_ORDERED);

		// Create annotations
		// http://www.eclipse.org/uml2/2.0.0/UML
		createUMLAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/uml2/2.0.0/UML</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createUMLAnnotations() {
		String source = "http://www.eclipse.org/uml2/2.0.0/UML";	
		addAnnotation
		  (this, 
		   source, 
		   new String[] {
			 "originalName", "Artefact"
		   });
	}

} //ArtefactPackageImpl
