/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.editors;

import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.aas.Asset;
import org.eclipse.papyrus.aas.ConceptDescription;
import org.eclipse.papyrus.aas.IdentifierType;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.KeyElements;
import org.eclipse.papyrus.aas.KeyType;
import org.eclipse.papyrus.aas.tables.configurations.editors.AASElementTypesEnumerator;
import org.eclipse.papyrus.aas.tables.configurations.editors.KeyTypeContentProvider;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.celleditor.action.AbstractOpenDialogCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectTreeItemAxis;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.uml.tools.providers.UMLFilteredLabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SelectKeyTypeCellEditorButtonAction
extends AbstractOpenDialogCellEditorButtonAction {
    private List<IElementType> elementsForCreation;
    private IElementType selectedElementType = null;
    private SelectPropertyDialogCellEditor editor;
    private EObject creationContext;

    public SelectKeyTypeCellEditorButtonAction(List<IElementType> creatableElementType, boolean b, EObject context) {
        this.setImage(Activator.getDefault().getImage("/icons/browse_12x12.gif"));
        this.setText("");
        this.setTooltipText("Select an existing Semantic id");
        this.elementsForCreation = creatableElementType;
        this.creationContext = context;
    }

    public static ConceptDescription getConceptDescritpion(Element element) {
        ConceptDescription conceptDescription = null;
        if (element != null) {
            conceptDescription = (ConceptDescription)UMLUtil.getStereotypeApplication((Element)element, ConceptDescription.class);
        }
        return conceptDescription;
    }

    public static Asset getAsset(Element element) {
        Asset conceptDescription = null;
        if (element != null) {
            conceptDescription = (Asset)UMLUtil.getStereotypeApplication((Element)element, Asset.class);
        }
        return conceptDescription;
    }

    public static Key getStereotypeApplication(Element element) {
        Key key = null;
        if (element != null) {
            key = (Key)UMLUtil.getStereotypeApplication((Element)element, Key.class);
        }
        return key;
    }

    public AbstractDialogCellEditor createDialogCellEditor() {
        this.editor = new SelectPropertyDialogCellEditor(this.elementsForCreation, this.creationContext);
        return this.editor;
    }

    public int runAction(final SelectionEvent e) {
        this.openMenuForCreation(this.parent);
        if (this.selectedElementType != null) {
            INattableModelManager modelManager = (INattableModelManager)this.configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            ILayerCell cell = this.cell;
            cell.getColumnIndex();
            cell.getRowIndex();
            final Object key = modelManager.getRowElement(this.getRowIndex());
            this.creationContext = modelManager.getTable().getContext();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)this.creationContext);
            if (provider != null) {
                AbstractTransactionalCommand abs = new AbstractTransactionalCommand(editingDomain, "Select an existing element", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                        Object previousCanonicalValue = SelectKeyTypeCellEditorButtonAction.this.originalCanonicalValue;
                        int resIntermediare = SelectKeyTypeCellEditorButtonAction.super.runAction(e);
                        Object value = SelectKeyTypeCellEditorButtonAction.this.editor.editedElement;
                        SelectKeyTypeCellEditorButtonAction.this.originalCanonicalValue = value;
                        if (resIntermediare == 0) {
                            EObject element;
                            if (key instanceof EObjectTreeItemAxis && (element = ((EObjectTreeItemAxis)key).getElement()) instanceof Element) {
                                Key key2 = SelectKeyTypeCellEditorButtonAction.getStereotypeApplication((Element)element);
                                ConceptDescription cd = null;
                                Object asset = null;
                                if (value instanceof Element && SelectKeyTypeCellEditorButtonAction.getConceptDescritpion((Element)value) != null && (cd = SelectKeyTypeCellEditorButtonAction.getConceptDescritpion((Element)value)) != null && cd.getIdentification() != null) {
                                    key2.setType(KeyElements.CONCEPT_DESCRIPTION);
                                    key2.setIdType(SelectKeyTypeCellEditorButtonAction.this.getKeyType(cd.getIdentification().getIdType()));
                                    key2.setValue(cd.getIdentification().getId());
                                }
                            }
                            return CommandResult.newOKCommandResult((Object)value);
                        }
                        this.setResult(CommandResult.newCancelledCommandResult());
                        SelectKeyTypeCellEditorButtonAction.this.originalCanonicalValue = previousCanonicalValue;
                        return this.getCommandResult();
                    }
                };
                this.getEditingDomain().getCommandStack().execute(GMFtoEMFCommandWrapper.wrap((ICommand)abs));
                CommandResult res = abs.getCommandResult();
                if (res.getStatus().isOK()) {
                    this.selectedElementType = null;
                    return 0;
                }
            }
        }
        this.selectedElementType = null;
        return 1;
    }

    private KeyType getKeyType(IdentifierType idType) {
        switch (idType.getValue()) {
            case 0: {
                return KeyType.CUSTOM;
            }
            case 2: {
                return KeyType.IRI;
            }
            case 1: {
                return KeyType.IRDI;
            }
        }
        return KeyType.CUSTOM;
    }

    private void setSelectedElementType(IElementType elementType) {
        this.selectedElementType = elementType;
    }

    private void openMenuForCreation(Composite parent) {
        if (this.elementsForCreation.size() == 0) {
            return;
        }
        if (this.elementsForCreation.size() == 1) {
            this.selectedElementType = this.elementsForCreation.get(0);
            return;
        }
        Menu menu = new Menu((Control)parent);
        String ELEMENT_TYPE = "elementTypeId";
        for (IElementType current : this.elementsForCreation) {
            final MenuItem item = new MenuItem(menu, 0);
            item.setText(current.getDisplayName());
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)current.getIconURL());
            item.setImage(Activator.getDefault().getImage(imgDesc));
            item.setData("elementTypeId", (Object)current);
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SelectKeyTypeCellEditorButtonAction.this.setSelectedElementType((IElementType)item.getData("elementTypeId"));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        menu.setVisible(true);
        Display display = Display.getDefault();
        while (menu.isVisible()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    public class SelectPropertyDialogCellEditor
    extends AbstractDialogCellEditor {
        private Object editedElement;
        private boolean isClosed = false;
        private List<IElementType> elementsForCreation;
        private EObject creationcontext;

        public SelectPropertyDialogCellEditor(List<IElementType> elementsForCreation, EObject creationContext) {
            this.elementsForCreation = elementsForCreation;
            this.creationcontext = creationContext;
        }

        protected Object createDialog() {
            KeyTypeContentProvider contentProvider = null;
            String title = "";
            if (SelectKeyTypeCellEditorButtonAction.this.selectedElementType.equals(AASElementTypesEnumerator.CONCEPTDESCRIPTION)) {
                contentProvider = new KeyTypeContentProvider();
                title = "Select a ConceptDescription";
            }
            ResourceSet resSet = EMFHelper.getResourceSet((EObject)this.creationcontext);
            TreeSelectorDialog dialog = new TreeSelectorDialog(Display.getCurrent().getActiveShell());
            dialog.setInput((Object)resSet);
            if (this.elementsForCreation.size() > 0) {
                dialog.setContentProvider((ITreeContentProvider)contentProvider);
                dialog.setLabelProvider((ILabelProvider)new UMLFilteredLabelProvider());
                dialog.setTitle(title);
            }
            this.dialog = dialog;
            return dialog;
        }

        public int open() {
            Object oneSelected;
            TreeSelectorDialog mydialog;
            Object[] selected = null;
            if (((TreeSelectorDialog)this.dialog).open() == 0 && (selected = (mydialog = (TreeSelectorDialog)this.dialog).getResult()) != null && selected.length > 0 && (oneSelected = selected[0]) instanceof Classifier) {
                Classifier result = (Classifier)oneSelected;
                this.editedElement = result;
            }
            this.isClosed = true;
            if (selected != null) {
                return 0;
            }
            return 1;
        }

        public Object createDialogInstance() {
            this.dialog = this.createDialog();
            return this.dialog;
        }

        public Object getDialogInstance() {
            return this.dialog;
        }

        public Object getEditorValue() {
            return this.editedElement;
        }

        public void setEditorValue(Object value) {
        }

        public void close() {
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

