/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.handlers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;

public class CreateElementHandlerTester
extends PropertyTester {
    private static final String IS_Bom_Table = "IsBOMTable";
    private static final String IS_Operation_Table = "IsOperationTable";
    private static final String IS_Property_Table = "IsPropertyTable";
    private static final String BOM_TABLE_TYPE = "BOMTableType";
    private static final String PROPERTY_TABLE_TYPE = "PropertiesTableType";
    private static final String OPERATION_TABLE_TYPE = "OperationsTableType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String type;
        if (receiver instanceof TableStructuredSelection && expectedValue instanceof Boolean && (type = this.getTableType((TableStructuredSelection)receiver)) != null) {
            if (IS_Bom_Table.equals(property)) {
                boolean value = expectedValue.equals(BOM_TABLE_TYPE.equals(type));
                if (value) {
                    int i = 0;
                    ++i;
                }
                return expectedValue.equals(BOM_TABLE_TYPE.equals(type));
            }
            if (IS_Operation_Table.equals(property)) {
                return expectedValue.equals(OPERATION_TABLE_TYPE.equals(type));
            }
            if (IS_Property_Table.equals(property)) {
                return expectedValue.equals(PROPERTY_TABLE_TYPE.equals(type));
            }
        }
        return false;
    }

    private String getTableType(TableStructuredSelection selection) {
        TableSelectionWrapper wrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class);
        INattableModelManager manager = wrapper.getNatTableModelManager();
        if (manager != null && manager.getTable() != null) {
            return manager.getTable().getTableConfiguration().getType();
        }
        return null;
    }
}

