/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.tableProvider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.aas.Key;
import org.eclipse.papyrus.aas.Reference;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.provider.GenericCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class SemanticIdLabelProvider
extends GenericCellLabelProvider {
    private static final String SEMENTICID = "semanticId";

    public boolean accept(Object element) {
        if (element instanceof LabelProviderCellContextElementWrapper) {
            LabelProviderCellContextElementWrapper wrapper = (LabelProviderCellContextElementWrapper)element;
            int i1 = wrapper.getColumnIndex();
            INattableModelManager manager = (INattableModelManager)wrapper.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            Object axis = manager.getColumnElement(i1);
            String propID = AxisUtils.getPropertyId((Object)axis);
            String tableType = manager.getTable().getTableConfiguration().getType();
            ArrayList<String> confTable = new ArrayList<String>();
            confTable.add("PropertiesTableType");
            confTable.add("BOMTableType");
            confTable.add("OperationsTableType");
            for (String currentType : confTable) {
                if (propID == null || !propID.endsWith(SEMENTICID) || !tableType.equals(currentType)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getText(LabelProviderService service, Object value) {
        if (value instanceof Collection) {
            return super.getText(service, value);
        }
        StringBuilder builder = new StringBuilder();
        if (value instanceof Reference) {
            EList keyList = ((Reference)value).getKey();
            Iterator iter = keyList.iterator();
            builder.append(((Key)iter.next()).getValue());
        }
        return builder.toString();
    }
}

