/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EObjectObservableValue;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.ui.emf.databinding.EMFObservableValue;

public class AASEObjectStructuredObservableValue
extends EMFObservableValue {
    protected List<EObjectObservableValue> observables = new ArrayList<EObjectObservableValue>();
    protected AASEObjectStructuredObservableValue parent;
    private Function<? super ICommand, ? extends Command> commandWrapper;

    public AASEObjectStructuredObservableValue(EObject eObject, EStructuralFeature eStructuralFeature, EditingDomain domain, boolean browseFeatures, AASEObjectStructuredObservableValue parent) {
        super(eObject, eStructuralFeature, domain);
        this.parent = parent;
        if (eObject != null && browseFeatures) {
            this.browseFeatures(eObject);
        }
        this.commandWrapper = GMFtoEMFCommandWrapper::wrap;
    }

    public List<EObjectObservableValue> getObservables() {
        return this.observables;
    }

    public AASEObjectStructuredObservableValue getParent() {
        return this.parent;
    }

    private void browseFeatures(EObject eObject) {
        EList eStructuralFeatures = eObject.eClass().getEStructuralFeatures();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
        for (EStructuralFeature eStructuralFeature : eStructuralFeatures) {
            Object eGet = eObject.eGet(eStructuralFeature);
            AASEObjectStructuredObservableValue eObjectObservableValue = eStructuralFeature instanceof EReference && eGet instanceof EObject ? new AASEObjectStructuredObservableValue((EObject)eGet, eStructuralFeature, (EditingDomain)editingDomain, true, this) : new AASEObjectStructuredObservableValue(eObject, eStructuralFeature, (EditingDomain)editingDomain, false, this);
            this.observables.add((EObjectObservableValue)eObjectObservableValue);
        }
    }

    public Command getSetCommand(Object value) {
        EObject eObjectValue = EMFHelper.getEObject((Object)value);
        if (eObjectValue != null) {
            value = eObjectValue;
        }
        try {
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((EObject)((EObject)this.getObserved()));
            if (provider != null) {
                IEditCommandRequest createSetRequest;
                CompositeCommand cc = new CompositeCommand("Edit value");
                if (value instanceof EEnumLiteral) {
                    value = ((EEnumLiteral)value).getInstance();
                }
                if ((createSetRequest = this.createSetRequest((TransactionalEditingDomain)this.domain, this.eObject, this.eStructuralFeature, value)) == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                ICommand command = provider.getEditCommand(createSetRequest);
                if (command.canExecute()) {
                    cc.add((IUndoableOperation)provider.getEditCommand(createSetRequest));
                }
                return this.commandWrapper.apply((ICommand)cc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected IEditCommandRequest createSetRequest(TransactionalEditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        return new SetRequest(domain, owner, feature, value);
    }

    public Object getValueType() {
        Object valueType = super.getValueType();
        if (valueType == null && this.eObject != null) {
            valueType = this.eObject.eClass();
        }
        return valueType;
    }

    public synchronized void dispose() {
        for (EObjectObservableValue eObjectObservableValue : this.observables) {
            eObjectObservableValue.dispose();
        }
        super.dispose();
    }
}

