/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.transformation;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceManipulation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.ui.compare.JavaStructureCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.papyrus.designer.languages.java.codegen.Activator;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaMerger {
    private static final String S_PL = "\\s+";
    private static final String RN_RN = "\\r\\n|\\r|\\n";
    private static final String EMPTY = "";
    private IJavaProject javaProject;
    private String sourceSrcFolder;
    private String targetSrcFolder;
    private IFile rightFile;
    private CompilationUnit rightAstRoot;
    private boolean astNeedsRefresh = false;

    public JavaMerger(IProject project, String sourceSrcFolder, String targetSrcFolder) {
        if (project != null) {
            this.javaProject = JavaCore.create((IProject)project);
        }
        this.sourceSrcFolder = sourceSrcFolder;
        this.targetSrcFolder = targetSrcFolder;
    }

    public void merge() {
        IFolder srcFolder;
        IFolder targetFolder;
        if (this.javaProject != null && this.sourceSrcFolder != null && this.targetSrcFolder != null && !this.sourceSrcFolder.equals(this.targetSrcFolder) && (targetFolder = this.javaProject.getProject().getFolder(this.targetSrcFolder)).exists() && (srcFolder = this.javaProject.getProject().getFolder(this.sourceSrcFolder)).exists()) {
            try {
                Differencer d = new Differencer();
                ResourceNode left = new ResourceNode((IResource)srcFolder);
                ResourceNode right = new ResourceNode((IResource)targetFolder);
                DiffNode diffs = (DiffNode)d.findDifferences(false, null, null, null, (Object)left, (Object)right);
                this.handleDifferences(diffs);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            try {
                srcFolder.delete(true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    protected void handleDifferences(DiffNode diffNode) {
        block100: {
            block101: {
                block104: {
                    block102: {
                        String leftId;
                        DiffNode parentDiffNode;
                        block103: {
                            ResourceNode rightParentResourceNode;
                            DiffNode parentDiffNode2;
                            if (diffNode == null) break block100;
                            if (diffNode.getChildren() != null && diffNode.getChildren().length != 0) break block101;
                            if (diffNode.getLeft() == null || diffNode.getRight() != null) break block102;
                            if (!(diffNode.getLeft() instanceof ResourceNode)) break block103;
                            ResourceNode leftResourceNode = (ResourceNode)diffNode.getLeft();
                            if ((leftResourceNode.getResource() instanceof IContainer || leftResourceNode.getResource() instanceof IFile) && diffNode.getParent() instanceof DiffNode && (parentDiffNode2 = (DiffNode)diffNode.getParent()).getRight() instanceof ResourceNode && (rightParentResourceNode = (ResourceNode)parentDiffNode2.getRight()).getResource() instanceof IContainer) {
                                IContainer rightParentContainer = (IContainer)rightParentResourceNode.getResource();
                                try {
                                    leftResourceNode.getResource().copy((IPath)new Path(String.valueOf(rightParentContainer.getFullPath().toString()) + "/" + leftResourceNode.getName()), true, null);
                                }
                                catch (CoreException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                            break block100;
                        }
                        if (!(diffNode.getLeft() instanceof DocumentRangeNode) || (parentDiffNode = (DiffNode)diffNode.getParent()) == null) break block100;
                        DocumentRangeNode leftDocRangeNode = (DocumentRangeNode)diffNode.getLeft();
                        String leftContent = null;
                        try {
                            leftContent = leftDocRangeNode.getDocument().get(leftDocRangeNode.getRange().offset, leftDocRangeNode.getRange().length);
                        }
                        catch (BadLocationException e) {
                            Activator.log.error((Throwable)e);
                        }
                        IJavaElement rightType = this.getRightType(parentDiffNode);
                        if (leftContent == null || rightType == null || (leftId = leftDocRangeNode.getId()) == null) break block100;
                        ICompilationUnit cu = null;
                        if (leftId.startsWith("^")) {
                            if (rightType instanceof IType) {
                                try {
                                    if (!((IType)rightType).isEnum()) {
                                        ((IType)rightType).createField(leftContent, null, true, null);
                                        IField[] fields = ((IType)rightType).getFields();
                                        if (fields != null && fields.length > 0) {
                                            IField createdField = fields[fields.length - 1];
                                            IField[] iFieldArray = fields;
                                            int n = fields.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IField field = iFieldArray[n2];
                                                if (field.getElementName().equals(createdField.getElementName()) && !field.getTypeSignature().equals(createdField.getTypeSignature())) {
                                                    field.delete(true, null);
                                                }
                                                ++n2;
                                            }
                                        }
                                        cu = ((IType)rightType).getCompilationUnit();
                                    }
                                }
                                catch (JavaModelException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        } else if (leftId.startsWith("~")) {
                            if (rightType instanceof IType) {
                                try {
                                    ((IType)rightType).createMethod(leftContent, null, true, null);
                                    cu = ((IType)rightType).getCompilationUnit();
                                }
                                catch (JavaModelException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        } else if (leftId.startsWith("<")) {
                            if (rightType instanceof ICompilationUnit) {
                                this.createImports((ICompilationUnit)rightType, leftContent);
                                cu = (ICompilationUnit)rightType;
                            }
                        } else if (leftId.startsWith("#")) {
                            if (rightType instanceof ICompilationUnit) {
                                this.createImports((ICompilationUnit)rightType, leftContent);
                                cu = (ICompilationUnit)rightType;
                            }
                        } else if (leftId.startsWith("%")) {
                            if (rightType instanceof ICompilationUnit) {
                                this.createPackageDeclaration((ICompilationUnit)rightType, leftContent);
                                cu = (ICompilationUnit)rightType;
                            }
                        } else if (leftId.startsWith("[")) {
                            if (rightType instanceof IType) {
                                try {
                                    ((IType)rightType).createType(leftContent, null, true, null);
                                    cu = ((IType)rightType).getCompilationUnit();
                                }
                                catch (JavaModelException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            } else if (rightType instanceof ICompilationUnit) {
                                try {
                                    ((ICompilationUnit)rightType).createType(leftContent, null, true, null);
                                    cu = (ICompilationUnit)rightType;
                                }
                                catch (JavaModelException e) {
                                    Activator.log.error((Throwable)e);
                                }
                            }
                        }
                        if (cu == null) break block100;
                        try {
                            cu.save(null, true);
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                        break block100;
                    }
                    if (!(diffNode.getLeft() instanceof ResourceNode) || !(diffNode.getRight() instanceof ResourceNode)) break block104;
                    ResourceNode leftResourceNode = (ResourceNode)diffNode.getLeft();
                    ResourceNode rightResourceNode = (ResourceNode)diffNode.getRight();
                    if (leftResourceNode.getResource() instanceof IFile && rightResourceNode.getResource() instanceof IFile) {
                        JavaStructureCreator rightJavaStructureCreator;
                        IStructureComparator rightRootJavaNode;
                        this.rightFile = (IFile)rightResourceNode.getResource();
                        this.rightAstRoot = null;
                        Differencer d = new Differencer();
                        JavaStructureCreator leftJavaStructureCreator = new JavaStructureCreator();
                        IStructureComparator leftRootJavaNode = leftJavaStructureCreator.getStructure((Object)leftResourceNode);
                        DiffNode diffs = (DiffNode)d.findDifferences(false, null, null, null, (Object)leftRootJavaNode, (Object)(rightRootJavaNode = (rightJavaStructureCreator = new JavaStructureCreator()).getStructure((Object)rightResourceNode)));
                        if (diffs != null && diffs.getRight() instanceof DocumentRangeNode) {
                            DocumentRangeNode rightNode = (DocumentRangeNode)diffs.getRight();
                            IDocument rightDocument = rightNode.getDocument();
                            rightDocument.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("DocumentRangeCategory"));
                            rightDocument.addPositionCategory("DocumentRangeCategory");
                        }
                        this.handleDifferences(diffs);
                        this.rightFile = null;
                        this.rightAstRoot = null;
                    }
                    break block100;
                }
                if (!(diffNode.getLeft() instanceof DocumentRangeNode) || !(diffNode.getRight() instanceof DocumentRangeNode)) break block100;
                DocumentRangeNode leftDocRangeNode = (DocumentRangeNode)diffNode.getLeft();
                String leftContent = null;
                try {
                    leftContent = leftDocRangeNode.getDocument().get(leftDocRangeNode.getRange().offset, leftDocRangeNode.getRange().length);
                }
                catch (BadLocationException e) {
                    Activator.log.error((Throwable)e);
                }
                IJavaElement rightType = this.getRightType(diffNode);
                IJavaElement rightElement = this.getRightElement(diffNode);
                if (leftContent == null) break block100;
                String leftId = leftDocRangeNode.getId();
                ICompilationUnit cu = null;
                if (leftId == null) break block100;
                if (leftId.startsWith("^")) {
                    if (rightType instanceof IType && rightElement instanceof IField) {
                        try {
                            if (!((IType)rightType).isEnum()) {
                                this.astNeedsRefresh = true;
                                CompilationUnit astRoot = this.getRightAstRoot();
                                ASTNode rightElementNode = this.getAstNode(rightElement, astRoot);
                                Javadoc rightJavadoc = null;
                                Expression rightInitializer = null;
                                if (rightElementNode instanceof FieldDeclaration) {
                                    FieldDeclaration rightFieldDeclaration = (FieldDeclaration)rightElementNode;
                                    rightJavadoc = rightFieldDeclaration.getJavadoc();
                                    List fragments = rightFieldDeclaration.fragments();
                                    if (!fragments.isEmpty()) {
                                        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
                                        rightInitializer = fragment.getInitializer();
                                    }
                                }
                                IField createdField = ((IType)rightType).createField(leftContent, (IJavaElement)this.getNextMember((IMember)((IField)rightElement)), true, null);
                                ((IField)rightElement).delete(true, null);
                                cu = ((IField)rightElement).getCompilationUnit();
                                cu.save(null, true);
                                boolean needSave = false;
                                this.astNeedsRefresh = true;
                                CompilationUnit astRootUpdate = this.getRightAstRoot();
                                ASTNode createdFieldNode = this.getAstNode((IJavaElement)createdField, astRootUpdate);
                                if (createdFieldNode instanceof FieldDeclaration) {
                                    ASTNode copyOfRightInitializer;
                                    VariableDeclarationFragment fragment;
                                    Expression leftInitializer;
                                    List fragments;
                                    if (rightInitializer != null && !(fragments = ((FieldDeclaration)createdFieldNode).fragments()).isEmpty() && (leftInitializer = (fragment = (VariableDeclarationFragment)fragments.get(0)).getInitializer()) == null && (copyOfRightInitializer = ASTNode.copySubtree((AST)astRootUpdate.getAST(), (ASTNode)rightInitializer)) instanceof Expression) {
                                        fragment.setInitializer((Expression)copyOfRightInitializer);
                                        needSave = true;
                                    }
                                    if (this.updateCreatedJavadoc(rightJavadoc, (BodyDeclaration)((FieldDeclaration)createdFieldNode), astRootUpdate)) {
                                        needSave = true;
                                    }
                                    if (needSave) {
                                        this.saveRightAstContent();
                                    }
                                }
                            }
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                } else if (leftId.startsWith("~")) {
                    if (rightType instanceof IType && rightElement instanceof IMethod) {
                        try {
                            String newLeftContent = this.replaceLeftBody(leftContent, (IMethod)rightElement);
                            if (newLeftContent.isEmpty()) {
                                newLeftContent = leftContent;
                            }
                            this.astNeedsRefresh = true;
                            CompilationUnit astRoot = this.getRightAstRoot();
                            ASTNode rightElementNode = this.getAstNode(rightElement, astRoot);
                            Javadoc rightJavadoc = null;
                            if (rightElementNode instanceof MethodDeclaration) {
                                MethodDeclaration rightMethodDeclaration = (MethodDeclaration)rightElementNode;
                                rightJavadoc = rightMethodDeclaration.getJavadoc();
                            }
                            IMethod createdMethod = ((IType)rightType).createMethod(newLeftContent, (IJavaElement)this.getNextMember((IMember)((IMethod)rightElement)), true, null);
                            ((IMethod)rightElement).delete(true, null);
                            cu = ((IMethod)rightElement).getCompilationUnit();
                            cu.save(null, true);
                            boolean needSave = false;
                            this.astNeedsRefresh = true;
                            CompilationUnit astRootUpdate = this.getRightAstRoot();
                            ASTNode createdMethodNode = this.getAstNode((IJavaElement)createdMethod, astRootUpdate);
                            if (createdMethodNode instanceof MethodDeclaration) {
                                MethodDeclaration createdMethodDeclaration = (MethodDeclaration)createdMethodNode;
                                if (this.updateCreatedJavadoc(rightJavadoc, (BodyDeclaration)createdMethodDeclaration, astRootUpdate)) {
                                    needSave = true;
                                }
                                if (needSave) {
                                    this.saveRightAstContent();
                                }
                            }
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                } else if (leftId.startsWith("#")) {
                    if (rightType instanceof ICompilationUnit) {
                        try {
                            if (rightElement instanceof IImportDeclaration) {
                                ((IImportDeclaration)rightElement).delete(true, null);
                            }
                            this.createImports((ICompilationUnit)rightType, leftContent);
                            cu = (ICompilationUnit)rightType;
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                } else if (leftId.startsWith("%")) {
                    if (rightType instanceof ICompilationUnit) {
                        this.createPackageDeclaration((ICompilationUnit)rightType, leftContent);
                        cu = (ICompilationUnit)rightType;
                    }
                } else if (leftId.startsWith("[") && rightType instanceof IType) {
                    try {
                        if (((IType)rightType).isEnum()) {
                            IJavaElement parent = ((IType)rightType).getParent();
                            cu = ((IType)rightType).getCompilationUnit();
                            ((IType)rightType).delete(true, null);
                            if (parent instanceof IType) {
                                ((IType)parent).createType(leftContent, null, true, null);
                            } else if (parent instanceof ICompilationUnit) {
                                ((ICompilationUnit)parent).createType(leftContent, null, true, null);
                            }
                        } else {
                            this.updateType(leftContent, (IType)rightType);
                        }
                    }
                    catch (JavaModelException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                if (cu == null) break block100;
                try {
                    cu.save(null, true);
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
                break block100;
            }
            boolean handleChildren = true;
            if (diffNode.getLeft() instanceof DocumentRangeNode && diffNode.getRight() instanceof DocumentRangeNode) {
                DocumentRangeNode leftDocRangeNode = (DocumentRangeNode)diffNode.getLeft();
                DocumentRangeNode rightDocRangeNode = (DocumentRangeNode)diffNode.getRight();
                if (leftDocRangeNode.getId().startsWith("[") && rightDocRangeNode.getId().startsWith("[")) {
                    IJavaElement rightElement;
                    String leftContent = null;
                    try {
                        leftContent = leftDocRangeNode.getDocument().get(leftDocRangeNode.getRange().offset, leftDocRangeNode.getRange().length);
                    }
                    catch (BadLocationException e) {
                        Activator.log.error((Throwable)e);
                    }
                    if (leftContent != null && !leftContent.isEmpty() && (rightElement = this.getRightType(diffNode)) instanceof IType) {
                        try {
                            if (((IType)rightElement).isEnum()) {
                                IJavaElement parent = ((IType)rightElement).getParent();
                                ((IType)rightElement).delete(true, null);
                                if (parent instanceof IType) {
                                    ((IType)parent).createType(leftContent, null, true, null);
                                    ((IType)parent).getCompilationUnit().save(null, true);
                                } else if (parent instanceof ICompilationUnit) {
                                    ((ICompilationUnit)parent).createType(leftContent, null, true, null);
                                    ((ICompilationUnit)parent).save(null, true);
                                }
                                handleChildren = false;
                            } else {
                                this.updateType(leftContent, (IType)rightElement);
                            }
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            }
            if (handleChildren) {
                IDiffElement[] iDiffElementArray = diffNode.getChildren();
                int n = iDiffElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IDiffElement childDiffNode = iDiffElementArray[n3];
                    if (childDiffNode instanceof DiffNode) {
                        this.handleDifferences((DiffNode)childDiffNode);
                    }
                    ++n3;
                }
            }
        }
    }

    private IJavaElement getRightType(DiffNode diffNode) {
        if (diffNode == null || !(diffNode.getRight() instanceof DocumentRangeNode) || this.rightFile == null) {
            return null;
        }
        IJavaElement rightJavaFile = JavaCore.create((IFile)this.rightFile);
        DocumentRangeNode rightDocRangeNode = (DocumentRangeNode)diffNode.getRight();
        if (rightJavaFile instanceof ICompilationUnit) {
            ICompilationUnit rightCompilationUnit = (ICompilationUnit)rightJavaFile;
            if (rightDocRangeNode.getId() != null) {
                if (rightDocRangeNode.getId().startsWith("{") || rightDocRangeNode.getId().startsWith("<") || rightDocRangeNode.getId().startsWith("%")) {
                    return rightCompilationUnit;
                }
                if (rightDocRangeNode.getId().startsWith("[")) {
                    String typeName = null;
                    int rightOffset = rightDocRangeNode.getRange().getOffset();
                    int rightLength = rightDocRangeNode.getRange().getLength();
                    try {
                        List types;
                        String typeContent = rightDocRangeNode.getDocument().get(rightOffset, rightLength);
                        ASTNode cu = this.getASTNodeFromString("package default;" + typeContent, 8);
                        if (cu instanceof CompilationUnit && !(types = ((CompilationUnit)cu).types()).isEmpty()) {
                            AbstractTypeDeclaration type = (AbstractTypeDeclaration)types.get(0);
                            typeName = type.getName().toString();
                        }
                    }
                    catch (BadLocationException e) {
                        Activator.log.error((Throwable)e);
                    }
                    if (typeName != null && !typeName.isEmpty()) {
                        try {
                            IType[] types;
                            IType[] iTypeArray = types = rightCompilationUnit.getAllTypes();
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IType type = iTypeArray[n2];
                                if (type.getElementName().equals(typeName)) {
                                    return type;
                                }
                                ++n2;
                            }
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            }
            return this.getRightType((DiffNode)diffNode.getParent());
        }
        return null;
    }

    private IJavaElement getRightElement(DiffNode diffNode) {
        if (diffNode == null || !(diffNode.getRight() instanceof DocumentRangeNode) || this.rightFile == null) {
            return null;
        }
        IJavaElement rightJavaFile = JavaCore.create((IFile)this.rightFile);
        DocumentRangeNode rightDocRangeNode = (DocumentRangeNode)diffNode.getRight();
        if (rightJavaFile instanceof ICompilationUnit) {
            ICompilationUnit rightCompilationUnit = (ICompilationUnit)rightJavaFile;
            try {
                Document currentDocument = new Document(rightCompilationUnit.getSource());
                IDocument rightDocument = rightDocRangeNode.getDocument();
                try {
                    String rightContent = rightDocument.get(rightDocRangeNode.getRange().getOffset(), rightDocRangeNode.getRange().getLength());
                    FindReplaceDocumentAdapter findReplace = new FindReplaceDocumentAdapter((IDocument)currentDocument);
                    IRegion found = findReplace.find(0, rightContent, true, true, false, false);
                    if (found != null) {
                        int length = found.getLength() / 2;
                        if (found.getLength() == 1) {
                            length = 1;
                        }
                        int index = found.getOffset() + length;
                        try {
                            return rightCompilationUnit.getElementAt(index);
                        }
                        catch (JavaModelException e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                catch (BadLocationException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    private void removeOldElement(IJavaElement createdElement, IJavaElement rightElement, int rightLength) {
        if (createdElement instanceof ISourceReference & rightElement != null) {
            IJavaElement parent;
            ICompilationUnit cu = null;
            if (rightElement instanceof IMember) {
                cu = ((IMember)rightElement).getCompilationUnit();
            } else if (rightElement instanceof IImportDeclaration) {
                IJavaElement containerParent;
                parent = ((IImportDeclaration)rightElement).getParent();
                if (parent instanceof IImportContainer && (containerParent = parent.getParent()) instanceof ICompilationUnit) {
                    cu = (ICompilationUnit)containerParent;
                }
            } else if (rightElement instanceof IPackageDeclaration) {
                parent = ((IPackageDeclaration)rightElement).getParent();
                if (parent instanceof ICompilationUnit) {
                    cu = (ICompilationUnit)parent;
                }
            } else if (rightElement instanceof IImportContainer && (parent = ((IImportContainer)rightElement).getParent()) instanceof ICompilationUnit) {
                cu = (ICompilationUnit)parent;
            }
            if (cu != null) {
                try {
                    int index = ((ISourceReference)createdElement).getSourceRange().getOffset() + ((ISourceReference)createdElement).getSourceRange().getLength() + rightLength;
                    IJavaElement javaElement = cu.getElementAt(index);
                    if (javaElement instanceof IMember && rightElement instanceof IMember || javaElement instanceof IImportDeclaration && rightElement instanceof IImportDeclaration || javaElement instanceof IPackageDeclaration && rightElement instanceof IPackageDeclaration || javaElement instanceof IImportContainer && rightElement instanceof IImportContainer) {
                        ((ISourceManipulation)javaElement).delete(true, null);
                    }
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    private IMember getNextMember(IMember member) {
        IType declaringType = member.getDeclaringType();
        if (declaringType != null) {
            IField[] members = null;
            if (member instanceof IField) {
                try {
                    members = declaringType.getFields();
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            } else if (member instanceof IMethod) {
                try {
                    members = declaringType.getMethods();
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (members[i].getElementName().equals(member.getElementName()) && i < members.length - 1) {
                        return members[i + 1];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private CompilationUnit getRightAstRoot() {
        IJavaElement rightJavaFile;
        if ((this.rightAstRoot == null || this.astNeedsRefresh) && this.rightFile != null && (rightJavaFile = JavaCore.create((IFile)this.rightFile)) instanceof ICompilationUnit) {
            ASTParser parser = ASTParser.newParser((int)10);
            parser.setSource((ICompilationUnit)rightJavaFile);
            parser.setResolveBindings(true);
            this.rightAstRoot = (CompilationUnit)parser.createAST(null);
            this.rightAstRoot.recordModifications();
            this.astNeedsRefresh = false;
        }
        return this.rightAstRoot;
    }

    private void saveRightAstContent() {
        IJavaElement rightJavaFile;
        if (this.rightFile != null && (rightJavaFile = JavaCore.create((IFile)this.rightFile)) instanceof ICompilationUnit) {
            ICompilationUnit rightCu = (ICompilationUnit)rightJavaFile;
            CompilationUnit astRoot = this.getRightAstRoot();
            String source = null;
            try {
                source = rightCu.getSource();
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
                return;
            }
            Document document = new Document(source);
            TextEdit edits = astRoot.rewrite((IDocument)document, rightCu.getJavaProject().getOptions(true));
            try {
                edits.apply((IDocument)document);
            }
            catch (MalformedTreeException e) {
                Activator.log.error((Throwable)e);
                return;
            }
            catch (BadLocationException e) {
                Activator.log.error((Throwable)e);
                return;
            }
            String newSource = document.get();
            try {
                rightCu.getBuffer().setContents(newSource);
                rightCu.save(null, true);
                this.astNeedsRefresh = true;
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
                return;
            }
        }
    }

    private ASTNode getAstNode(IJavaElement javaElement, CompilationUnit astRoot) {
        ASTNode node = null;
        if (astRoot != null) {
            if (javaElement instanceof IType) {
                node = astRoot.findDeclaringNode(((IType)javaElement).getKey());
            } else if (javaElement instanceof IMethod) {
                node = astRoot.findDeclaringNode(((IMethod)javaElement).getKey());
            } else if (javaElement instanceof IField) {
                node = astRoot.findDeclaringNode(((IField)javaElement).getKey());
            }
            if (node == null && javaElement instanceof ISourceReference) {
                try {
                    node = NodeFinder.perform((ASTNode)astRoot, (ISourceRange)((ISourceReference)javaElement).getSourceRange());
                    if (javaElement instanceof IType) {
                        if (node instanceof TypeDeclaration) {
                            return node;
                        }
                        int offset = ((ISourceReference)javaElement).getNameRange().getOffset();
                        int length = ((ISourceReference)javaElement).getNameRange().getLength() + 1;
                        node = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)length);
                    }
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return node;
    }

    private ASTNode getASTNodeFromString(String source, int kind) {
        try {
            ASTParser parser = ASTParser.newParser((int)10);
            parser.setKind(kind);
            parser.setSource(source.toCharArray());
            return parser.createAST(null);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    private void updateType(String leftContent, IType rightType) {
        block29: {
            try {
                boolean differentTypeParameters;
                TypeDeclaration leftTypeDeclaration;
                ASTNode leftNode = this.getASTNodeFromString(leftContent, 4);
                if (!(leftNode instanceof TypeDeclaration) || ((TypeDeclaration)leftNode).bodyDeclarations().size() <= 0 || (leftTypeDeclaration = (TypeDeclaration)((TypeDeclaration)leftNode).bodyDeclarations().get(0)) == null) break block29;
                this.astNeedsRefresh = true;
                CompilationUnit astRoot = this.getRightAstRoot();
                ASTNode rightNode = this.getAstNode((IJavaElement)rightType, astRoot);
                if (!(rightNode instanceof TypeDeclaration)) break block29;
                boolean needSave = false;
                TypeDeclaration rightTypeDeclaration = (TypeDeclaration)rightNode;
                Javadoc rightJavadoc = rightTypeDeclaration.getJavadoc();
                if (leftTypeDeclaration.getModifiers() != rightTypeDeclaration.getModifiers()) {
                    needSave = true;
                    rightTypeDeclaration.modifiers().clear();
                    List newModifiers = astRoot.getAST().newModifiers(leftTypeDeclaration.getModifiers());
                    for (Object object : newModifiers) {
                        IExtendedModifier modifier = (IExtendedModifier)object;
                        rightTypeDeclaration.modifiers().add(modifier);
                    }
                }
                ASTMatcher matcher = new ASTMatcher();
                if (leftTypeDeclaration.getSuperclassType() != null) {
                    ASTNode copyOfLeftSuperClass;
                    boolean differentSuperclass;
                    boolean bl = differentSuperclass = rightTypeDeclaration.getSuperclassType() == null;
                    if (rightTypeDeclaration.getSuperclassType() != null && !rightTypeDeclaration.getSuperclassType().subtreeMatch(matcher, (Object)leftTypeDeclaration.getSuperclassType())) {
                        rightTypeDeclaration.getSuperclassType().delete();
                        differentSuperclass = true;
                    }
                    if (differentSuperclass && (copyOfLeftSuperClass = ASTNode.copySubtree((AST)astRoot.getAST(), (ASTNode)leftTypeDeclaration.getSuperclassType())) instanceof Type) {
                        rightTypeDeclaration.setSuperclassType((Type)copyOfLeftSuperClass);
                        needSave = true;
                    }
                } else if (rightTypeDeclaration.getSuperclassType() != null) {
                    rightTypeDeclaration.getSuperclassType().delete();
                    rightTypeDeclaration.setSuperclassType(null);
                    needSave = true;
                }
                if (!leftTypeDeclaration.isInterface() && !rightTypeDeclaration.isInterface()) {
                    boolean differentInterfaces;
                    List leftSuperInterfaceTypes = leftTypeDeclaration.superInterfaceTypes();
                    List rightSuperInterfaceTypes = rightTypeDeclaration.superInterfaceTypes();
                    boolean bl = differentInterfaces = leftSuperInterfaceTypes.size() != rightSuperInterfaceTypes.size();
                    if (!differentInterfaces) {
                        int i = 0;
                        while (i < leftSuperInterfaceTypes.size()) {
                            Object rightInterfaceType;
                            Type leftInterfaceType = (Type)leftSuperInterfaceTypes.get(i);
                            if (!leftInterfaceType.subtreeMatch(matcher, rightInterfaceType = (Type)rightSuperInterfaceTypes.get(i))) {
                                differentInterfaces = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (differentInterfaces) {
                        needSave = true;
                        rightTypeDeclaration.superInterfaceTypes().clear();
                        List copyOfLeftSuperInterfaceTypes = ASTNode.copySubtrees((AST)astRoot.getAST(), (List)leftTypeDeclaration.superInterfaceTypes());
                        if (copyOfLeftSuperInterfaceTypes != null) {
                            for (Object copyOfLeftSuperInterfaceType : copyOfLeftSuperInterfaceTypes) {
                                if (!(copyOfLeftSuperInterfaceType instanceof Type)) continue;
                                rightTypeDeclaration.superInterfaceTypes().add(copyOfLeftSuperInterfaceType);
                            }
                        }
                    }
                }
                List leftTypeParameters = leftTypeDeclaration.typeParameters();
                List rightTypeParameters = rightTypeDeclaration.typeParameters();
                boolean bl = differentTypeParameters = leftTypeParameters.size() != rightTypeParameters.size();
                if (!differentTypeParameters) {
                    int i = 0;
                    while (i < leftTypeParameters.size()) {
                        Object rightTypeParameter;
                        TypeParameter leftTypeParameter = (TypeParameter)leftTypeParameters.get(i);
                        if (!leftTypeParameter.subtreeMatch(matcher, rightTypeParameter = (TypeParameter)rightTypeParameters.get(i))) {
                            differentTypeParameters = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (differentTypeParameters) {
                    needSave = true;
                    rightTypeDeclaration.typeParameters().clear();
                    List copyOfLeftTypeParameters = ASTNode.copySubtrees((AST)astRoot.getAST(), (List)leftTypeDeclaration.typeParameters());
                    if (copyOfLeftTypeParameters != null) {
                        for (Object copyOfLeftTypeParameter : copyOfLeftTypeParameters) {
                            if (!(copyOfLeftTypeParameter instanceof TypeParameter)) continue;
                            rightTypeDeclaration.typeParameters().add(copyOfLeftTypeParameter);
                        }
                    }
                }
                if (!this.createdJavadocNeedsUpdate(rightJavadoc, leftTypeDeclaration.getJavadoc()) && leftTypeDeclaration.getJavadoc() != null) {
                    ASTNode replacementJavadoc;
                    String leftJavadocString = leftTypeDeclaration.getJavadoc().toString().trim();
                    if (leftJavadocString.length() > 1) {
                        leftJavadocString = leftJavadocString.substring(1, leftJavadocString.length() - 1);
                        leftJavadocString = leftJavadocString.replaceAll(Pattern.quote("*"), EMPTY);
                        leftJavadocString = leftJavadocString.replaceAll(RN_RN, EMPTY).replaceAll(S_PL, EMPTY);
                    }
                    if (!this.isBlank(leftJavadocString) && (replacementJavadoc = ASTNode.copySubtree((AST)astRoot.getAST(), (ASTNode)leftTypeDeclaration.getJavadoc())) instanceof Javadoc) {
                        try {
                            if (rightTypeDeclaration.getJavadoc() != null) {
                                rightTypeDeclaration.getJavadoc().delete();
                            }
                            rightTypeDeclaration.setJavadoc((Javadoc)replacementJavadoc);
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                        needSave = true;
                    }
                }
                if (needSave) {
                    this.saveRightAstContent();
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean updateCreatedJavadoc(Javadoc oldJavadoc, BodyDeclaration bodyDeclaration, CompilationUnit astRoot) {
        if (bodyDeclaration != null && astRoot != null) {
            Javadoc createdJavadoc = bodyDeclaration.getJavadoc();
            return this.updateCreatedJavadoc(oldJavadoc, createdJavadoc, bodyDeclaration, astRoot);
        }
        return false;
    }

    private boolean updateCreatedJavadoc(Javadoc oldJavadoc, Javadoc createdJavadoc, BodyDeclaration bodyDeclaration, CompilationUnit astRoot) {
        ASTNode replacementJavadoc;
        if (bodyDeclaration != null && astRoot != null && this.createdJavadocNeedsUpdate(oldJavadoc, createdJavadoc) && (replacementJavadoc = ASTNode.copySubtree((AST)astRoot.getAST(), (ASTNode)oldJavadoc)) instanceof Javadoc) {
            try {
                if (createdJavadoc != null) {
                    createdJavadoc.delete();
                }
                bodyDeclaration.setJavadoc((Javadoc)replacementJavadoc);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            return true;
        }
        return false;
    }

    private boolean createdJavadocNeedsUpdate(Javadoc oldJavadoc, Javadoc createdJavadoc) {
        String createdJavadocString;
        if (oldJavadoc == null) {
            return false;
        }
        if (createdJavadoc == null) {
            return true;
        }
        String oldJavadocString = oldJavadoc.toString().trim();
        if (oldJavadocString.length() > 1) {
            oldJavadocString = oldJavadocString.substring(1, oldJavadocString.length() - 1);
            oldJavadocString = oldJavadocString.replaceAll(Pattern.quote("*"), EMPTY);
        }
        if ((createdJavadocString = createdJavadoc.toString().trim()).length() > 1) {
            createdJavadocString = createdJavadocString.substring(1, createdJavadocString.length() - 1);
            createdJavadocString = createdJavadocString.replaceAll(Pattern.quote("*"), EMPTY);
        }
        if (oldJavadocString == null || this.isBlank(oldJavadocString)) {
            return false;
        }
        if (createdJavadocString == null || this.isBlank(createdJavadocString)) {
            return true;
        }
        return (oldJavadocString = oldJavadocString.replaceAll(RN_RN, EMPTY).replaceAll(S_PL, EMPTY)).contains(createdJavadocString = createdJavadocString.replaceAll(RN_RN, EMPTY).replaceAll(S_PL, EMPTY)) && oldJavadocString.length() != createdJavadocString.length();
    }

    private void createImports(ICompilationUnit cu, String leftContent) {
        ASTNode cuRoot = this.getASTNodeFromString("package default;" + leftContent + "public class Default{}", 8);
        if (cuRoot instanceof CompilationUnit) {
            for (Object cuImport : ((CompilationUnit)cuRoot).imports()) {
                Name importName = ((ImportDeclaration)cuImport).getName();
                if (importName == null) continue;
                try {
                    cu.createImport(importName.toString(), null, null);
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    private void createPackageDeclaration(ICompilationUnit cu, String leftContent) {
        PackageDeclaration packageDeclaration;
        ASTNode cuRoot = this.getASTNodeFromString(String.valueOf(leftContent) + "public class Default{}", 8);
        if (cuRoot instanceof CompilationUnit && (packageDeclaration = ((CompilationUnit)cuRoot).getPackage()) != null) {
            try {
                cu.createPackageDeclaration(packageDeclaration.getName().toString(), null);
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    private String replaceLeftBody(String leftContent, IMethod rightMethod) {
        block17: {
            try {
                String originalLeftContent = new String(leftContent);
                int beginIndex = leftContent.indexOf("*/");
                String leftJavadoc = leftContent.substring(0, beginIndex + 2);
                leftContent = leftContent.substring(beginIndex + 2, leftContent.length());
                Pattern pattern = Pattern.compile("\\{(.*)\\}", 32);
                Matcher leftMatcher = pattern.matcher(leftContent);
                String leftBody = null;
                if (leftMatcher.find()) {
                    leftBody = leftMatcher.group().trim();
                    if (leftBody.length() <= 2) {
                        return originalLeftContent;
                    }
                    leftBody = leftBody.substring(1, leftBody.length() - 1);
                }
                if (leftBody == null || !this.isBlank(leftBody)) {
                    return originalLeftContent;
                }
                this.astNeedsRefresh = true;
                CompilationUnit astRoot = this.getRightAstRoot();
                ASTNode rightElementNode = this.getAstNode((IJavaElement)rightMethod, astRoot);
                Block rightBlock = null;
                if (rightElementNode instanceof MethodDeclaration) {
                    MethodDeclaration rightMethodDeclaration = (MethodDeclaration)rightElementNode;
                    rightBlock = rightMethodDeclaration.getBody();
                }
                if (rightBlock == null) {
                    return originalLeftContent;
                }
                int offset = -1;
                int length = -1;
                try {
                    offset = rightMethod.getSourceRange().getOffset();
                    length = rightMethod.getSourceRange().getLength();
                    ISourceRange javadocRange = rightMethod.getJavadocRange();
                    if (javadocRange != null) {
                        offset = javadocRange.getOffset() + javadocRange.getLength();
                        length -= javadocRange.getLength();
                    }
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
                if (offset <= -1 || length <= -1) break block17;
                Document rightDocument = null;
                String methodSource = null;
                try {
                    rightDocument = new Document(rightMethod.getCompilationUnit().getSource());
                    methodSource = rightDocument.get(offset, length).trim();
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
                catch (BadLocationException e) {
                    Activator.log.error((Throwable)e);
                }
                if (methodSource != null) {
                    Matcher rightMatcher = pattern.matcher(methodSource);
                    if (!rightMatcher.find()) {
                        return originalLeftContent;
                    }
                    String rightBody = rightMatcher.group().trim();
                    if (rightBody.length() <= 2) {
                        return originalLeftContent;
                    }
                    if (this.isBlank(rightBody = rightBody.substring(1, rightBody.length() - 1))) {
                        return originalLeftContent;
                    }
                    return String.valueOf(leftJavadoc) + leftMatcher.replaceAll(rightMatcher.group(0));
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return EMPTY;
    }
}

