/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.uml.template2structure.internal.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypePartTemplate;
import org.eclipse.papyrus.model2doc.uml.documentstructuretemplate.StereotypePropertyReferencePartTemplate;
import org.eclipse.papyrus.model2doc.uml.template2structure.internal.mappers.AbstractUMLTemplateToStructureMapper;
import org.eclipse.uml2.uml.Element;

public class StereotypePartTemplateMapper
extends AbstractUMLTemplateToStructureMapper<StereotypePartTemplate> {
    public StereotypePartTemplateMapper() {
        super(TEMPLATE_EPACKAGE.getStereotypePartTemplate(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, StereotypePartTemplate stereotypePartTemplate, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!stereotypePartTemplate.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!(semanticModelElement instanceof Element) || !stereotypePartTemplate.isMatchingFilterRule(semanticModelElement)) {
            return Collections.emptyList();
        }
        Title title = null;
        ArrayList returnedElements = new ArrayList();
        if (stereotypePartTemplate.isGenerate() && stereotypePartTemplate.isGenerateTitle()) {
            title = STRUCTURE_EFACTORY.createTitle();
            title.setTitle(stereotypePartTemplate.buildPartTemplateTitle(semanticModelElement));
            returnedElements.add(expectedReturnedClass.cast(title));
        }
        EObject stereotypeApplication = stereotypePartTemplate.getFirstMatchingStereotypeApplication(semanticModelElement);
        for (IBodyPartTemplate currentFeature : stereotypePartTemplate.getBodyPartTemplates()) {
            List result = currentFeature instanceof StereotypePropertyReferencePartTemplate ? (stereotypeApplication == null ? Collections.emptyList() : mappingService.map((EObject)currentFeature, stereotypeApplication, BodyPart.class)) : mappingService.map((EObject)currentFeature, semanticModelElement, BodyPart.class);
            if (result == null) continue;
            if (title != null) {
                title.getSubBodyParts().addAll((Collection)result);
                continue;
            }
            result.stream().forEach(a -> {
                boolean bl = returnedElements.add(expectedReturnedClass.cast(a));
            });
        }
        return returnedElements;
    }
}

