/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProvider;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceSetItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.provider.DocumentStructureTemplateItemProviderAdapterFactory;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.Activator;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor.CustomDocumentStructureTemplateEditor;
import org.eclipse.papyrus.model2doc.integration.emf.documentstructuretemplate.ui.internal.editor.DocumentStructureTemplateEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;

public class NestedDocumentStructureTemplateViewEditor
extends CustomDocumentStructureTemplateEditor {
    protected ServicesRegistry servicesRegistry;
    private DocumentTemplate document;

    public NestedDocumentStructureTemplateViewEditor(ServicesRegistry servicesRegistry, DocumentTemplate rawModel) {
        this.document = rawModel;
        this.servicesRegistry = servicesRegistry;
        Assert.isNotNull((Object)this.document, (String)"The edited DocumentTemplate is null. The DocumentStructureTemplate Editor creation failed");
        Assert.isNotNull((Object)this.servicesRegistry, (String)"The papyrus ServicesRegistry is null. The DocumentStructureTemplate Editor creation failed.");
        this.initializeEditingDomain();
    }

    @Override
    public void initializeEditingDomain() {
        if (this.servicesRegistry == null) {
            return;
        }
        super.initializeEditingDomain();
    }

    public TransactionalEditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        DocumentStructureTemplateEditorInput documentViewEditorInput = new DocumentStructureTemplateEditorInput(this.document);
        super.init(site, (IEditorInput)documentViewEditorInput);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    protected BasicCommandStack createAndInitCommandStack() {
        TransactionalEditingDomain domain = this.getEditingDomain();
        CommandStack stack = domain.getCommandStack();
        Assert.isTrue((boolean)(stack instanceof BasicCommandStack));
        BasicCommandStack bStack = (BasicCommandStack)stack;
        this.addCommandStackListener(bStack);
        return bStack;
    }

    @Override
    protected void initEditingDomain(BasicCommandStack commandStack) {
        TransactionalEditingDomain domain = this.getEditingDomain();
        Assert.isTrue((boolean)(domain instanceof AdapterFactoryEditingDomain));
        this.editingDomain = (AdapterFactoryEditingDomain)domain;
    }

    @Override
    protected void initAdapterFactory() {
        this.adapterFactory = this.createComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CustomResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new DocumentStructureTemplateItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    protected IEditorSite createSite(IEditorPart editor) {
        return this.getEditorSite();
    }

    private class CustomResourceItemProvider
    extends ResourceItemProvider {
        public CustomResourceItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Collection<?> getElements(Object object) {
            return super.getElements(object);
        }

        public boolean hasChildren(Object object) {
            if (object instanceof Resource) {
                return true;
            }
            return super.hasChildren(object);
        }

        public Object getParent(Object object) {
            return super.getParent(object);
        }

        public Collection<?> getChildren(Object object) {
            if (object instanceof Resource) {
                return Collections.singletonList(NestedDocumentStructureTemplateViewEditor.this.document);
            }
            return super.getChildren(object);
        }
    }

    private class CustomResourceItemProviderAdapterFactory
    extends ResourceItemProviderAdapterFactory {
        private CustomResourceItemProviderAdapterFactory() {
        }

        public Adapter createResourceSetAdapter() {
            return new CustomResourceSetItemProvider((AdapterFactory)this);
        }

        public Adapter createResourceAdapter() {
            return new CustomResourceItemProvider((AdapterFactory)this);
        }
    }

    private class CustomResourceSetItemProvider
    extends ResourceSetItemProvider {
        public CustomResourceSetItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Collection<?> getElements(Object object) {
            return Collections.singleton(NestedDocumentStructureTemplateViewEditor.this.document.eResource());
        }
    }
}

