/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations.GeneratorConfigurationOperations;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.odt.emf.structure2document.internal.handler.CreateODTFileFromTextDocumentHelper;

public class GenerateODTFileUtils {
    public static void generateODTFile(TextDocument textDocument) {
        String result;
        CreateODTFileFromTextDocumentHelper helper = new CreateODTFileFromTextDocumentHelper(textDocument);
        helper.generate();
        String path = GeneratorConfigurationOperations.getDocumentFileLocalPath((IDocumentGeneratorConfiguration)textDocument.getDocumentGeneratorConfiguration(), (String)"odt");
        java.net.URI worskpaceURI = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
        if (path.startsWith(worskpaceURI.toString()) && (result = path.replaceFirst(worskpaceURI.toString(), "")) != null && !result.isEmpty()) {
            String projectName = URI.createURI((String)result).segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null) {
                try {
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.log.error(NLS.bind((String)"An exception occured during the refresh of the project {0}", (Object)projectName), (Throwable)e);
                }
            }
        }
    }
}

