/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.operations.GeneratorConfigurationOperations;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Version;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.registry.Template2StructureRegistry;

public class GenerateDocumentStructureCommand
extends RecordingCommand {
    private final Collection<Document> result = new ArrayList<Document>();
    private DocumentTemplate documentTemplate;
    private ITemplate2StructureGenerator generator;
    private String documentVersion;

    public GenerateDocumentStructureCommand(TransactionalEditingDomain domain, DocumentTemplate docTemplate) {
        super(domain, "Generate Document Structure Command", "Create the Document Structure Object and store it in a new file");
        this.documentTemplate = docTemplate;
    }

    public void setVersion(String version) {
        this.documentVersion = version;
    }

    protected void doExecute() {
        Document document = this.generator.generate(this.documentTemplate, this.documentVersion);
        if (document == null) {
            return;
        }
        this.result.add(document);
        Resource templateResource = this.documentTemplate.eResource();
        ResourceSet resourceSet = templateResource.getResourceSet();
        URI documentStructureURI = null;
        IDocumentStructureGeneratorConfiguration configuration = this.documentTemplate.getDocumentStructureGeneratorConfiguration();
        if (configuration == null) {
            Activator.log.warn("The document structure can't be generated, the configuration is not defined in your model.");
            return;
        }
        Version version = document.getVersion();
        documentStructureURI = GeneratorConfigurationOperations.getDocumentStructureFileEcoreURI((IDocumentStructureGeneratorConfiguration)configuration, (String)"pds", (String)(version != null ? version.getVersion() : null));
        ResourceSetImpl rSet = new ResourceSetImpl();
        resourceSet = rSet;
        Resource structureResource = resourceSet.createResource(documentStructureURI);
        structureResource.getContents().add((Object)document);
        try {
            structureResource.save(null);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public boolean canExecute() {
        return super.canExecute();
    }

    protected boolean prepare() {
        boolean res = super.prepare();
        if (res) {
            this.generator = Template2StructureRegistry.INSTANCE.getGenerator(this.documentTemplate);
            res = this.generator != null;
        }
        return res;
    }

    public Collection<?> getResult() {
        return this.result;
    }
}

