/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.ui.menu.handler;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorNameInitializer;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.core.ui.handler.UML2DocHandler;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.DocumentViewFactory;
import org.eclipse.papyrus.model2doc.documentview.DocumentViewPackage;
import org.eclipse.papyrus.model2doc.documentview.representation.PapyrusDocument;
import org.eclipse.papyrus.model2doc.documentview.resource.notation.PapyrusDocumentNotationModel;
import org.eclipse.papyrus.model2doc.documentview.ui.Activator;
import org.eclipse.papyrus.model2doc.documentview.ui.internal.message.Messages;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;

public abstract class CreateDocumentViewEditorHandler
extends UML2DocHandler {
    public boolean execute(final ViewPrototype prototype, final EObject context, String name) {
        String string = name = name != null ? name : this.askName(context, prototype);
        if (name == null) {
            return false;
        }
        StringBuilder documentFileNameBuilder = new StringBuilder();
        String prefixName = this.getPrefixName(context);
        documentFileNameBuilder.append(prefixName);
        documentFileNameBuilder.append("_");
        documentFileNameBuilder.append(name);
        final String documentFileName = documentFileNameBuilder.toString();
        final String documentName = name;
        try {
            final ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(context);
            TransactionalEditingDomain domain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)serviceRegistry);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        String documentKind = ((PapyrusDocument)prototype.getRepresentationKind()).getDocumentKind();
                        String documentRepresentationKindId = prototype.getRepresentationKind().getId();
                        CreateDocumentViewEditorHandler.this.createDocumentViewEditor(serviceRegistry, documentName, documentFileName, documentKind, documentRepresentationKindId, context, this.description);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return false;
        }
    }

    protected void createDocumentViewEditor(ServicesRegistry serviceRegistry, String documentName, String documentFileName, String documentKind, String documentRepresentationKindId, EObject context, String description) throws ServiceException, NotFoundException {
        Document document = DocumentViewFactory.eINSTANCE.createDocument();
        document.setName(documentName);
        document.setDescription(description);
        document.setContext(context);
        document.setOwner(context);
        document.setDocumentKind(documentKind);
        document.setDocumentRepresentationKindId(documentRepresentationKindId);
        if (this.generateDocument(documentFileName)) {
            document.setGeneratedDocumentFileURI(this.getGeneratedDocumentFileURI());
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)serviceRegistry);
            PapyrusDocumentNotationModel documentNotationModel = (PapyrusDocumentNotationModel)modelSet.getModelChecked("org.eclipse.papyrus.model2doc.documentview.resource.notation.DocumentModel");
            documentNotationModel.addDocument(document);
        }
    }

    public String askName(EObject context, ViewPrototype prototype) {
        String defaultName = ((PapyrusDocument)prototype.getRepresentationKind()).getName();
        String nameWithIncrement = EditorNameInitializer.getNameWithIncrement((EClass)DocumentViewPackage.eINSTANCE.getDocument(), (EStructuralFeature)DocumentViewPackage.eINSTANCE.getDocument_Name(), (String)defaultName, (EObject)context);
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateDocumentViewEditorHandler_PapyrusDocumentCreation, Messages.CreateDocumentViewEditorHandler_EnterTheNameForTheNewDocument, nameWithIncrement, null);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private String getPrefixName(EObject context) {
        UMLLabelInternationalization umlLabelInternationalization = UMLLabelInternationalization.getInstance();
        URI uri = context.eResource().getURI();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        String fileNameWithoutExtension = file.getName().substring(0, file.getName().lastIndexOf(46));
        StringBuilder prefixNameBuilder = new StringBuilder();
        prefixNameBuilder.append(fileNameWithoutExtension);
        prefixNameBuilder.append("_");
        prefixNameBuilder.append(umlLabelInternationalization.getLabel((NamedElement)context));
        return prefixNameBuilder.toString();
    }

    public abstract String getGeneratedDocumentFileURI();
}

