/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.generatorconfiguration.properties.internal.factories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.EMFEditUIPropertyEditorFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.DefaultDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.Template2StructureRegistry;
import org.eclipse.swt.widgets.Composite;

public class DocumentStructureGeneratorIdPropertyEditor
extends EMFEditUIPropertyEditorFactory {
    private static final URI SELF_URI = URI.createURI((String)"editor://generatorconfiguration/AbstractDocumentStructureGeneratorConfiguration/structureGeneratorId/");

    public DocumentStructureGeneratorIdPropertyEditor() {
        super(SELF_URI);
    }

    public CellEditor createEditor(Object object, IItemPropertyDescriptor propertyDescriptor, Composite composite) {
        EObject parent;
        DocumentTemplate documentTemplate = null;
        if (object instanceof DefaultDocumentStructureGeneratorConfiguration && (parent = ((DefaultDocumentStructureGeneratorConfiguration)object).eContainer()) instanceof DocumentTemplate) {
            documentTemplate = (DocumentTemplate)parent;
        }
        Assert.isNotNull(documentTemplate);
        ArrayList generators = new ArrayList(Template2StructureRegistry.INSTANCE.getAvailableGenerators(documentTemplate));
        return new DocumentStructureGeneratorExtendedComboBoxCellEditor(composite, generators, (ILabelProvider)new DocumentStructureGeneratorIdLabelProvider());
    }

    public IItemLabelProvider createLabelProvider(Object object, IItemPropertyDescriptor propertyDescriptor) {
        return new DocumentStructureGeneratorLabelProvider();
    }

    private class DocumentStructureGeneratorExtendedComboBoxCellEditor
    extends ExtendedComboBoxCellEditor {
        public DocumentStructureGeneratorExtendedComboBoxCellEditor(Composite composite, List<?> list, ILabelProvider labelProvider) {
            super(composite, list, labelProvider);
        }

        public void doSetValue(Object value) {
            ITemplate2StructureGenerator generator;
            if (value instanceof String && (generator = Template2StructureRegistry.INSTANCE.getGenerator((String)value)) != null) {
                super.doSetValue((Object)generator.getEditorLabel());
            }
            if (value == null) {
                super.doSetValue((Object)"");
                return;
            }
            super.doSetValue(value);
        }

        public Object doGetValue() {
            Object getValue = super.doGetValue();
            if (getValue instanceof ITemplate2StructureGenerator) {
                getValue = ((ITemplate2StructureGenerator)getValue).getGeneratorId();
            }
            return getValue;
        }
    }

    private class DocumentStructureGeneratorIdLabelProvider
    extends LabelProvider {
        private DocumentStructureGeneratorIdLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            if (element instanceof ITemplate2StructureGenerator) {
                return ((ITemplate2StructureGenerator)element).getEditorLabel();
            }
            return super.getText(element);
        }
    }

    private static class DocumentStructureGeneratorLabelProvider
    implements IItemLabelProvider {
        private DocumentStructureGeneratorLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof String) {
                ITemplate2StructureGenerator generator = Template2StructureRegistry.INSTANCE.getGenerator((String)object);
                if (generator != null) {
                    return generator.getEditorLabel();
                }
                return (String)object;
            }
            return "";
        }

        public Object getImage(Object object) {
            return null;
        }
    }
}

