/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.generator.ITemplate2StructureGenerator;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;

public final class Template2StructureRegistry {
    private final String EXTENSION_ID = "org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator";
    private static final String MAPPER = "mapper";
    private static final String GENERATOR = "generator";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String GENERATOR_ID_ATTRIBUTE = "generatorId";
    private Map<String, ITemplate2StructureGenerator> generators = new HashMap<String, ITemplate2StructureGenerator>();
    private Map<String, List<AbstractTemplateToStructureMapper<?>>> mappers = new HashMap();
    public static final Template2StructureRegistry INSTANCE = new Template2StructureRegistry();

    private Template2StructureRegistry() {
        this.readContribution();
    }

    private void readContribution() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (GENERATOR.equals(iConfigurationElement.getName())) {
                this.readDocumentStructureGeneratorContribution(iConfigurationElement);
            }
            if (MAPPER.equals(iConfigurationElement.getName())) {
                this.readMapperContribution(iConfigurationElement);
            }
            ++n2;
        }
    }

    private void readDocumentStructureGeneratorContribution(IConfigurationElement iConfigurationElement) {
        Assert.isTrue((boolean)GENERATOR.equals(iConfigurationElement.getName()));
        String registeredId = iConfigurationElement.getAttribute(ID_ATTRIBUTE);
        ITemplate2StructureGenerator generator = null;
        try {
            generator = (ITemplate2StructureGenerator)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.log.error(NLS.bind((String)"The generator {0} can't be loaded.", (Object)iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
        }
        if (generator != null) {
            String expectedId;
            if (registeredId == null || registeredId.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"The contributed generator {0} is ignored because you don't define id for it in your extension point contribution {1}", (Object)generator.toString(), (Object)"org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator/generator"));
            }
            if (!registeredId.equals(expectedId = generator.getGeneratorId())) {
                ArrayList<String> messageParameters = new ArrayList<String>();
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                messageParameters.add(expectedId);
                Activator.log.warn(NLS.bind((String)"The generator {0} is declared with the id {1} is the extension point contribution, but it should be {2} as declared inside it. We ignore it.", (Object[])messageParameters.toArray()));
                return;
            }
            if (this.generators.containsKey(registeredId)) {
                ArrayList<String> messageParameters = new ArrayList<String>();
                messageParameters.add(this.generators.get(registeredId).toString());
                messageParameters.add(generator.toString());
                messageParameters.add(registeredId);
                Activator.log.warn(NLS.bind((String)"The generators {0} and {1} are regitered with the same id {3}. We ignore the second one", (Object[])messageParameters.toArray()));
                return;
            }
            this.generators.put(registeredId, generator);
        }
    }

    private void readMapperContribution(IConfigurationElement iConfigurationElement) {
        String contributedGenerator = iConfigurationElement.getAttribute(GENERATOR_ID_ATTRIBUTE);
        AbstractTemplateToStructureMapper mapper = null;
        try {
            mapper = (AbstractTemplateToStructureMapper)iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.log.error(NLS.bind((String)"The mapper {0} can't be loaded.", (Object)iConfigurationElement.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
        }
        if (mapper != null) {
            List<AbstractTemplateToStructureMapper<?>> list;
            if (contributedGenerator == null || contributedGenerator.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"The contributed mapper {0} is ignored because you don't define id for it in your extension point contribution {1}", (Object)mapper.toString(), (Object)"org.eclipse.papyrus.model2doc.emf.template2structure.structuregenerator/mapper"));
            }
            if ((list = this.mappers.get(contributedGenerator)) == null) {
                list = new ArrayList();
                this.mappers.put(contributedGenerator, list);
            }
            list.add(mapper);
        }
    }

    public final ITemplate2StructureGenerator getGenerator(String generatorId) {
        Assert.isNotNull((Object)generatorId);
        ITemplate2StructureGenerator generator = this.generators.get(generatorId);
        if (generator == null) {
            Activator.log.warn(NLS.bind((String)"The is no generator registered with the id {0}", (Object)generatorId));
        }
        return generator;
    }

    public ITemplate2StructureGenerator getGenerator(DocumentTemplate docTemplate) {
        Assert.isNotNull((Object)docTemplate);
        IDocumentStructureGeneratorConfiguration conf = docTemplate.getDocumentStructureGeneratorConfiguration();
        if (conf != null) {
            return this.getGenerator(conf.getStructureGeneratorId());
        }
        return null;
    }

    public List<AbstractTemplateToStructureMapper<?>> getMappers(DocumentTemplate docTemplate) {
        String structureGeneratorId = docTemplate.getDocumentStructureGeneratorConfiguration().getStructureGeneratorId();
        if (structureGeneratorId == null || structureGeneratorId.isEmpty()) {
            Activator.log.warn(NLS.bind((String)"The document structure generator id is not defined for {0}", (Object)docTemplate.toString()));
            return Collections.emptyList();
        }
        List<AbstractTemplateToStructureMapper<?>> returnedMappers = this.mappers.get(structureGeneratorId);
        if (returnedMappers == null) {
            Activator.log.warn(NLS.bind((String)"No mapper defined for generator id {0}", (Object)structureGeneratorId));
            return Collections.emptyList();
        }
        return new LinkedList(returnedMappers);
    }

    public List<ITemplate2StructureGenerator> getAvailableGenerators(DocumentTemplate docTemplate) {
        ArrayList<ITemplate2StructureGenerator> generators = new ArrayList<ITemplate2StructureGenerator>();
        for (ITemplate2StructureGenerator current : this.generators.values()) {
            if (!current.handles(docTemplate)) continue;
            generators.add(current);
        }
        return generators;
    }
}

