/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;

public class PageStyleUtil {
    private PageStyleUtil() {
    }

    public static boolean isPageStyleAlreadyDefined(XTextDocument xTextDocument, XMultiServiceFactory xDocMSF, String pageStyleName) {
        XNameContainer xPageStyleCollection = PageStyleUtil.getPageStyleCollectionContainer(xTextDocument, xDocMSF);
        if (xPageStyleCollection != null) {
            return xPageStyleCollection.hasByName(pageStyleName);
        }
        return false;
    }

    public static XNameContainer getPageStyleCollectionContainer(XTextDocument xTextDocument, XMultiServiceFactory xDocMSF) {
        XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xTextDocument);
        XNameAccess xNameAccess = xSupplier.getStyleFamilies();
        try {
            XNameContainer xPageStyleCollection = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            return xPageStyleCollection;
        }
        catch (NoSuchElementException e) {
            Activator.log.error((Throwable)e);
        }
        catch (WrappedTargetException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    public static final XPropertySet createNewPageStyle(XTextDocument xTextDocument, XMultiServiceFactory xDocMSF, String originalPageStyleName, String newPageStyleName) {
        if (PageStyleUtil.isPageStyleAlreadyDefined(xTextDocument, xDocMSF, newPageStyleName)) {
            return null;
        }
        XNameContainer pageStyleCollection = PageStyleUtil.getPageStyleCollectionContainer(xTextDocument, xDocMSF);
        XPropertySet basePropertySet = PageStyleUtil.getExistingPageStyle(xTextDocument, xDocMSF, originalPageStyleName);
        if (basePropertySet != null) {
            XInterface xInterface;
            try {
                xInterface = (XInterface)xDocMSF.createInstance("com.sun.star.style.PageStyle");
            }
            catch (Exception e1) {
                Activator.log.error((Throwable)e1);
                return null;
            }
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            PropertySetUtil.copyPropertySet(basePropertySet, xPropertySet);
            try {
                pageStyleCollection.insertByName(newPageStyleName, (Object)xPropertySet);
                return xPropertySet;
            }
            catch (ElementExistException | IllegalArgumentException | WrappedTargetException e) {
                Activator.log.error(e);
            }
        }
        return null;
    }

    public static final XPropertySet getExistingPageStyle(XTextDocument xTextDocument, XMultiServiceFactory xDocMSF, String wantedPageStyleName) {
        XNameContainer xPageStyleCollection = PageStyleUtil.getPageStyleCollectionContainer(xTextDocument, xDocMSF);
        if (xPageStyleCollection != null) {
            try {
                Object wantedPageStyle = xPageStyleCollection.getByName(wantedPageStyleName);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)wantedPageStyle);
                return xPropertySet;
            }
            catch (NoSuchElementException e) {
                Activator.log.error((Throwable)e);
            }
            catch (WrappedTargetException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    public static final void createCustomLandscapePageStyle(XTextDocument xTextDocument, XMultiServiceFactory xDocMSF) {
        XPropertySet landscapePropertySet = PageStyleUtil.createNewPageStyle(xTextDocument, xDocMSF, "Standard", "CustomLandscape");
        Integer previousHeight = (Integer)PropertySetUtil.getPropertyValue(landscapePropertySet, "Height");
        Integer previousWidth = (Integer)PropertySetUtil.getPropertyValue(landscapePropertySet, "Width");
        PropertySetUtil.setProperty(landscapePropertySet, "Width", previousHeight);
        PropertySetUtil.setProperty(landscapePropertySet, "Height", previousWidth);
        Size s = new Size(previousHeight.intValue(), previousWidth.intValue());
        PropertySetUtil.setProperty(landscapePropertySet, "Size", s);
        PropertySetUtil.setProperty(landscapePropertySet, "IsLandscape", true);
    }
}

