/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.mapping;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructurePackage;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public abstract class AbstractTemplateToStructureMapper<INPUT extends EObject> {
    protected static final DocumentStructureFactory STRUCTURE_EFACTORY = DocumentStructureFactory.eINSTANCE;
    protected static final DocumentStructurePackage STRUCTURE_EPACKAGE = DocumentStructurePackage.eINSTANCE;
    private final EClass inputEClass;
    private final Class<?> outputClass;

    public <T> AbstractTemplateToStructureMapper(EClass inputEClass, Class<T> outputClass) {
        Assert.isNotNull((Object)inputEClass);
        Assert.isTrue((!inputEClass.isAbstract() ? 1 : 0) != 0, (String)NLS.bind((String)"The EClass {0} is abstract and it should not.", (Object)inputEClass));
        Assert.isNotNull(outputClass);
        this.inputEClass = inputEClass;
        this.outputClass = outputClass;
    }

    public final EClass getInputEClass() {
        return this.inputEClass;
    }

    private final boolean handlesInput(EObject eobject) {
        return this.handlesInput(eobject.eClass());
    }

    public final boolean handlesInput(EClass eClass) {
        return this.inputEClass == eClass;
    }

    public final boolean handlesExpectedOutput(Class<?> clazz) {
        return clazz.isAssignableFrom(this.outputClass);
    }

    public final <T> List<T> map(IMappingService mappingService, EObject documentTemplateElement, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        Assert.isTrue((boolean)this.handlesInput(documentTemplateElement));
        Assert.isTrue((boolean)this.handlesExpectedOutput(expectedReturnedClass));
        List<T> result = this.doMap(mappingService, documentTemplateElement, semanticModelElement, expectedReturnedClass);
        return result;
    }

    protected abstract <T> List<T> doMap(IMappingService var1, INPUT var2, EObject var3, Class<T> var4);
}

