/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.papyrus.model2doc.odt.internal.util.PageUtil;
import org.eclipse.papyrus.model2doc.odt.internal.util.PropertySetUtil;

public class ImageUtil {
    private ImageUtil() {
    }

    public static XTextContent resizeImage(XTextContent graphicContent, String imagePath, XTextDocument xTextDocument, XMultiComponentFactory xMultiComponentFactory, XComponentContext xComponentContext) {
        Size realSizeImage = ImageUtil.getSize100mm(imagePath, xMultiComponentFactory, xComponentContext);
        if (realSizeImage.Width > 0 && realSizeImage.Height > 0) {
            float resizeProportion;
            Size resizeImage = new Size(realSizeImage.Width, realSizeImage.Height);
            Size writableSize = PageUtil.getWritableSize(xTextDocument, "PageStyles", "Standard");
            if (realSizeImage.Width > writableSize.Width) {
                resizeProportion = (float)writableSize.Width / (float)realSizeImage.Width;
                resizeImage.Width = writableSize.Width;
                resizeImage.Height = Math.round((float)resizeImage.Height * resizeProportion);
            }
            if (resizeImage.Height > writableSize.Height) {
                resizeProportion = (float)writableSize.Height / (float)resizeImage.Height;
                resizeImage.Height = writableSize.Height;
                resizeImage.Width = Math.round((float)resizeImage.Width * resizeProportion);
            }
            PropertySetUtil.setProperty(graphicContent, "Width", resizeImage.Width);
            PropertySetUtil.setProperty(graphicContent, "Height", resizeImage.Height);
            PropertySetUtil.setProperty(graphicContent, "RelativeHeightRelation", "scale");
            PropertySetUtil.setProperty(graphicContent, "RelativeWidthRelation", "100");
        }
        return graphicContent;
    }

    public static Size getSize100mm(String imagePath, XMultiComponentFactory xMultiComponentFactory, XComponentContext xComponentContext) {
        XGraphic graphic = ImageUtil.loadImageFile(imagePath, xMultiComponentFactory, xComponentContext);
        if (graphic == null) {
            return null;
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)graphic);
        Size size = null;
        try {
            size = (Size)xPropertySet.getPropertyValue("Size100thMM");
        }
        catch (UnknownPropertyException e) {
            Activator.log.error((Throwable)e);
        }
        catch (WrappedTargetException e) {
            Activator.log.error((Throwable)e);
        }
        return size;
    }

    public static XGraphic loadImageFile(String imagePath, XMultiComponentFactory xMultiComponentFactory, XComponentContext xComponentContext) {
        XGraphicProvider graphicProvider = null;
        try {
            Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xComponentContext);
            graphicProvider = (XGraphicProvider)UnoRuntime.queryInterface(XGraphicProvider.class, (Object)object);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        if (graphicProvider == null) {
            return null;
        }
        PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue()};
        propertyValues[0].Name = "URL";
        propertyValues[0].Value = imagePath;
        XGraphic graphic = null;
        try {
            graphic = graphicProvider.queryGraphic(propertyValues);
        }
        catch (IllegalArgumentException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        catch (WrappedTargetException e) {
            Activator.log.error((Throwable)e);
        }
        return graphic;
    }
}

