/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.dev.tools.handlers;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.dev.tools.Activator;
import org.eclipse.papyrus.model2doc.dev.tools.dialog.NewDocumentPrototypeDialog;
import org.eclipse.papyrus.model2doc.dev.tools.handlers.SelectionUtils;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentStructureTemplateFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplatePrototype;
import org.eclipse.swt.widgets.Display;

public class CreatePrototypeFromTemplateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DocumentTemplate documentTemplate = CreatePrototypeFromTemplateHandler.getSelectedDocumentTemplate();
        if (documentTemplate != null) {
            DocumentTemplate copy = (DocumentTemplate)EcoreUtil.copy((EObject)documentTemplate);
            copy.setKindId("");
            copy.setSemanticContext(null);
            copy.setGraphicalContext(null);
            DocumentTemplatePrototype prototype = DocumentStructureTemplateFactory.eINSTANCE.createDocumentTemplatePrototype();
            prototype.setDescription("");
            prototype.setIconPath(documentTemplate.getIconPath());
            prototype.setType("");
            prototype.setDocumentTemplate(copy);
            copy.setDocumentTemplatePrototype(prototype);
            NewDocumentPrototypeDialog d = new NewDocumentPrototypeDialog(Display.getCurrent().getActiveShell(), prototype);
            if (d.open() == 0) {
                URI initialURI = documentTemplate.eResource().getURI();
                URI newURI = initialURI.trimFileExtension();
                newURI = newURI.trimSegments(1);
                newURI = newURI.appendSegment(d.getFileName()).appendFileExtension("pdst");
                ResourceSetImpl newSet = new ResourceSetImpl();
                Resource res = newSet.createResource(newURI);
                res.getContents().add((Object)prototype);
                try {
                    res.save(null);
                }
                catch (IOException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setBaseEnabled(CreatePrototypeFromTemplateHandler.getSelectedDocumentTemplate() != null);
    }

    private static final DocumentTemplate getSelectedDocumentTemplate() {
        Object selectedElement;
        IStructuredSelection selection = SelectionUtils.getCurrentStructuredSelection();
        if (selection.size() == 1 && (selectedElement = selection.getFirstElement()) instanceof DocumentTemplate) {
            return (DocumentTemplate)selectedElement;
        }
        return null;
    }
}

