/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.gmf.documentstructuretemplate.edit.internal.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainMerger;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramPrototype;
import org.eclipse.papyrus.infra.gmfdiag.representation.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.utils.DocumentStructureTemplateUtils;

public class PapyrusDiagramUtils {
    public static final String UNDEFINED = "<Undefined>";

    private PapyrusDiagramUtils() {
    }

    public static final Collection<PapyrusDiagram> getPapyrusDiagrams(EObject editedElement) {
        DocumentTemplate docTemplate = DocumentStructureTemplateUtils.getDocumentTemplate((EObject)editedElement);
        if (docTemplate == null || docTemplate.getSemanticContext() == null) {
            HashSet<PapyrusDiagram> diagrams = new HashSet<PapyrusDiagram>();
            ArchitectureDomainMerger m = ArchitectureDomainManager.getInstance().getMerger().clone();
            Collection domain = m.getDomains();
            for (MergedArchitectureDomain current : domain) {
                for (MergedArchitectureContext context : current.getContexts()) {
                    for (MergedArchitectureViewpoint v : context.getViewpoints()) {
                        for (RepresentationKind repKind : v.getRepresentationKinds()) {
                            if (!(repKind instanceof PapyrusDiagram)) continue;
                            diagrams.add((PapyrusDiagram)repKind);
                        }
                    }
                }
            }
            return diagrams;
        }
        EObject semanticContext = docTemplate.getSemanticContext();
        PolicyChecker policyChecker = PolicyChecker.getFor((Resource)semanticContext.eResource());
        ArrayList<PapyrusDiagram> result = new ArrayList<PapyrusDiagram>();
        policyChecker.getAllPrototypes().stream().filter(DiagramPrototype.class::isInstance).map(DiagramPrototype.class::cast).forEach(proto -> {
            boolean bl = result.add(proto.getRepresentationKind());
        });
        return result;
    }
}

