/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.moka.animation.presentation.control.AnimationControlView;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatedDiagramTree;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimatingInstanceNode;
import org.eclipse.papyrus.moka.animation.presentation.data.AnimationTreeNodeFactory;
import org.eclipse.papyrus.moka.animation.presentation.data.DiagramAnimationNode;
import org.eclipse.papyrus.moka.animation.presentation.data.IAnimationTreeNode;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.utils.helper.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;

public class DiagramHandler {
    protected HashSet<Diagram> modelDiagrams = new HashSet();
    protected HashMap<EObject, HashSet<Diagram>> modelDiagramMapping = new HashMap();
    protected AnimatedDiagramTree animatedDiagrams;

    public DiagramHandler() {
    }

    public DiagramHandler(Model model) {
        this();
        this.init((EObject)model);
    }

    public void init(EObject modelElement) {
        if (modelElement instanceof Element) {
            InitiliazeDiagramManagerJob diagramsLoading = new InitiliazeDiagramManagerJob(((Element)modelElement).getModel());
            diagramsLoading.schedule();
            try {
                diagramsLoading.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.hookView();
        }
    }

    private void hookView() {
        this.animatedDiagrams = new AnimatedDiagramTree();
        IAnimationTreeNode root = this.animatedDiagrams.getRoot();
        for (Diagram diagram : this.modelDiagrams) {
            root.addChild(AnimationTreeNodeFactory.getInstance().createDiagramAnimationNode(diagram));
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart animationControlView = DiagramHandler.this.getView("org.eclipse.papyrus.moka.animation.presentation.control.controlview", false);
                if (animationControlView != null && animationControlView instanceof AnimationControlView) {
                    ((AnimationControlView)animationControlView).setInitialInput(DiagramHandler.this.animatedDiagrams);
                }
            }
        });
    }

    private IViewPart getView(String ID, boolean restore) {
        IViewPart view = null;
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (view == null && i < viewReferences.length) {
            if (viewReferences[i].getId().equals(ID)) {
                view = viewReferences[i].getView(restore);
            }
            ++i;
        }
        return view;
    }

    private List<Diagram> getAssociatedDiagrams(EObject modelElement, Resource notationResource) {
        ArrayList<Diagram> associatedDiagrams = new ArrayList<Diagram>();
        if (notationResource != null && modelElement != null) {
            return DiagramUtils.getAssociatedDiagramsFromNotationResource((EObject)modelElement, (Resource)notationResource);
        }
        return associatedDiagrams;
    }

    private void searchDiagrams(Model model, IProgressMonitor monitor) {
        Resource resource = model.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        String resourceNotationURI = model.eResource().getURI().toString().replaceAll("\\.uml$", ".notation");
        Resource notationResource = resourceSet.getResource(URI.createURI((String)resourceNotationURI), true);
        monitor.subTask("Find all diagrams");
        TreeIterator modelContentIterator = model.eAllContents();
        while (modelContentIterator.hasNext()) {
            EObject currentModelElement = (EObject)modelContentIterator.next();
            List<Diagram> diagrams = this.getAssociatedDiagrams(currentModelElement, notationResource);
            if (diagrams.isEmpty()) continue;
            this.modelDiagrams.addAll(diagrams);
        }
        monitor.worked(1);
        monitor.subTask("Build mapping with model elements");
        for (Diagram currentDiagram : this.modelDiagrams) {
            TreeIterator diagramViews = currentDiagram.eAllContents();
            while (diagramViews.hasNext()) {
                EObject potentialView = (EObject)diagramViews.next();
                if (!(potentialView instanceof View)) continue;
                EObject modelElement = ((View)potentialView).getElement();
                if (this.modelDiagramMapping.containsKey(modelElement)) {
                    HashSet<Diagram> diagrams = this.modelDiagramMapping.get(modelElement);
                    if (diagrams.contains(currentDiagram)) continue;
                    diagrams.add(currentDiagram);
                    continue;
                }
                HashSet<Diagram> diagramSet = new HashSet<Diagram>();
                diagramSet.add(currentDiagram);
                this.modelDiagramMapping.put(modelElement, diagramSet);
            }
        }
        monitor.worked(1);
    }

    public boolean hasOpenedDiagram(EObject modelElement) {
        boolean opened = false;
        Set diagramSet = this.modelDiagramMapping.get(modelElement);
        if (diagramSet != null) {
            Iterator diagramIterator = diagramSet.iterator();
            while (!opened && diagramIterator.hasNext()) {
                Diagram diagram = (Diagram)diagramIterator.next();
                IEditorPart editorPart = EditorUtils.getEditorPart((EObject)diagram);
                ServicesRegistry servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
                IPageManager pageManager = null;
                try {
                    pageManager = ServiceUtils.getInstance().getIPageManager((Object)servicesRegistry);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                if (pageManager == null) continue;
                opened = pageManager.isOpen((Object)diagram);
            }
        }
        return opened;
    }

    public void openDiagrams(EObject modelElement) {
        HashSet<Diagram> diagrams = this.modelDiagramMapping.get(modelElement);
        if (!diagrams.isEmpty()) {
            for (Diagram diagram : diagrams) {
                IEditorPart editorPart = EditorUtils.getEditorPart((EObject)diagram);
                ServicesRegistry servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
                IPageManager pageManager = null;
                try {
                    pageManager = ServiceUtils.getInstance().getIPageManager((Object)servicesRegistry);
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                if (pageManager == null) continue;
                pageManager.openPage((Object)diagram);
                pageManager.selectPage((Object)diagram);
            }
        }
    }

    public boolean isRenderable(EObject modelElement) {
        Set diagramSet = this.modelDiagramMapping.get(modelElement);
        return diagramSet != null && !diagramSet.isEmpty();
    }

    public boolean isRegistered(IObject_ instance) {
        boolean isRenderable = false;
        if (instance != null && this.animatedDiagrams != null) {
            Iterator<IAnimationTreeNode> nodesIterator = this.animatedDiagrams.getRoot().getChildren().iterator();
            while (!isRenderable && nodesIterator.hasNext()) {
                DiagramAnimationNode node = (DiagramAnimationNode)nodesIterator.next();
                if (!node.hasAnimator(instance)) continue;
                isRenderable = true;
            }
        }
        return isRenderable;
    }

    public Set<Diagram> getAnimatedDiagrams(IObject_ instance) {
        HashSet<Diagram> diagrams = new HashSet<Diagram>();
        if (instance != null && this.animatedDiagrams != null) {
            for (DiagramAnimationNode diagramAnimationNode : this.animatedDiagrams.getRoot().getChildren()) {
                if (!diagramAnimationNode.isAnimatorAllowed(instance)) continue;
                diagrams.add(diagramAnimationNode.getAnimatedDiagram());
            }
        }
        return diagrams;
    }

    public Set<Diagram> findDiagramsInvolved(IObject_ instance) {
        HashSet<Diagram> relatedDiagrams = new HashSet<Diagram>();
        if (instance != null) {
            for (Class type : instance.getTypes()) {
                if (type.isActive() || type instanceof Behavior) {
                    Behavior behavior = null;
                    behavior = type instanceof Behavior ? (Behavior)type : type.getClassifierBehavior();
                    if (behavior != null) {
                        for (Element behaviorElement : behavior.getOwnedElements()) {
                            if (!this.isRenderable((EObject)behaviorElement)) continue;
                            relatedDiagrams.addAll((Collection<Diagram>)this.modelDiagramMapping.get(behaviorElement));
                        }
                    }
                }
                for (Operation currentOperation : type.getOperations()) {
                    for (Behavior currentImplementation : currentOperation.getMethods()) {
                        for (Element behaviorElement : currentImplementation.getOwnedElements()) {
                            if (!this.isRenderable((EObject)behaviorElement)) continue;
                            relatedDiagrams.addAll((Collection<Diagram>)this.modelDiagramMapping.get(behaviorElement));
                        }
                    }
                }
            }
        }
        return relatedDiagrams;
    }

    public void addRenderable(IObject_ instance, Diagram diagram) {
        if (instance != null && diagram != null) {
            for (IAnimationTreeNode node : this.animatedDiagrams.getRoot().getChildren()) {
                if (((DiagramAnimationNode)node).getAnimatedDiagram() != diagram) continue;
                node.addChild(AnimationTreeNodeFactory.getInstance().createAnimatingInstanceNode(instance));
            }
        }
    }

    public void deleteRenderable(IObject_ instance) {
        if (instance != null && this.animatedDiagrams != null) {
            for (IAnimationTreeNode node : this.animatedDiagrams.getRoot().getChildren()) {
                Iterator<IAnimationTreeNode> childrenIterator = node.getChildren().iterator();
                ArrayList<IAnimationTreeNode> unregisteredAnimators = new ArrayList<IAnimationTreeNode>();
                while (childrenIterator.hasNext()) {
                    IAnimationTreeNode animator = childrenIterator.next();
                    if (((AnimatingInstanceNode)animator).instance != instance) continue;
                    unregisteredAnimators.add(animator);
                }
                for (IAnimationTreeNode animator : unregisteredAnimators) {
                    node.removeChild(animator);
                }
            }
        }
    }

    public synchronized void clean() {
        this.modelDiagrams.clear();
        this.modelDiagramMapping.clear();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IViewPart animationControlView = DiagramHandler.this.getView("org.eclipse.papyrus.moka.animation.presentation.control.controlview", false);
                if (animationControlView != null && animationControlView instanceof AnimationControlView) {
                    ((AnimationControlView)animationControlView).dispose();
                }
            }
        });
        this.animatedDiagrams = null;
    }

    class InitiliazeDiagramManagerJob
    extends Job {
        private Model model;

        public InitiliazeDiagramManagerJob(Model model) {
            super("Diagrams lookup");
            this.model = model;
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Prepare execution", 2);
            DiagramHandler.this.searchDiagrams(this.model, monitor);
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

