/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.handlers;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.papyrus.infra.ui.command.AbstractCommandHandler;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.ui.dialogs.ExportImportCSVDialog;
import org.eclipse.papyrus.moka.datavisualization.util.VisualizationUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExportCSVHandler
extends AbstractCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        DataType dataType;
        DataSource dataSource;
        EObject selectedElement = this.getSelectedElement();
        if (selectedElement instanceof DataType && (dataSource = (DataSource)UMLUtil.getStereotypeApplication((Element)(dataType = (DataType)selectedElement), DataSource.class)) != null) {
            return new RecordingCommand(this.getEditingDomain(context)){

                protected void doExecute() {
                    ExportImportCSVDialog dialog = new ExportImportCSVDialog(Display.getCurrent().getActiveShell(), dataType.getName(), true);
                    if (dialog.open() == 0) {
                        String targetFile = dialog.getSelectedPath();
                        String separator = dialog.getSeparator();
                        VisualizationUtil.exportCSV((DataSource)dataSource, (String)targetFile, (String)separator);
                    }
                }
            };
        }
        return null;
    }
}

