/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.values;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.VisitorValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.TokensVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.uml2.uml.NamedElement;

public abstract class ActivityVisitorValueAdapter
extends VisitorValueAdapter {
    public ActivityVisitorValueAdapter(MokaDebugTarget debugTarget, ISemanticVisitor visitor) {
        super(debugTarget, visitor);
    }

    protected abstract NamedElement getNode();

    @Override
    public IVariable[] getVariables() throws DebugException {
        if (this.variables.isEmpty()) {
            this.variables.add(new TokensVariableAdapter(this.debugTarget, ActivityVisitorValueAdapter.getTokens(this.visitor)));
        }
        return this.variables.toArray(new IVariable[0]);
    }

    protected static List<IToken> getTokens(ISemanticVisitor visitor) {
        List<IToken> tokens = new ArrayList();
        if (visitor instanceof IActivityNodeActivation) {
            tokens = ((IActivityNodeActivation)visitor).getTokens();
            if (tokens.isEmpty()) {
                for (IActivityEdgeInstance edgeInstance : ((IActivityNodeActivation)visitor).getIncomingEdges()) {
                    tokens.addAll(ActivityVisitorValueAdapter.getTokens((ISemanticVisitor)edgeInstance));
                }
            }
        } else if (visitor instanceof IActivityEdgeInstance && (tokens = ((IActivityEdgeInstance)visitor).getOfferedTokens()).isEmpty()) {
            tokens.addAll(ActivityVisitorValueAdapter.getTokens((ISemanticVisitor)((IActivityEdgeInstance)visitor).getSource()));
        }
        return tokens;
    }

    public String getReferenceTypeName() throws DebugException {
        NamedElement modelElement = this.getNode();
        if (modelElement != null) {
            return modelElement.getQualifiedName();
        }
        return "<empty>";
    }

    public String getValueString() throws DebugException {
        NamedElement modelElement = this.getNode();
        if (modelElement != null) {
            return modelElement.getQualifiedName();
        }
        return "<empty>";
    }
}

