/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmu;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.moka.fmi.Activator;
import org.eclipse.papyrus.moka.fmi.modeldescription.CoSimulationType;
import org.eclipse.papyrus.moka.fmi.modeldescription.DocumentRoot;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiModelDescriptionType;
import org.eclipse.papyrus.moka.fmi.modeldescription.FmiPackage;
import org.eclipse.papyrus.moka.fmi.modeldescription.util.FmiResourceFactoryImpl;
import org.eclipse.papyrus.moka.fmi.util.FMIOSDetector;
import org.eclipse.papyrus.moka.fmi.util.FMUResourceUtil;
import org.eclipse.papyrus.moka.fmi.util.UnzipUtility;

public class FMUParser {
    File resourceFolder;
    File binariesFolder;
    FmiModelDescriptionType modelDescription;
    String fmuPath;
    File fmuFile;
    File fmuFolder;
    ResourceSet resSet;
    String fmuName;
    boolean isUnzipped = false;

    public FMUParser(String fmuPath) {
        this.initializeParser(fmuPath, true);
    }

    public FMUParser(String fmuPath, boolean autoclean) {
        this.initializeParser(fmuPath, autoclean);
    }

    private void initializeParser(String fmuPath, boolean autoclean) {
        this.initResourceSet();
        this.fmuPath = fmuPath;
        this.fmuFile = new File(fmuPath);
        if (!this.fmuFile.exists()) {
            throw new IllegalArgumentException("file " + fmuPath + " doesn't exist");
        }
        if (this.fmuFile.isFile()) {
            this.fmuName = this.fmuFile.getName();
            if (this.fmuName.contains(".fmu")) {
                this.fmuName = this.fmuName.substring(0, this.fmuFile.getName().lastIndexOf(".fmu"));
            }
            if (autoclean) {
                this.setAutoClean();
            }
            this.initModelDescriptionFromZip();
        } else if (this.fmuFile.isDirectory()) {
            this.fmuFolder = this.fmuFile;
            this.fmuName = this.fmuFile.getName();
            this.isUnzipped = true;
            this.initModelDescriptionFromFolder();
        }
    }

    public void setAutoClean() {
        Runtime.getRuntime().addShutdownHook(new Thread("Clean FMU resource tmp folder for " + this.toString()){

            @Override
            public void run() {
                if (FMUParser.this.fmuFolder != null && FMUParser.this.fmuFolder.exists()) {
                    FMUParser.this.clean();
                }
            }
        });
    }

    private void initModelDescriptionFromFolder() {
        Resource modelDescriptionResource = this.resSet.getResource(URI.createFileURI((String)(String.valueOf(this.fmuFolder.getAbsolutePath()) + File.separator + "modelDescription.xml")), true);
        if (modelDescriptionResource != null && !modelDescriptionResource.getContents().isEmpty() && modelDescriptionResource.getContents().get(0) instanceof DocumentRoot) {
            DocumentRoot root = (DocumentRoot)modelDescriptionResource.getContents().get(0);
            this.modelDescription = root.getFmiModelDescription();
            Resource resFromZip = this.resSet.getResource(FMUResourceUtil.MODEL_DESCRIPTION_ZIP_URI, false);
            if (resFromZip != null && resFromZip.isLoaded()) {
                resFromZip.unload();
            }
        }
    }

    private void initResourceSet() {
        this.resSet = new ResourceSetImpl();
        this.resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new FmiResourceFactoryImpl());
        this.resSet.getPackageRegistry().put(null, (Object)FmiPackage.eINSTANCE);
    }

    public void clean() {
        if (this.fmuFolder != null) {
            try {
                this.deleteFolder(this.fmuFolder);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Failed to clean fmu folder " + this.fmuFolder, (Throwable)e));
            }
        }
    }

    public void unzip(String targetFolderPath, boolean erase) throws IOException {
        File targetFolder;
        boolean isTmp = false;
        if (targetFolderPath == null) {
            targetFolder = Files.createTempDirectory("fmu", new FileAttribute[0]).toFile();
            isTmp = true;
        } else {
            targetFolder = new File(targetFolderPath);
        }
        if (targetFolder.isFile()) {
            throw new IllegalArgumentException("Target path should be a folder");
        }
        if (this.fmuFile == null) {
            throw new IllegalArgumentException("The FMU archive not initialized");
        }
        this.fmuFolder = targetFolder;
        if (this.fmuFolder.exists() && !isTmp) {
            if (erase) {
                this.deleteFolder(this.fmuFolder);
                this.fmuFolder.mkdir();
            } else {
                throw new IllegalArgumentException("FMU folder exists and erase is set to false");
            }
        }
        try {
            UnzipUtility.unzip(this.fmuFile.getAbsolutePath(), this.fmuFolder.getAbsolutePath());
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not unzip fmu archive" + this.fmuFile, (Throwable)e));
        }
        this.initModelDescriptionFromFolder();
        this.isUnzipped = true;
    }

    private void deleteFolder(File folder) throws IOException {
        Path folderPath = folder.toPath();
        Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    private void initModelDescriptionFromZip() {
        block23: {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ZipFile fmuZipFile = new ZipFile(this.fmuFile);){
                    if (fmuZipFile == null) break block23;
                    ZipEntry modelDescriptionEntry = fmuZipFile.getEntry("modelDescription.xml");
                    try {
                        Throwable throwable2 = null;
                        Object var6_11 = null;
                        try (InputStream modelDescriptionStream = fmuZipFile.getInputStream(modelDescriptionEntry);){
                            Resource modelDescriptionResource = this.resSet.createResource(FMUResourceUtil.MODEL_DESCRIPTION_ZIP_URI);
                            modelDescriptionResource.load(modelDescriptionStream, null);
                            if (!modelDescriptionResource.getContents().isEmpty() && modelDescriptionResource.getContents().get(0) instanceof DocumentRoot) {
                                DocumentRoot root = (DocumentRoot)modelDescriptionResource.getContents().get(0);
                                this.modelDescription = root.getFmiModelDescription();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not read modelDescription in FMU " + this.fmuPath, (Throwable)e));
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e1) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not read zipped FMU ", (Throwable)e1));
            }
        }
    }

    public FmiModelDescriptionType getModelDescription() {
        return this.modelDescription;
    }

    public File getFMUFolder() throws IOException {
        if (!this.isUnzipped) {
            this.unzip(null, true);
        }
        return this.fmuFolder;
    }

    public File getCosimulationLibrary() throws FileNotFoundException {
        String dllRelativePath;
        if (!this.isUnzipped) {
            try {
                this.unzip(null, true);
            }
            catch (IOException iOException) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "failed to unzip FMU " + this.fmuName));
                return null;
            }
        }
        if ((dllRelativePath = this.getCosimulationLibraryRelativePath()) == null) {
            String message = "Could not get compute the dll relative path in FMU " + this.fmuName;
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), message));
            throw new FileNotFoundException(message);
        }
        File dllFile = new File(this.fmuFolder + File.separator + dllRelativePath);
        if (!dllFile.exists()) {
            throw new FileNotFoundException("Did not find dll " + dllFile.getAbsolutePath());
        }
        return dllFile;
    }

    public String getCosimulationLibraryRelativePath() {
        if (this.modelDescription != null && !this.modelDescription.getCoSimulation().isEmpty()) {
            CoSimulationType cosimElem = (CoSimulationType)this.modelDescription.getCoSimulation().get(0);
            String identifier = cosimElem.getModelIdentifier();
            if (identifier != null) {
                return "binaries" + File.separator + FMIOSDetector.getOS() + File.separator + identifier + FMIOSDetector.getDLLFileExtension();
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "FMU " + this.fmuName + " does not contain a cosimulation model identifier"));
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "FMU " + this.fmuName + " does not contain a model description with a cosimulation section"));
        }
        return null;
    }

    public File getResourceFolder() throws IOException {
        File fmuFolderFile = this.getFMUFolder();
        File resourceFile = new File(String.valueOf(fmuFolderFile.getAbsolutePath()) + File.separator + "resources");
        if (resourceFile.isFile()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "FMU " + this.fmuName + " resources should be a folder, not a file"));
        }
        if (!resourceFile.exists()) {
            resourceFile.mkdir();
        }
        return resourceFile;
    }
}

