/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine.debug;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.papyrus.moka.discreteevent.AbstractPushPullStrategy;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.fmu.engine.MokaEngineForFMUExport;
import org.eclipse.papyrus.moka.fmu.engine.control.FMUControlService;
import org.eclipse.papyrus.moka.fmu.engine.de.FMIPushPullStrategy;
import org.eclipse.papyrus.moka.fmu.engine.debug.FMUDebugDialog;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.service.IMokaService;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;
import org.eclipse.papyrus.moka.timedfuml.actions._displayCurrentTimeAction;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Class;

public class MokaEngineForFMUDebug
extends MokaEngineForFMUExport {
    protected IProgressMonitor monitor;

    public void stop(IProgressMonitor monitor) {
        super.stop(monitor);
    }

    public void start(IProgressMonitor monitor) {
        Class fmuClass;
        this.monitor = monitor;
        if (!this.mode.equals((Object)IExecutionEngine.OperatingMode.QUIET)) {
            MokaServiceRegistry registry = MokaServiceRegistry.getInstance();
            registry.loadServices();
            for (IMokaService service : registry.getAllServices()) {
                service.init(this.launch, this.executionEntryPoint);
            }
        }
        if ((fmuClass = FMUEngineUtils.getFMUControlService().getFmuClass()) != null) {
            this.startFMU(fmuClass);
            _displayCurrentTimeAction action = new _displayCurrentTimeAction();
            DEScheduler.init((double)-1.0, (AbstractPushPullStrategy)new FMIPushPullStrategy());
            DEScheduler.getInstance().pushPreStepAction((Action)action);
            this.launchMaster();
            FMUControlService controlService = FMUEngineUtils.getFMUControlService();
            controlService.waitForTermination();
        }
    }

    protected void launchMaster() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FMUDebugDialog dialog = new FMUDebugDialog(Display.getDefault().getActiveShell());
                dialog.setBlockOnOpen(false);
                dialog.open();
            }
        });
        FMUEngineUtils.getFMUControlService().getInstantiationLock().release();
    }
}

