/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.assertionlibrary.reporting;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.papyrus.moka.fuml.assertionlibrary.reporting.TestDecision;
import org.eclipse.papyrus.moka.fuml.assertionlibrary.reporting.TestReport;
import org.eclipse.papyrus.moka.fuml.assertionlibrary.utils.ReportNameSingleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Reporter {
    protected List<TestReport> testReports = new ArrayList<TestReport>();
    public static Reporter INSTANCE = new Reporter();

    private Reporter() {
    }

    public boolean add(TestReport report) {
        return this.testReports.add(report);
    }

    public Document getReport() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlReport = builder.newDocument();
        Element testSuiteNode = xmlReport.createElement("testsuite");
        ReportNameSingleton reportNameSingleton = ReportNameSingleton.getInstance();
        String reportName = String.valueOf(reportNameSingleton.getExecutedActivityName()) + "$" + reportNameSingleton.getEngineName();
        testSuiteNode.setAttribute("name", reportName);
        for (TestReport t : this.testReports) {
            testSuiteNode.appendChild(this.toDOMElement(t, xmlReport, reportName));
        }
        xmlReport.appendChild(testSuiteNode);
        this.testReports.clear();
        return xmlReport;
    }

    protected Element toDOMElement(TestReport test, Document context, String prefix) {
        Element testNode = context.createElement("testcase");
        String className = test.getContext() != null ? test.getContext().getQualifiedName() : "unknown";
        if (prefix != null) {
            className = String.valueOf(prefix) + "$" + className;
        }
        testNode.setAttribute("classname", className);
        testNode.setAttribute("name", test.getLabel());
        testNode.setAttribute("time", "0");
        if (test.getVerdict().equals((Object)TestDecision.FAILED)) {
            Element failureNode = context.createElement("failure");
            failureNode.setAttribute("message", test.getLabel());
            failureNode.setAttribute("type", test.getAssertionType().getName());
            testNode.appendChild(failureNode);
        }
        return testNode;
    }

    protected Element toDOMElement(TestReport test, Document context) {
        return this.toDOMElement(test, context, null);
    }
}

