/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.statemachines.Semantics.StateMachines;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateConfiguration;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IStateMachineConfiguration;
import org.eclipse.papyrus.moka.fuml.statemachines.interfaces.Semantics.StateMachines.IVertexActivation;

public class StateConfiguration
implements IStateConfiguration {
    protected IVertexActivation vertexActivation;
    protected IStateConfiguration parent;
    protected List<IStateConfiguration> children;
    private int level = 0;
    private IStateMachineConfiguration completeConfiguration;

    public StateConfiguration(IStateMachineConfiguration configuration) {
        this.vertexActivation = null;
        this.children = new ArrayList<IStateConfiguration>();
        this.completeConfiguration = configuration;
    }

    public StateConfiguration(IVertexActivation activation) {
        this.children = new ArrayList<IStateConfiguration>();
        this.vertexActivation = activation;
    }

    public int getLevel() {
        return this.level;
    }

    public List<IStateConfiguration> getChildren() {
        return this.children;
    }

    public IStateConfiguration getParent() {
        return this.parent;
    }

    public IVertexActivation getVertexActivation() {
        return this.vertexActivation;
    }

    public void setParent(IStateConfiguration configuration) {
        this.parent = configuration;
    }

    public boolean removeChild(IVertexActivation activation) {
        return this.remove(activation, this.getContext(activation));
    }

    public boolean addChild(IVertexActivation activation) {
        return this.add(activation, this.getContext(activation));
    }

    public boolean isConfigurationFor(IVertexActivation activation) {
        return this.isConfigurationFor(activation, this.getContext(activation));
    }

    public boolean isConfigurationFor(IVertexActivation activation, List<IVertexActivation> context) {
        boolean isConfiguration = false;
        if (!context.isEmpty()) {
            int i = 0;
            IStateConfiguration selectedStateConfiguration = null;
            IVertexActivation current = context.get(context.size() - 1);
            while (selectedStateConfiguration == null && i < this.children.size()) {
                if (this.children.get(i).getVertexActivation() == current) {
                    selectedStateConfiguration = this.children.get(i);
                }
                ++i;
            }
            if (selectedStateConfiguration != null) {
                isConfiguration = selectedStateConfiguration.isConfigurationFor(activation, context.subList(0, context.size() - 1));
            }
        } else {
            int i = 0;
            while (!isConfiguration && i < this.children.size()) {
                if (this.children.get(i).getVertexActivation() == activation) {
                    isConfiguration = true;
                }
                ++i;
            }
        }
        return isConfiguration;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<IVertexActivation> getContext(IVertexActivation activation) {
        context /* !! */  = new ArrayList<IVertexActivation>();
        hierarchy = activation.getAscendingHierarchy();
        i = hierarchy.size();
        j = 0;
        found = false;
        ** GOTO lbl15
        {
            if (this.children.get(j).getVertexActivation() == hierarchy.get(i - 1)) {
                found = true;
                context /* !! */  = hierarchy.subList(1, i);
            }
            ++j;
            do {
                if (!found && j < this.children.size()) continue block0;
                j = 0;
                --i;
lbl15:
                // 2 sources

            } while (!found && i >= 1);
        }
        return context /* !! */ ;
    }

    public boolean remove(IVertexActivation activation, List<IVertexActivation> context) {
        boolean removed = false;
        if (!context.isEmpty()) {
            IVertexActivation current = context.get(context.size() - 1);
            IStateConfiguration selectedStateConfiguration = null;
            int i = 0;
            while (i < this.children.size() && selectedStateConfiguration == null) {
                if (this.children.get(i).getVertexActivation() == current) {
                    selectedStateConfiguration = this.children.get(i);
                }
                ++i;
            }
            if (selectedStateConfiguration != null) {
                removed = selectedStateConfiguration.remove(activation, context.subList(0, context.size() - 1));
            }
        } else {
            int i = 0;
            while (i < this.children.size() && !removed) {
                if (this.children.get(i).getVertexActivation() == activation) {
                    this.children.remove(i);
                    removed = true;
                }
                ++i;
            }
        }
        return removed;
    }

    public boolean add(IVertexActivation activation, List<IVertexActivation> context) {
        boolean added = false;
        if (!context.isEmpty()) {
            IVertexActivation current = context.get(context.size() - 1);
            IStateConfiguration selectedStateConfiguration = null;
            int i = 0;
            while (i < this.children.size() && selectedStateConfiguration == null) {
                if (this.children.get(i).getVertexActivation() == current) {
                    selectedStateConfiguration = this.children.get(i);
                }
                ++i;
            }
            if (selectedStateConfiguration != null) {
                added = selectedStateConfiguration.add(activation, context.subList(0, context.size() - 1));
            }
        } else {
            int i = 0;
            boolean alreadyAdded = false;
            while (i < this.children.size() && !alreadyAdded) {
                if (this.children.get(i).getVertexActivation() == activation) {
                    alreadyAdded = true;
                }
                ++i;
            }
            if (!alreadyAdded) {
                StateConfiguration newConfiguration = new StateConfiguration(activation);
                newConfiguration.level = this.level + 1;
                newConfiguration.completeConfiguration = this.completeConfiguration;
                added = this.children.add(newConfiguration);
            }
        }
        return added;
    }

    public String toString() {
        String result = "";
        int i = 0;
        result = this.vertexActivation == null ? "ROOT" : this.vertexActivation.getNode().getName();
        result = String.valueOf(result) + "(L" + this.level + ")";
        if (!this.children.isEmpty()) {
            result = String.valueOf(result) + "[";
            while (i < this.children.size()) {
                result = String.valueOf(result) + this.children.get(i).toString();
                if (i < this.children.size() - 1) {
                    result = String.valueOf(result) + ", ";
                }
                ++i;
            }
            result = String.valueOf(result) + "]";
        }
        return result;
    }
}

