/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.common;

import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.ColorDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.FontDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.LinearScale_Orientation;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.Trace_BaseLine;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.Trace_ErrorBarType;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.Trace_PointStyle;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.Trace_TraceType;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class XYGraphMappingHelper {
    private XYGraphMappingHelper() {
    }

    public static Color mapColorDescriptor(ColorDescriptor color) {
        if (color == null) {
            return new Color((Device)Display.getCurrent(), 0, 0, 0);
        }
        return new Color((Device)Display.getCurrent(), color.getR(), color.getG(), color.getB());
    }

    public static ZoomType mapXYGraphZoomType(org.eclipse.papyrus.moka.xygraph.model.xygraph.ZoomType zoomType) {
        return ZoomType.valueOf((String)zoomType.name());
    }

    public static ColorDescriptor mapColor(Color color) {
        ColorDescriptor c = XYGraphFactory.eINSTANCE.createColorDescriptor();
        c.setR(color.getRed());
        c.setG(color.getGreen());
        c.setB(color.getBlue());
        return c;
    }

    public static org.eclipse.papyrus.moka.xygraph.model.xygraph.ZoomType mapZoomType(ZoomType type) {
        return org.eclipse.papyrus.moka.xygraph.model.xygraph.ZoomType.valueOf((String)type.name());
    }

    public static FontData mapFontDescriptor(FontDescriptor fDesc) {
        return new FontData(fDesc.getName(), fDesc.getSize(), fDesc.getStyle());
    }

    public static FontDescriptor mapFontData(FontData data) {
        FontDescriptor fDesc = XYGraphFactory.eINSTANCE.createFontDescriptor();
        fDesc.setName(data.getName());
        fDesc.setSize(data.getHeight());
        fDesc.setStyle(data.getStyle());
        return fDesc;
    }

    public static LinearScale_Orientation mapOrientation(LinearScale.Orientation orientation) {
        return LinearScale_Orientation.valueOf((String)orientation.name());
    }

    public static Trace.ErrorBarType buildErrorBarType(Trace_ErrorBarType errorBarType) {
        return Trace.ErrorBarType.valueOf((String)errorBarType.getLiteral());
    }

    public static Trace_ErrorBarType descErrorBarType(Trace.ErrorBarType type) {
        return Trace_ErrorBarType.valueOf((String)type.name());
    }

    public static Trace.TraceType buildTraceType(Trace_TraceType traceType) {
        return Trace.TraceType.valueOf((String)traceType.getLiteral());
    }

    public static Trace_TraceType descTraceType(Trace.TraceType type) {
        return Trace_TraceType.valueOf((String)type.name());
    }

    public static Trace.PointStyle buildPointStyle(Trace_PointStyle pointStyle) {
        return Trace.PointStyle.valueOf((String)pointStyle.getLiteral());
    }

    public static Trace_PointStyle descPointStyle(Trace.PointStyle style) {
        return Trace_PointStyle.valueOf((String)style.name());
    }

    public static Trace.BaseLine buildTraceBaseLine(Trace_BaseLine baseLine) {
        return Trace.BaseLine.valueOf((String)baseLine.getLiteral());
    }

    public static Trace_BaseLine descTraceBaseLine(Trace.BaseLine baseLine) {
        return Trace_BaseLine.valueOf((String)baseLine.name());
    }

    public static void populateXYGraph(XYGraph xy, XYGraphDescriptor gDesc) {
        xy.setTitle(gDesc.getTitle());
        xy.setTitleColor(XYGraphMappingHelper.mapColorDescriptor(gDesc.getTitleColor()));
        xy.setTitleFont(new Font((Device)Display.getCurrent(), XYGraphMappingHelper.mapFontDescriptor(gDesc.getTitleFont())));
        xy.setZoomType(XYGraphMappingHelper.mapXYGraphZoomType(gDesc.getZoomType()));
        xy.setShowLegend(gDesc.isShowLegend());
        xy.setShowTitle(gDesc.isShowTitle());
        xy.setTransparent(gDesc.isTransparent());
        xy.getPlotArea().setShowBorder(gDesc.isShowPlotAreaBorder());
        xy.getPlotArea().setBackgroundColor(XYGraphMappingHelper.mapColorDescriptor(gDesc.getPlotAreaBackgroundColor()));
    }
}

