/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.writing.impl;

import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphMappingHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.AxisBuildStrategy;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.AxisDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.LinearScale_Orientation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DefaultAxisBuildStrategy
implements AxisBuildStrategy {
    @Override
    public void rebuildAxes(XYGraphWidgetBinder map) {
        for (AxisDescriptor aDesc : map.getXYGraphDescriptor().getAxisDescriptors()) {
            map.bindAxis(aDesc, this.buildAxis(aDesc));
        }
    }

    protected Axis buildAxis(AxisDescriptor aDesc) {
        Axis axis = new Axis(aDesc.getTitle(), aDesc.getOrientation() == LinearScale_Orientation.VERTICAL);
        axis.setAutoScale(aDesc.isAutoScale());
        axis.setAutoScaleThreshold(aDesc.getAutoScaleThreshold());
        axis.setBackgroundColor(XYGraphMappingHelper.mapColorDescriptor(aDesc.getBackgroundColor()));
        axis.setForegroundColor(XYGraphMappingHelper.mapColorDescriptor(aDesc.getForegroundColor()));
        axis.setMajorGridColor(XYGraphMappingHelper.mapColorDescriptor(aDesc.getMajorGridColor()));
        axis.setMinorGridColor(XYGraphMappingHelper.mapColorDescriptor(aDesc.getMinorGridColor()));
        axis.setRange(aDesc.getRangeLower(), aDesc.getRangeUpper());
        axis.setZoomType(XYGraphMappingHelper.mapXYGraphZoomType(aDesc.getZoomType()));
        axis.setDashGridLine(aDesc.isDashGridLine());
        axis.setLogScale(aDesc.isLogScale());
        axis.setMinorTicksVisible(aDesc.isMinorTicksVisible());
        axis.setShowMajorGrid(aDesc.isShowMajorGrid());
        axis.setShowMinorGrid(aDesc.isShowMinorGrid());
        axis.setPrimarySide(aDesc.isPrimarySide());
        axis.setAutoFormat(aDesc.isAutoFormat());
        axis.setDateEnabled(aDesc.isDateEnabled());
        axis.setFormatPattern(aDesc.getFormatPattern());
        axis.setFont(new Font((Device)Display.getCurrent(), XYGraphMappingHelper.mapFontDescriptor(aDesc.getFont())));
        axis.setTitleFont(new Font((Device)Display.getCurrent(), XYGraphMappingHelper.mapFontDescriptor(aDesc.getTitleFont())));
        return axis;
    }
}

