/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.engine;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.papyrus.moka.animation.engine.rendering.IAnimation;
import org.eclipse.papyrus.moka.debug.breakpoint.MokaBreakpoint;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;
import org.eclipse.papyrus.moka.utils.helper.semantics.SemanticHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;

public class DebugServiceHelper {
    public static DebugServiceHelper INSTANCE = new DebugServiceHelper();

    private DebugServiceHelper() {
    }

    public boolean isActive(IObject_ value) {
        boolean active = false;
        Iterator typesIterator = value.getTypes().iterator();
        while (!active && typesIterator.hasNext()) {
            Classifier type = (Classifier)typesIterator.next();
            if (!(type instanceof Class)) continue;
            boolean bl = active = ((Class)type).isActive() && !((Class)type).isAbstract();
        }
        return active;
    }

    public boolean hasBreakpoint(ISemanticVisitor visitor) {
        boolean breakpointExist = false;
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.papyrus.moka.debug");
        NamedElement visitedModelElement = SemanticHelper.getModelElement((ISemanticVisitor)visitor);
        if (visitedModelElement != null) {
            int i = 0;
            while (!breakpointExist && i < breakpoints.length) {
                MokaBreakpoint breakpoint = (MokaBreakpoint)breakpoints[i];
                boolean isEnabled = false;
                try {
                    isEnabled = breakpoint.isEnabled();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (isEnabled && visitedModelElement == breakpoint.getModelElement()) {
                    breakpointExist = true;
                }
                ++i;
            }
        }
        return breakpointExist;
    }

    public IAnimation getAnimationService() {
        IAnimation animationService = null;
        List services = MokaServiceRegistry.getInstance().getService(IAnimation.class);
        if (!services.isEmpty() && services.size() == 1) {
            animationService = (IAnimation)services.iterator().next();
        }
        return animationService;
    }
}

