/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.controller;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdvice;
import org.eclipse.papyrus.moka.externalcontrol.controller.ControlledVisitorStep;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.controller.IExternallyControlledVisitor;
import org.eclipse.papyrus.moka.externalcontrol.profiling.IExternallyControlledVisitorProfiler;
import org.eclipse.papyrus.moka.externalcontrol.semantics.ExternallyControlledActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;

public abstract class AbstractExternallyControlledVisitor<T extends ISemanticVisitor>
implements IExternallyControlledVisitor<T> {
    protected ExternalController controller;
    protected List<IControllerAdvice> advices = new ArrayList<IControllerAdvice>();
    protected T delegatedVisitor;
    protected List<IToken> suspendedTokens;
    protected Set<AbstractExternallyControlledVisitor<? extends ISemanticVisitor>> suspendedChildren = new HashSet<AbstractExternallyControlledVisitor<? extends ISemanticVisitor>>();
    protected ControlledVisitorStep currentState = ControlledVisitorStep.STARTING;

    public AbstractExternallyControlledVisitor(T visitor, ExternalController controller, List<IControllerAdvice> advices) {
        this.delegatedVisitor = visitor;
        this.controller = controller;
        this.advices = advices;
    }

    protected abstract void doResumeExecution();

    protected abstract void doSemanticAction();

    public abstract IExternallyControlledVisitor<? extends ISemanticVisitor> getStackParent();

    @Override
    public List<IControllerAdvice> getRegisteredAdvices() {
        return this.advices;
    }

    public boolean hasSuspendedChildren() {
        return !this.suspendedChildren.isEmpty();
    }

    public void addSuspendedChild(AbstractExternallyControlledVisitor<? extends ISemanticVisitor> child) {
        this.suspendedChildren.add(child);
    }

    public void removeSuspendedChild(AbstractExternallyControlledVisitor<? extends ISemanticVisitor> child) {
        this.suspendedChildren.remove(child);
    }

    protected void resumeExecution() {
        IExternallyControlledVisitor<ISemanticVisitor> parent = this.getStackParent();
        if (parent instanceof AbstractExternallyControlledVisitor) {
            ((AbstractExternallyControlledVisitor)parent).removeSuspendedChild(this);
        }
        this.doResumeExecution();
    }

    protected void suspendForControl() {
        IExternallyControlledVisitor<ISemanticVisitor> parent = this.getStackParent();
        if (parent instanceof AbstractExternallyControlledVisitor) {
            ((AbstractExternallyControlledVisitor)parent).addSuspendedChild(this);
        }
        this.controller.suspendForControl(this);
    }

    protected void suspendForTime(Double duration) {
        DEScheduler.getInstance().pushEvent(new Event(duration.doubleValue(), new Action(){

            public void execute() {
                AbstractExternallyControlledVisitor.this.currentState = ControlledVisitorStep.FINISHING;
                AbstractExternallyControlledVisitor.this.suspendForControl();
            }
        }));
    }

    protected void doStartActions() {
        for (IControllerAdvice advice : this.advices) {
            advice.doStartAction();
        }
    }

    protected void doFinishActions() {
        for (IControllerAdvice advice : this.advices) {
            advice.doFinishAction();
        }
    }

    protected Double getDuration() {
        Double totalDuration = null;
        for (IControllerAdvice advice : this.advices) {
            Double duration = advice.getDuration();
            if (duration == null) continue;
            totalDuration = totalDuration == null ? duration : Double.valueOf(totalDuration + duration);
        }
        return totalDuration;
    }

    private boolean canStart() {
        boolean result = true;
        Iterator<IControllerAdvice> iter = this.advices.iterator();
        while (iter.hasNext() && result) {
            result &= iter.next().canStart();
        }
        return result;
    }

    private boolean canFinish() {
        boolean result = true;
        Iterator<IControllerAdvice> iter = this.advices.iterator();
        while (iter.hasNext() && result) {
            result &= iter.next().canFinish();
        }
        return result;
    }

    @Override
    public boolean isExecutionAllowed() {
        if (this.hasSuspendedChildren()) {
            return false;
        }
        if (this.currentState == ControlledVisitorStep.STARTING) {
            return this.canStart();
        }
        return this.canFinish();
    }

    @Override
    public void doExecute() {
        if (this.currentState == ControlledVisitorStep.STARTING) {
            this.doStart();
        } else {
            this.doFinish();
        }
    }

    private void doFinish() {
        this.doFinishActions();
        this.currentState = ControlledVisitorStep.STARTING;
        AbstractExternallyControlledVisitor abstractExternallyControlledVisitor = this;
        if (abstractExternallyControlledVisitor instanceof ExternallyControlledActionActivation) {
            IExternallyControlledVisitorProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_externalcontrol_profiling_IExternallyControlledVisitorProfiler$1$812e5498((ExternallyControlledActionActivation)abstractExternallyControlledVisitor);
        }
        abstractExternallyControlledVisitor.resumeExecution();
    }

    private void doStart() {
        this.doStartActions();
        this.doSemanticAction();
        this.currentState = ControlledVisitorStep.FINISHING;
        Double duration = this.getDuration();
        if (duration != null) {
            this.suspendForTime(duration);
            return;
        }
        if (!this.hasSuspendedChildren() && this.canFinish()) {
            this.doFinish();
        } else {
            this.suspendForControl();
        }
    }

    @Override
    public void setController(ExternalController controller) {
        this.controller = controller;
    }

    @Override
    public ExternalController getController() {
        return this.controller;
    }

    @Override
    public void registerAdvice(IControllerAdvice advice) {
        this.advices.add(advice);
    }

    @Override
    public T getDelegatedVisitor() {
        return this.delegatedVisitor;
    }

    @Override
    public ControlledVisitorStep getState() {
        return this.currentState;
    }
}

