/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.semantics;

import java.util.List;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdvice;
import org.eclipse.papyrus.moka.externalcontrol.controller.AbstractExternallyControlledVisitor;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.profiling.IExternallyControlledVisitorProfiler;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityParameterNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventAccepter;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IEventOccurrence;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.Communications.IObjectActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Activities.IntermediateActivities.ActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Activities.IntermediateActivities.ObjectToken;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.CommonBehaviors.BasicBehaviors.ParameterValue;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;

public class ExternallyControlledActivityExecution
extends AbstractExternallyControlledVisitor<ActivityExecution>
implements IActivityExecution {
    protected AbstractExternallyControlledVisitor<? extends ISemanticVisitor> stackParent;

    public ExternallyControlledActivityExecution(ActivityExecution visitor, ExternalController controller, List<IControllerAdvice> advices) {
        super(visitor, controller, advices);
    }

    public AbstractExternallyControlledVisitor<? extends ISemanticVisitor> getStackParent() {
        return this.stackParent;
    }

    public void setStackParent(AbstractExternallyControlledVisitor<? extends ISemanticVisitor> parent) {
        this.stackParent = parent;
    }

    @Override
    protected void doSemanticAction() {
        Activity activity = (Activity)this.getTypes().get(0);
        Debug.println((String)("[execute] Activity " + activity.getName() + "..."));
        Debug.println((String)("[event] Execute activity=" + activity.getName()));
        this.setGroup((IActivityNodeActivationGroup)new ActivityNodeActivationGroup());
        this.getGroup().setActivityExecution_((IActivityExecution)this);
        this.getGroup().activate((List)activity.getNodes(), (List)activity.getEdges());
    }

    @Override
    protected void doResumeExecution() {
        Activity activity = (Activity)this.getTypes().get(0);
        List outputActivations = this.getGroup().getOutputParameterNodeActivations();
        int i = 0;
        while (i < outputActivations.size()) {
            IActivityParameterNodeActivation outputActivation = (IActivityParameterNodeActivation)outputActivations.get(i);
            ParameterValue parameterValue = new ParameterValue();
            parameterValue.parameter = ((ActivityParameterNode)outputActivation.getNode()).getParameter();
            List tokens = outputActivation.getTokens();
            int j = 0;
            while (j < tokens.size()) {
                IToken token = (IToken)tokens.get(j);
                IValue value = ((ObjectToken)token).value;
                if (value != null) {
                    parameterValue.values.add(value);
                    Debug.println((String)("[event] Output activity=" + activity.getName() + " parameter=" + parameterValue.parameter.getName() + " value=" + value));
                }
                ++j;
            }
            this.setParameterValue((IParameterValue)parameterValue);
            ++i;
        }
        Debug.println((String)("[execute] Activity " + activity.getName() + " completed."));
    }

    public void execute() {
        this.suspendForControl();
    }

    public void addType(Class type) {
        ((ActivityExecution)this.delegatedVisitor).addType(type);
    }

    public void removeType(Class type) {
        ((ActivityExecution)this.delegatedVisitor).removeType(type);
    }

    public void startBehavior(Class classifier, List<IParameterValue> inputs) {
        ((ActivityExecution)this.delegatedVisitor).startBehavior(classifier, inputs);
    }

    public IExecution dispatch(Operation operation) {
        return ((ActivityExecution)this.delegatedVisitor).dispatch(operation);
    }

    public void send(IEventOccurrence eventOccurrence) {
        ((ActivityExecution)this.delegatedVisitor).send(eventOccurrence);
    }

    public void register(IEventAccepter accepter) {
        ((ActivityExecution)this.delegatedVisitor).register(accepter);
    }

    public void unregister(IEventAccepter accepter) {
        ((ActivityExecution)this.delegatedVisitor).unregister(accepter);
    }

    public IObjectActivation getObjectActivation() {
        return ((ActivityExecution)this.delegatedVisitor).getObjectActivation();
    }

    public void setObjectActivation(IObjectActivation objectActivation) {
        ((ActivityExecution)this.delegatedVisitor).setObjectActivation(objectActivation);
    }

    public void destroy() {
        ((ActivityExecution)this.delegatedVisitor).destroy();
    }

    public void setLocus(ILocus locus) {
        ((ActivityExecution)this.delegatedVisitor).setLocus(locus);
    }

    public ILocus getLocus() {
        return ((ActivityExecution)this.delegatedVisitor).getLocus();
    }

    public void setIdentifier(String identifier) {
        ((ActivityExecution)this.delegatedVisitor).setIdentifier(identifier);
    }

    public String getIdentifier() {
        return ((ActivityExecution)this.delegatedVisitor).getIdentifier();
    }

    public void addFeatureValues(List<IFeatureValue> oldFeatureValues) {
        ((ActivityExecution)this.delegatedVisitor).addFeatureValues(oldFeatureValues);
    }

    public void addFeatureValuesForType(Classifier type, List<IFeatureValue> oldFeatureValues) {
        ((ActivityExecution)this.delegatedVisitor).addFeatureValuesForType(type, oldFeatureValues);
    }

    public void createFeatureValues() {
        ((ActivityExecution)this.delegatedVisitor).createFeatureValues();
    }

    public List<IFeatureValue> getMemberValues() {
        return ((ActivityExecution)this.delegatedVisitor).getMemberValues();
    }

    public List<IValue> getValues(NamedElement feature, List<IFeatureValue> featureValues) {
        return ((ActivityExecution)this.delegatedVisitor).getValues(feature, featureValues);
    }

    public IFeatureValue getFeatureValue(StructuralFeature feature) {
        return ((ActivityExecution)this.delegatedVisitor).getFeatureValue(feature);
    }

    public void setFeatureValue(StructuralFeature feature, List<IValue> values, Integer position) {
        ((ActivityExecution)this.delegatedVisitor).setFeatureValue(feature, values, position);
    }

    public List<IFeatureValue> getFeatureValues() {
        return ((ActivityExecution)this.delegatedVisitor).getFeatureValues();
    }

    public void setFeatureValues(List<IFeatureValue> featureValues) {
        ((ActivityExecution)this.delegatedVisitor).setFeatureValues(featureValues);
    }

    public ValueSpecification specify() {
        return ((ActivityExecution)this.delegatedVisitor).specify();
    }

    public Boolean equals(IValue otherValue) {
        return ((ActivityExecution)this.delegatedVisitor).equals(otherValue);
    }

    public IValue copy() {
        return ((ActivityExecution)this.delegatedVisitor).copy();
    }

    public IValue new_() {
        return ((ActivityExecution)this.delegatedVisitor).new_();
    }

    public List<Classifier> getTypes() {
        return ((ActivityExecution)this.delegatedVisitor).getTypes();
    }

    public Boolean hasType(Classifier type) {
        return ((ActivityExecution)this.delegatedVisitor).hasType(type);
    }

    public void _endIsolation() {
        ActivityExecution activityExecution = (ActivityExecution)this.delegatedVisitor;
        try {
            activityExecution._endIsolation();
        }
        finally {
            IExternallyControlledVisitorProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$2$b74c5ed0((ISemanticVisitor)activityExecution);
        }
    }

    public void _beginIsolation() {
        ActivityExecution activityExecution = (ActivityExecution)this.delegatedVisitor;
        IExternallyControlledVisitorProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$1$ccbc371e((ISemanticVisitor)activityExecution);
        activityExecution._beginIsolation();
    }

    public void setParameterValue(IParameterValue parameterValue) {
        ((ActivityExecution)this.delegatedVisitor).setParameterValue(parameterValue);
    }

    public IParameterValue getReturnParameterValue() {
        return ((ActivityExecution)this.delegatedVisitor).getReturnParameterValue();
    }

    public IParameterValue getParameterValue(Parameter parameter) {
        return ((ActivityExecution)this.delegatedVisitor).getParameterValue(parameter);
    }

    public List<IParameterValue> getOutputParameterValues() {
        return ((ActivityExecution)this.delegatedVisitor).getOutputParameterValues();
    }

    public Behavior getBehavior() {
        return ((ActivityExecution)this.delegatedVisitor).getBehavior();
    }

    public void terminate() {
        ((ActivityExecution)this.delegatedVisitor).terminate();
    }

    public void setContext(IObject_ context) {
        ((ActivityExecution)this.delegatedVisitor).setContext(context);
    }

    public IObject_ getContext() {
        return ((ActivityExecution)this.delegatedVisitor).getContext();
    }

    public List<IParameterValue> getParameterValues() {
        return ((ActivityExecution)this.delegatedVisitor).getParameterValues();
    }

    public void setGroup(IActivityNodeActivationGroup group) {
        ((ActivityExecution)this.delegatedVisitor).setGroup(group);
    }

    public IActivityNodeActivationGroup getGroup() {
        return ((ActivityExecution)this.delegatedVisitor).getGroup();
    }

    public boolean checkAllParents(Classifier type, Classifier classifier) {
        return ((ActivityExecution)this.delegatedVisitor).checkAllParents(type, classifier);
    }

    public boolean isInstanceOf(Classifier classifier) {
        return ((ActivityExecution)this.delegatedVisitor).isInstanceOf(classifier);
    }
}

