/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.service.IMokaService;

public class MokaServiceRegistry {
    protected static String MOKA_SERVICE_EXTENSION_POIN_ID = "org.eclipse.papyrus.moka.service.service";
    private boolean loaded = false;
    protected HashMap<Class<?>, IMokaService> registry = new HashMap();
    private static MokaServiceRegistry INSTANCE;

    private MokaServiceRegistry() {
    }

    public static MokaServiceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MokaServiceRegistry();
        }
        return INSTANCE;
    }

    public void loadServices() {
        if (!this.loaded) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] configurations = registry.getConfigurationElementsFor(MOKA_SERVICE_EXTENSION_POIN_ID);
            int i = 0;
            while (i < configurations.length) {
                Object instantiatedContribution = null;
                try {
                    instantiatedContribution = configurations[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (instantiatedContribution != null && instantiatedContribution instanceof IMokaService) {
                    this.register((IMokaService)instantiatedContribution);
                }
                ++i;
            }
            this.loaded = true;
        }
    }

    protected void register(IMokaService service) {
        if (service != null) {
            this.registry.put(service.getClass(), service);
        }
    }

    public List<IMokaService> getService(Class<?> clazz) {
        ArrayList<IMokaService> services = new ArrayList<IMokaService>();
        for (Class<?> type : this.registry.keySet()) {
            if (!clazz.isAssignableFrom(type)) continue;
            services.add(this.registry.get(type));
        }
        return services;
    }

    public Collection<IMokaService> getAllServices() {
        return this.registry.values();
    }
}

