/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.visualization.xygraph.dataprovider.AbstractDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.papyrus.moka.xygraph.mapping.util.LightDataSample;
import org.eclipse.papyrus.moka.xygraph.mapping.util.TraceDataBounds;

public class LightDataProvider
extends AbstractDataProvider {
    private List<Double> xValues;
    private List<Double> yValues;
    private List<LightDataSample> samples = new ArrayList<LightDataSample>();
    private boolean dataRangedirty;
    private TraceDataBounds bounds = new TraceDataBounds();

    public LightDataProvider(boolean chronological) {
        super(chronological);
    }

    public void setDataList(List<Double> xl, List<Double> yl) {
        if (xl.size() == 0) {
            return;
        }
        this.xValues = xl;
        this.yValues = yl;
        if (this.samples.size() != 0) {
            this.samples.clear();
        }
        this.samples = new ArrayList<LightDataSample>();
        this.bounds.reset();
        int i = 0;
        while (i < xl.size()) {
            double x = xl.get(i);
            double y = yl.get(i);
            this.bounds.addSample(x, y);
            this.samples.add(new LightDataSample(this, i));
            ++i;
        }
        this.xDataMinMax = new Range(this.bounds.getxMin(), this.bounds.getxMax());
        this.yDataMinMax = new Range(this.bounds.getyMin(), this.bounds.getyMax());
        this.fireDataChange();
        this.dataRangedirty = false;
    }

    public int getSize() {
        return this.samples.size();
    }

    public ISample getSample(int index) {
        return this.samples.get(index);
    }

    public void addSample(double x, double y) {
        double newLowerX = Math.min(this.xDataMinMax.getLower(), x);
        double newUpperX = Math.max(this.xDataMinMax.getUpper(), x);
        double newLowerY = Math.min(this.yDataMinMax.getLower(), y);
        double newUpperY = Math.max(this.yDataMinMax.getUpper(), y);
        if (newLowerX != this.xDataMinMax.getLower() || newUpperX != this.xDataMinMax.getUpper()) {
            this.xDataMinMax = new Range(newLowerX, newUpperX);
        }
        if (newLowerY != this.yDataMinMax.getLower() || newUpperY != this.yDataMinMax.getUpper()) {
            this.yDataMinMax = new Range(newLowerY, newUpperY);
        }
        int index = this.getSize();
        this.samples.add(new LightDataSample(this, index));
        this.fireDataChange();
        this.dataRangedirty = false;
    }

    protected void innerUpdate() {
        this.dataRangedirty = true;
    }

    protected void updateDataRange() {
        if (!this.dataRangedirty) {
            return;
        }
        this.dataRangedirty = false;
        if (this.getSize() > 0) {
            double yMin;
            double xMin;
            int lowerBound = 0;
            double xMax = xMin = this.getXValue(lowerBound);
            double yMax = yMin = this.getYValue(lowerBound);
            int i = lowerBound + 1;
            while (i < this.getSize()) {
                ISample dp = this.getSample(i);
                if (xMin > dp.getXValue() - dp.getXMinusError()) {
                    xMin = dp.getXValue() - dp.getXMinusError();
                }
                if (xMax < dp.getXValue() + dp.getXPlusError()) {
                    xMax = dp.getXValue() + dp.getXPlusError();
                }
                if (yMin > dp.getYValue() - dp.getYMinusError()) {
                    yMin = dp.getYValue() - dp.getYMinusError();
                }
                if (yMax < dp.getYValue() + dp.getYPlusError()) {
                    yMax = dp.getYValue() + dp.getYPlusError();
                }
                ++i;
            }
            this.xDataMinMax = new Range(xMin, xMax);
            this.yDataMinMax = new Range(yMin, yMax);
        } else {
            this.xDataMinMax = null;
            this.yDataMinMax = null;
        }
    }

    public double getXValue(int index) {
        return this.xValues.get(index);
    }

    public double getYValue(int index) {
        return this.yValues.get(index);
    }

    public void clear() {
        this.samples.clear();
        this.xValues = null;
        this.yValues = null;
    }

    public TraceDataBounds getBounds() {
        return this.bounds;
    }
}

