/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.writing.impl;

import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IAxesFactory;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphMappingHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphWidgetBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.writing.XYGraphBuildStrategy;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DefaultXYGraphBuildStrategy
implements XYGraphBuildStrategy {
    @Override
    public IXYGraph buildGraph(final XYGraphWidgetBinder map) {
        XYGraph xy = new XYGraph(new IAxesFactory(){

            public Axis createYAxis() {
                return map.getYAxisPrimary();
            }

            public Axis createXAxis() {
                return map.getXAxisPrimary();
            }
        });
        this.setupXYGraph(xy, map.getXYGraphDescriptor());
        map.bindXYGraph(xy);
        return xy;
    }

    private void setupXYGraph(XYGraph xy, XYGraphDescriptor gDesc) {
        xy.setTitle(gDesc.getTitle());
        xy.setTitleColor(XYGraphMappingHelper.mapColorDescriptor(gDesc.getTitleColor()));
        xy.setTitleFont(new Font((Device)Display.getCurrent(), XYGraphMappingHelper.mapFontDescriptor(gDesc.getTitleFont())));
        xy.setZoomType(XYGraphMappingHelper.mapXYGraphZoomType(gDesc.getZoomType()));
        xy.setShowLegend(gDesc.isShowLegend());
        xy.setShowTitle(gDesc.isShowTitle());
        xy.setTransparent(gDesc.isTransparent());
        xy.getPlotArea().setShowBorder(gDesc.isShowPlotAreaBorder());
        xy.getPlotArea().setBackgroundColor(XYGraphMappingHelper.mapColorDescriptor(gDesc.getPlotAreaBackgroundColor()));
    }
}

