/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.engine.IExecutionEngine;
import org.eclipse.papyrus.moka.service.IMokaService;
import org.eclipse.papyrus.moka.service.MokaServiceRegistry;

public abstract class AbstractExecutionEngine
implements IExecutionEngine {
    protected EObject executionEntryPoint;
    protected String[] executionArgs;
    protected ILaunch launch;
    protected IExecutionEngine.OperatingMode mode;

    @Override
    public void init(ILaunch launch, EObject executionEntryPoint, String[] executionArgs, IExecutionEngine.OperatingMode mode) {
        this.launch = launch;
        this.executionEntryPoint = executionEntryPoint;
        this.executionArgs = executionArgs;
        this.mode = mode;
    }

    @Override
    public void start(IProgressMonitor monitor) {
        if (!this.mode.equals((Object)IExecutionEngine.OperatingMode.QUIET)) {
            MokaServiceRegistry registry = MokaServiceRegistry.getInstance();
            registry.loadServices();
            for (IMokaService service : registry.getAllServices()) {
                service.init(this.launch, this.executionEntryPoint);
            }
        }
    }

    @Override
    public void stop(IProgressMonitor monitor) {
        if (!this.mode.equals((Object)IExecutionEngine.OperatingMode.QUIET)) {
            MokaServiceRegistry registry = MokaServiceRegistry.getInstance();
            monitor.subTask("Dispose Moka services");
            for (IMokaService service : registry.getAllServices()) {
                service.dispose();
            }
        }
    }

    public abstract void initializeArguments(String[] var1);
}

