/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.master.masterproxy;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import jnr.ffi.Pointer;
import jnr.ffi.provider.jffi.NativeClosureManager;
import jnr.ffi.provider.jffi.NativeRuntime;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.StructuredClasses.ICS_Object;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2Port;
import org.eclipse.papyrus.moka.fmi.master.fmilibrary.Fmi2ScalarVariable;
import org.eclipse.papyrus.moka.fmi.master.fmuproxy.Fmu2ProxyService;
import org.eclipse.papyrus.moka.fmi.master.jnr.FMI2AllocatorImpl;
import org.eclipse.papyrus.moka.fmi.master.jnr.FMI2Callbacks;
import org.eclipse.papyrus.moka.fmi.master.jnr.FMI2FreeMemImpl;
import org.eclipse.papyrus.moka.fmi.master.jnr.JNRFMUInterface;
import org.eclipse.papyrus.moka.fmi.master.jnr.SimpleFMI2LoggerImpl;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.CoSimEnvironment;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.DependencyGraph;
import org.eclipse.papyrus.moka.fmi.master.masterlibrary.Experiments;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IParameterValue;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Classes.Kernel.BooleanValue;
import org.eclipse.papyrus.moka.fuml.registry.service.framework.AbstractService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.StructuralFeature;

public class Master2ProxyService
extends AbstractService {
    private JNRFMUInterface.Fmi2Status fmi2Status = JNRFMUInterface.Fmi2Status.fmi2Error;
    private CoSimEnvironment coSimEnv;
    private Experiments experiments;
    private DependencyGraph depGraph;
    FMI2Callbacks callbacks;
    List<Pointer> callBacksPointers = new ArrayList<Pointer>();
    private ArrayList<Fmi2Port> variablesOrder = new ArrayList();
    private ArrayList<Fmi2Port> inputVariables = new ArrayList();
    private List<Fmi2ScalarVariable> loggedVariables = new ArrayList<Fmi2ScalarVariable>();
    private Path traceFile;
    PrintWriter logWriter;
    private SimpleFMI2LoggerImpl logger = new SimpleFMI2LoggerImpl();
    private FMI2AllocatorImpl allocator = new FMI2AllocatorImpl();
    private FMI2FreeMemImpl freeMem = new FMI2FreeMemImpl(this.allocator);
    private Pointer callBackPointer = FMI2Callbacks.getStructDirectPointer(this.logger, this.allocator, this.freeMem, null);

    static {
        NativeClosureManager closureManager = NativeRuntime.getInstance().getClosureManager();
        try {
            Field classLoader = closureManager.getClass().getDeclaredField("classLoader");
            classLoader.setAccessible(true);
            Object asmClassLoader = classLoader.get(closureManager);
            Field parent = asmClassLoader.getClass().getSuperclass().getDeclaredField("parent");
            parent.setAccessible(true);
            parent.set(asmClassLoader, Master2ProxyService.class.getClassLoader());
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Master2ProxyService(Class service) {
        super(service);
    }

    public void setupEnvironment() {
        this.coSimEnv = new CoSimEnvironment(this.getOuter().locus.getExtensionalValues());
        this.coSimEnv.setupPortMapping();
        this.experiments = new Experiments(this.coSimEnv.getContainer());
        this.depGraph = new DependencyGraph(this.coSimEnv);
        this.variablesOrder = this.depGraph.topoSort();
        for (Fmi2Port v : this.variablesOrder) {
            if (!v.getCausality().equals("input")) continue;
            this.inputVariables.add(v);
        }
        this.initializeTraceFile();
    }

    private void initializeTraceFile() {
        Resource modelRes = ((Classifier)this.coSimEnv.getContainer().getTypes().get(0)).eResource();
        URI traceURI = modelRes.getURI().trimSegments(1).appendSegment("fmi_simulation_trace.csv");
        try {
            URL resolvedURL = FileLocator.resolve((URL)new URL(traceURI.toString()));
            this.traceFile = Paths.get(resolvedURL.getFile(), new String[0]);
            this.logWriter = new PrintWriter(this.traceFile.toFile());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String line = "time";
        for (Fmu2ProxyService fmu : this.coSimEnv.getFmus()) {
            StructuralFeature definingFeature = null;
            for (IFeatureValue featValue : ((ICS_Object)fmu.getDirectContainers().get(0)).getFeatureValues()) {
                for (IValue value : featValue.getValues()) {
                    CS_Reference ref;
                    if (!(value instanceof CS_Reference) || !fmu.equals((IValue)(ref = (CS_Reference)value).getCompositeReferent()).booleanValue()) continue;
                    definingFeature = featValue.getFeature();
                    break;
                }
                if (definingFeature != null) break;
            }
            String featName = definingFeature != null ? String.valueOf(definingFeature.getName()) + "." : "";
            for (Fmi2ScalarVariable variable : fmu.variables) {
                if (!this.shouldBeLogged(variable)) continue;
                line = String.valueOf(line) + ";" + featName + variable.getName();
                this.loggedVariables.add(variable);
            }
        }
        this.logWriter.println(line);
    }

    private boolean shouldBeLogged(Fmi2ScalarVariable variable) {
        return variable instanceof Fmi2Port && "output".equals(((Fmi2Port)variable).getCausality());
    }

    public Master2ProxyService getOuter() {
        return this;
    }

    public double round(double value) {
        int pow = (int)Math.round(1.0 / this.experiments.getTolerance());
        int places = (int)Math.ceil(Math.log10(pow));
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public void doOperationExecutionMapping() {
        Class type = (Class)this.types.get(0);
        for (Operation operation : type.getAllOperations()) {
            if (operation.getName().equals("instantiateFmus")) {
                this.operationExecution.put(operation, new InstantiateFmusOperationExecution(operation));
                continue;
            }
            if (operation.getName().equals("initializeFmus")) {
                this.operationExecution.put(operation, new InitializeFmusOperationExecution(operation));
                continue;
            }
            if (operation.getName().equals("doStep")) {
                this.operationExecution.put(operation, new DoStepOperationExecution(operation));
                continue;
            }
            if (!operation.getName().equals("terminateSimulation")) continue;
            this.operationExecution.put(operation, new TerminateSimulationOperationExecution(operation));
        }
    }

    private void updateAndPropagateValues() {
        for (Fmu2ProxyService fmu : this.coSimEnv.getFmus()) {
            fmu.fetchGetCache();
        }
        for (Fmu2ProxyService fmu : this.coSimEnv.getFmus()) {
            for (Fmi2Port input : fmu.inputPorts) {
                input.updateRuntimeValue();
            }
        }
        for (Fmu2ProxyService fmu : this.coSimEnv.getFmus()) {
            fmu.flushSetCache();
        }
    }

    private void logValues(double currentTime) {
        StringBuilder lineBuiler = new StringBuilder("" + currentTime);
        for (Fmi2ScalarVariable loggedVariable : this.loggedVariables) {
            lineBuiler.append(";").append(loggedVariable.getRuntimeValue());
        }
        this.logWriter.println(lineBuiler.toString());
    }

    protected class DoStepOperationExecution
    extends AbstractService.ServiceOperationExecution {
        public DoStepOperationExecution(Operation operation) {
            super((AbstractService)Master2ProxyService.this, operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            System.out.println("Entering in doStep loop");
            double h = Master2ProxyService.this.experiments.getStepSize();
            double systemStartTime = System.currentTimeMillis();
            double simulatedTime = Master2ProxyService.this.experiments.getStartTime();
            int stepNumber = 0;
            while (simulatedTime < Master2ProxyService.this.experiments.getStopTime() && Master2ProxyService.this.fmi2Status == JNRFMUInterface.Fmi2Status.fmi2OK) {
                Master2ProxyService.this.logValues(simulatedTime);
                for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                    Master2ProxyService.this.fmi2Status = fmu.fmi2DoStep(simulatedTime, h, false);
                }
                ++stepNumber;
                Master2ProxyService.this.updateAndPropagateValues();
                simulatedTime += h;
            }
            final double duration = (double)System.currentTimeMillis() - systemStartTime;
            final int finalSteps = stepNumber;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Simulation success", (String)("Successfully Simulated " + finalSteps + " steps in " + duration + " ms"));
                }
            });
            BooleanValue isFinished = new BooleanValue();
            isFinished.setValue(Boolean.valueOf(true));
            ((IParameterValue)this.getOutputParameterValues().get(0)).getValues().add(isFinished);
        }

        public IValue new_() {
            return new DoStepOperationExecution(this.operation);
        }
    }

    protected class InitializeFmusOperationExecution
    extends AbstractService.ServiceOperationExecution {
        public InitializeFmusOperationExecution(Operation operation) {
            super((AbstractService)Master2ProxyService.this, operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                fmu.fmi2EnterInitializationMode();
                System.out.println("Fmu: " + ((Class)fmu.types.get(0)).getName() + " State: Initialization mode... Status: " + (Object)((Object)Master2ProxyService.this.fmi2Status));
            }
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                for (Fmi2ScalarVariable variable : fmu.variables) {
                    if (!variable.getCausality().equals("parameter") || variable.getVariability().equals("constant") || !variable.getInitial().equals("exact") || variable.getRuntimeValue() == null) continue;
                    fmu.fmi2Set(variable);
                }
            }
            System.out.println("\n ====== Initial values propagation=====");
            for (Fmi2Port targetPort : Master2ProxyService.this.inputVariables) {
                Fmi2Port sourcePort = targetPort.getDrivingPort();
                Fmu2ProxyService sourceFmu = sourcePort.getFmu();
                sourceFmu.fmi2Get(sourcePort);
                targetPort.setRuntimeValue(sourcePort.getRuntimeValue());
                Fmu2ProxyService targetFmu = targetPort.getFmu();
                targetFmu.fmi2Set(targetPort);
            }
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                fmu.fetchGetCache();
            }
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                Master2ProxyService.this.fmi2Status = fmu.fmi2ExitInitializationMode();
                System.out.println("Fmu: " + ((Class)fmu.types.get(0)).getName() + " State: Exit initialization mode... Status: " + (Object)((Object)Master2ProxyService.this.fmi2Status));
            }
        }

        public IValue new_() {
            return new InitializeFmusOperationExecution(this.operation);
        }
    }

    protected class InstantiateFmusOperationExecution
    extends AbstractService.ServiceOperationExecution {
        public InstantiateFmusOperationExecution(Operation operation) {
            super((AbstractService)Master2ProxyService.this, operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            Master2ProxyService.this.setupEnvironment();
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                Master2ProxyService.this.fmi2Status = fmu.fmi2Instantiate(Master2ProxyService.this.callBackPointer, false);
                System.out.println("Fmu: " + ((Class)fmu.types.get(0)).getName() + " State: Instantiated... Status: " + (Object)((Object)Master2ProxyService.this.fmi2Status));
                Master2ProxyService.this.fmi2Status = fmu.fmi2SetupExperiment(true, Master2ProxyService.this.experiments.getTolerance(), Master2ProxyService.this.experiments.getStartTime(), true, Master2ProxyService.this.experiments.getStopTime());
                System.out.println("Fmu: " + ((Class)fmu.types.get(0)).getName() + " State: Experiments set up... Status: " + (Object)((Object)Master2ProxyService.this.fmi2Status));
            }
        }

        public IValue new_() {
            return new InstantiateFmusOperationExecution(this.operation);
        }
    }

    protected class TerminateSimulationOperationExecution
    extends AbstractService.ServiceOperationExecution {
        public TerminateSimulationOperationExecution(Operation operation) {
            super((AbstractService)Master2ProxyService.this, operation);
        }

        public void doBody(List<IParameterValue> inputParameters, List<IParameterValue> outputParameters) {
            if (Master2ProxyService.this.fmi2Status != JNRFMUInterface.Fmi2Status.fmi2Error && Master2ProxyService.this.fmi2Status != JNRFMUInterface.Fmi2Status.fmi2Fatal) {
                for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                    Master2ProxyService.this.fmi2Status = fmu.fmi2Terminate();
                    System.out.println("Fmu" + ((Class)fmu.types.get(0)).getName() + " terminates...");
                }
            }
            if (Master2ProxyService.this.fmi2Status != JNRFMUInterface.Fmi2Status.fmi2Fatal) {
                for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                    fmu.fmi2FreeInstance();
                    System.out.println("Fmu" + ((Class)fmu.types.get(0)).getName() + " free memory...");
                }
            }
            System.out.println("Saving simulation trace in file : " + Master2ProxyService.this.traceFile.toString());
            Master2ProxyService.this.logWriter.close();
            for (Fmu2ProxyService fmu : Master2ProxyService.this.coSimEnv.getFmus()) {
                fmu.dispose();
            }
        }

        public IValue new_() {
            return new TerminateSimulationOperationExecution(this.operation);
        }
    }
}

