/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.modeldescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariabilityType implements Enumerator
{
    CONSTANT(0, "constant", "constant"),
    FIXED(1, "fixed", "fixed"),
    TUNABLE(2, "tunable", "tunable"),
    DISCRETE(3, "discrete", "discrete"),
    CONTINUOUS(4, "continuous", "continuous");

    public static final int CONSTANT_VALUE = 0;
    public static final int FIXED_VALUE = 1;
    public static final int TUNABLE_VALUE = 2;
    public static final int DISCRETE_VALUE = 3;
    public static final int CONTINUOUS_VALUE = 4;
    private static final VariabilityType[] VALUES_ARRAY;
    public static final List<VariabilityType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariabilityType[]{CONSTANT, FIXED, TUNABLE, DISCRETE, CONTINUOUS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariabilityType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityType get(int value) {
        switch (value) {
            case 0: {
                return CONSTANT;
            }
            case 1: {
                return FIXED;
            }
            case 2: {
                return TUNABLE;
            }
            case 3: {
                return DISCRETE;
            }
            case 4: {
                return CONTINUOUS;
            }
        }
        return null;
    }

    private VariabilityType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

