/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.table.instancespecification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.moka.ui.table.instancespecification.util.InstanceSpecificationTableUtil;
import org.eclipse.papyrus.uml.nattable.manager.axis.AbstractUMLSynchronizedOnFeatureAxisManager;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;

public class InstanceSpecificationRowAxisManager
extends AbstractUMLSynchronizedOnFeatureAxisManager {
    protected Map<Slot, String> slotToNameMap = null;

    protected List<Object> getFeaturesValue() {
        this.updateSlotToNameMap();
        ArrayList<Object> featureValue = new ArrayList<Object>();
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.slotToNameMap.values());
        Collections.sort(names);
        HashMap<String, Slot> invertedMap = new HashMap<String, Slot>();
        for (Map.Entry<Slot, String> entry : this.slotToNameMap.entrySet()) {
            invertedMap.put(entry.getValue(), entry.getKey());
        }
        for (String sortedName : names) {
            featureValue.add(invertedMap.get(sortedName));
        }
        return featureValue;
    }

    protected Collection<EStructuralFeature> getListenFeatures() {
        Collection listenedFeatures = super.getListenFeatures();
        listenedFeatures.add(UMLPackage.eINSTANCE.getSlot_Value());
        listenedFeatures.add(UMLPackage.eINSTANCE.getInstanceSpecification_Slot());
        return listenedFeatures;
    }

    protected void featureValueHasChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.managedObject.clear();
                this.managedObject.addAll(this.getFeaturesValue());
                this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
                break;
            }
            default: {
                super.featureValueHasChanged(notification);
            }
        }
    }

    public Map<Slot, String> getSlotToNameMap() {
        this.updateSlotToNameMap();
        return this.slotToNameMap;
    }

    protected void updateSlotToNameMap() {
        if (this.getTableContext() instanceof InstanceSpecification) {
            InstanceSpecification contextInstance = (InstanceSpecification)this.getTableContext();
            this.slotToNameMap = InstanceSpecificationTableUtil.collectSlotsAndNames(contextInstance);
        }
    }
}

