/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.xygraph.mapping.common;

import java.util.Collection;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.papyrus.moka.xygraph.mapping.common.XYGraphBinder;
import org.eclipse.papyrus.moka.xygraph.mapping.util.DataBatch;
import org.eclipse.papyrus.moka.xygraph.mapping.util.LUT;
import org.eclipse.papyrus.moka.xygraph.mapping.util.LightDataProvider;
import org.eclipse.papyrus.moka.xygraph.mapping.util.TraceDataBounds;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.AxisDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.LinearScale_Orientation;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;

public class DefaultXYGraphBinder
implements XYGraphBinder {
    private XYGraphDescriptor gDesc;
    private XYGraph xyGraph;
    private Axis xAxisPrimary = null;
    private Axis yAxisPrimary = null;
    private LUT<AxisDescriptor, Axis> axisMap = new LUT();
    private LUT<TraceDescriptor, Trace> traceMap = new LUT();

    public DefaultXYGraphBinder() {
    }

    public DefaultXYGraphBinder(XYGraphDescriptor graphDescriptor) {
        this();
        this.gDesc = graphDescriptor;
    }

    @Override
    public XYGraphDescriptor getXYGraphDescriptor() {
        return this.gDesc;
    }

    @Override
    public void bindAxis(AxisDescriptor aDesc, Axis axis) {
        if (aDesc.getOrientation() == LinearScale_Orientation.HORIZONTAL && this.xAxisPrimary == null) {
            this.xAxisPrimary = axis;
        }
        if (aDesc.getOrientation() == LinearScale_Orientation.VERTICAL && this.yAxisPrimary == null) {
            this.yAxisPrimary = axis;
        }
        this.axisMap.put(aDesc, axis);
    }

    @Override
    public void bindTrace(TraceDescriptor tDesc, Trace trace) {
        this.traceMap.put(tDesc, trace);
    }

    @Override
    public Trace unbindTrace(TraceDescriptor tDesc) {
        return this.traceMap.remove(tDesc);
    }

    @Override
    public Axis getAxisFor(AxisDescriptor aDesc) {
        return this.axisMap.getValueOf(aDesc);
    }

    @Override
    public AxisDescriptor getDescriptorFor(Axis axis) {
        return this.axisMap.getKeyOf(axis);
    }

    @Override
    public Trace getTraceFor(TraceDescriptor tDesc) {
        return this.traceMap.getValueOf(tDesc);
    }

    @Override
    public boolean isTraceMapped(TraceDescriptor tDesc) {
        return this.traceMap.keySet().contains(tDesc);
    }

    @Override
    public TraceDescriptor getDescriptorFor(Trace trace) {
        return this.traceMap.getKeyOf(trace);
    }

    @Override
    public Axis getXAxisPrimary() {
        return this.xAxisPrimary;
    }

    @Override
    public Axis getYAxisPrimary() {
        return this.yAxisPrimary;
    }

    @Override
    public boolean isPrimary(AxisDescriptor aDesc) {
        return this.isPrimary(this.axisMap.getValueOf(aDesc));
    }

    @Override
    public boolean isPrimary(Axis axis) {
        return axis == this.xAxisPrimary || axis == this.yAxisPrimary;
    }

    @Override
    public Collection<Axis> getAxes() {
        return this.axisMap.valueSet();
    }

    @Override
    public Collection<Trace> getTraces() {
        return this.traceMap.valueSet();
    }

    @Override
    public void setGraphDescriptor(XYGraphDescriptor gDesc) {
        this.gDesc = gDesc;
    }

    @Override
    public Collection<TraceDescriptor> getTraceDescriptors() {
        return this.traceMap.keySet();
    }

    @Override
    public Collection<AxisDescriptor> getAxisDescriptors() {
        return this.axisMap.keySet();
    }

    private LightDataProvider getProviderOf(TraceDescriptor tDesc) {
        Trace trace = this.getTraceFor(tDesc);
        return (LightDataProvider)trace.getDataProvider();
    }

    @Override
    public void addTraceSample(TraceDescriptor tDesc, double x, double y) {
        this.getProviderOf(tDesc).addSample(x, y);
    }

    @Override
    public void setTraceData(TraceDescriptor tDesc, DataBatch x, DataBatch y) {
        this.getProviderOf(tDesc).setDataList(x.getValues(), y.getValues());
    }

    @Override
    public void bindXYGraph(XYGraph xy) {
        this.xyGraph = xy;
    }

    @Override
    public XYGraph getXYGraph() {
        return this.xyGraph;
    }

    @Override
    public void dispose() {
        for (TraceDescriptor tDesc : this.gDesc.getTraceDescriptors()) {
            this.getProviderOf(tDesc).clear();
            this.getTraceFor(tDesc).getHotSampleList().clear();
        }
        this.axisMap.dispose();
        this.traceMap.dispose();
    }

    @Override
    public TraceDataBounds getTraceDataBounds(TraceDescriptor tDesc) {
        return this.getProviderOf(tDesc).getBounds();
    }
}

