/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.debug;

import java.util.ArrayList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.debug.engine.AbstractDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.engine.uml.IUMLExecutionEngine;
import org.eclipse.papyrus.moka.engine.uml.debug.UMLDebugExecutionEngineHelper;
import org.eclipse.papyrus.moka.engine.uml.scheduling.UMLTaskExecutionFactory;
import org.eclipse.papyrus.moka.fuml.actions.DefaultCreateObjectActionStrategy;
import org.eclipse.papyrus.moka.fuml.actions.DefaultGetAssociationStrategy;
import org.eclipse.papyrus.moka.fuml.commonbehavior.FIFOGetNextEventStrategy;
import org.eclipse.papyrus.moka.fuml.loci.FirstChoiceStrategy;
import org.eclipse.papyrus.moka.fuml.loci.IExecutionFactory;
import org.eclipse.papyrus.moka.fuml.loci.IExecutor;
import org.eclipse.papyrus.moka.fuml.loci.ILocus;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticStrategy;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLRootTaskExecution;
import org.eclipse.papyrus.moka.fuml.tasks.IUMLTaskExecutionFactory;
import org.eclipse.papyrus.moka.kernel.engine.EngineConfiguration;
import org.eclipse.papyrus.moka.kernel.engine.ExecutionEngineException;
import org.eclipse.papyrus.moka.kernel.scheduling.control.IScheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.control.Scheduler;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.papyrus.moka.pscs.actions.additions.CS_NotNormativeDefaultConstructStrategy;
import org.eclipse.papyrus.moka.pscs.loci.CS_Executor;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_DefaultRequestPropagationStrategy;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_DispatchOperationOfInterfaceStrategy;
import org.eclipse.papyrus.moka.pscs.structuredclassifiers.CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy;
import org.eclipse.papyrus.moka.pssm.loci.SM_ExecutionFactory;
import org.eclipse.papyrus.moka.pssm.loci.SM_Locus;
import org.eclipse.uml2.uml.Element;

public class UMLDebugExecutionEngine
extends AbstractDebuggableExecutionEngine<IObject_, ISemanticVisitor>
implements IUMLExecutionEngine {
    protected ILocus locus;
    protected IUMLTaskExecutionFactory rootTaskFactory;

    public void init(EngineConfiguration<? extends EObject> configuration, SubMonitor monitor) {
        super.init(configuration, monitor);
        this.locus = this.createLocus();
        this.rootTaskFactory = this.createUMLTaskFactory();
        this.locus.getFactory().setTaskFactory(this.rootTaskFactory);
        this.installBuiltInTypes();
        this.installLibraries();
        this.installSemanticStrategies();
    }

    protected IUMLTaskExecutionFactory createUMLTaskFactory() {
        return new UMLTaskExecutionFactory(this.controller.getExecutionLoop());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void start(SubMonitor monitor) throws ExecutionEngineException {
        EObject executionSource = this.configuration.getExecutionSource();
        if (!(executionSource instanceof Element)) throw new IllegalArgumentException("ExecutionSource in configuration must be instanceOf UML::Element");
        Element source = (Element)executionSource;
        if (this.locus == null || source == null) return;
        IUMLRootTaskExecution rootExecution = this.rootTaskFactory.createRootExecution(source);
        if (rootExecution == null) throw new ExecutionEngineException(this.identifier, this.status, "Could not instantiate an execution from the specified element");
        rootExecution.setLocus(this.locus);
        rootExecution.setInputParameterValues(new ArrayList());
        if (!rootExecution.canExecute()) throw new ExecutionEngineException(this.identifier, this.status, "Could not start the execution from the specified model element");
        this.controller.getExecutionLoop().init((ITaskExecution)rootExecution, (IScheduler)new Scheduler());
        SubMonitor progress = monitor.split(1);
        progress.subTask("Run model");
        this.controller.start();
        progress.worked(1);
    }

    public ILocus createLocus() {
        SM_Locus locus = new SM_Locus();
        locus.setExecutor((IExecutor)new CS_Executor());
        locus.setFactory((IExecutionFactory)new SM_ExecutionFactory());
        return locus;
    }

    public void installBuiltInTypes() {
        UMLDebugExecutionEngineHelper.installBuiltInTypes(this.configuration, this.locus);
    }

    public void installLibraries() {
        UMLDebugExecutionEngineHelper.installLibraries(this.configuration, this.locus);
    }

    public void installSemanticStrategies() {
        if (this.locus != null) {
            this.locus.getFactory().setStrategy((ISemanticStrategy)new FirstChoiceStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new FIFOGetNextEventStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new CS_DispatchOperationOfInterfaceStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new CS_NameBased_StructuralFeatureOfInterfaceAccessStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new CS_DefaultRequestPropagationStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new CS_NotNormativeDefaultConstructStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new DefaultGetAssociationStrategy());
            this.locus.getFactory().setStrategy((ISemanticStrategy)new DefaultCreateObjectActionStrategy());
        }
    }
}

